/* build_view.c generated by valac 0.12.1, the Vala compiler
 * generated from build_view.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gtksourceview/gtksourceview.h>


#define TYPE_PARTITION_STATE (partition_state_get_type ())

#define TYPE_BUILD_MSG_TYPE (build_msg_type_get_type ())

#define TYPE_BUILD_MSG (build_msg_get_type ())
typedef struct _BuildMsg BuildMsg;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_BUILD_VIEW (build_view_get_type ())
#define BUILD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_VIEW, BuildView))
#define BUILD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_VIEW, BuildViewClass))
#define IS_BUILD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_VIEW))
#define IS_BUILD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_VIEW))
#define BUILD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_VIEW, BuildViewClass))

typedef struct _BuildView BuildView;
typedef struct _BuildViewClass BuildViewClass;
typedef struct _BuildViewPrivate BuildViewPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define BUILD_VIEW_TYPE_BUILD_INFO (build_view_build_info_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))

typedef enum  {
	PARTITION_STATE_RUNNING,
	PARTITION_STATE_SUCCEEDED,
	PARTITION_STATE_FAILED,
	PARTITION_STATE_ABORTED
} PartitionState;

typedef enum  {
	BUILD_MSG_TYPE_ERROR,
	BUILD_MSG_TYPE_WARNING,
	BUILD_MSG_TYPE_BADBOX,
	BUILD_MSG_TYPE_OTHER
} BuildMsgType;

struct _BuildMsg {
	gchar* text;
	BuildMsgType type;
	gchar* filename;
	gboolean lines_set;
	gint start_line;
	gint end_line;
	gboolean expand;
};

struct _BuildView {
	GtkHBox parent_instance;
	BuildViewPrivate * priv;
};

struct _BuildViewClass {
	GtkHBoxClass parent_class;
};

struct _BuildViewPrivate {
	gboolean _show_errors;
	gboolean _show_warnings;
	gboolean _show_badboxes;
	MainWindow* _main_window;
	GtkTreeStore* _store;
	GtkTreeModelFilter* _filtered_model;
	GtkTreeView* _view;
	GtkToggleAction* _action_view_bottom_panel;
};

typedef enum  {
	BUILD_VIEW_BUILD_INFO_ICON,
	BUILD_VIEW_BUILD_INFO_MESSAGE,
	BUILD_VIEW_BUILD_INFO_MESSAGE_TYPE,
	BUILD_VIEW_BUILD_INFO_WEIGHT,
	BUILD_VIEW_BUILD_INFO_BASENAME,
	BUILD_VIEW_BUILD_INFO_PATH,
	BUILD_VIEW_BUILD_INFO_FILE,
	BUILD_VIEW_BUILD_INFO_START_LINE,
	BUILD_VIEW_BUILD_INFO_END_LINE,
	BUILD_VIEW_BUILD_INFO_LINE,
	BUILD_VIEW_BUILD_INFO_N_COLUMNS
} BuildViewBuildInfo;


static gpointer build_view_parent_class = NULL;

GType partition_state_get_type (void) G_GNUC_CONST;
GType build_msg_type_get_type (void) G_GNUC_CONST;
GType build_msg_get_type (void) G_GNUC_CONST;
BuildMsg* build_msg_dup (const BuildMsg* self);
void build_msg_free (BuildMsg* self);
void build_msg_copy (const BuildMsg* self, BuildMsg* dest);
void build_msg_destroy (BuildMsg* self);
GType build_view_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
#define BUILD_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BUILD_VIEW, BuildViewPrivate))
enum  {
	BUILD_VIEW_DUMMY_PROPERTY,
	BUILD_VIEW_SHOW_ERRORS,
	BUILD_VIEW_SHOW_WARNINGS,
	BUILD_VIEW_SHOW_BADBOXES
};
static GType build_view_build_info_get_type (void) G_GNUC_UNUSED;
BuildView* build_view_new (MainWindow* main_window, GtkToolbar* toolbar, GtkToggleAction* view_bottom_panel);
BuildView* build_view_construct (GType object_type, MainWindow* main_window, GtkToolbar* toolbar, GtkToggleAction* view_bottom_panel);
static gboolean _lambda48_ (GtkTreeModel* model, GtkTreeIter* iter, BuildView* self);
gboolean build_view_get_show_errors (BuildView* self);
gboolean build_view_get_show_warnings (BuildView* self);
gboolean build_view_get_show_badboxes (BuildView* self);
static gboolean __lambda48__gtk_tree_model_filter_visible_func (GtkTreeModel* model, GtkTreeIter* iter, gpointer self);
static void _lambda49_ (BuildView* self);
static void __lambda49__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda50_ (BuildView* self);
static void __lambda50__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda51_ (BuildView* self);
static void __lambda51__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean _lambda52_ (GtkTreeSelection* select, GtkTreeModel* model, GtkTreePath* path, gboolean path_currently_selected, BuildView* self);
static gboolean build_view_select_row (BuildView* self, GtkTreeModel* model, GtkTreePath* path);
static gboolean __lambda52__gtk_tree_selection_func (GtkTreeSelection* selection, GtkTreeModel* model, GtkTreePath* path, gboolean path_currently_selected, gpointer self);
static void _lambda72_ (GtkTreePath* path, BuildView* self);
static void __lambda72__gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
static void _lambda73_ (BuildView* self);
static void __lambda73__gtk_button_clicked (GtkButton* _sender, gpointer self);
GtkWidget* utils_add_scrollbar (GtkWidget* child);
static void build_view_jump_to_file (BuildView* self, GFile* file, gint start_line, gint end_line);
GType document_tab_get_type (void) G_GNUC_CONST;
DocumentTab* main_window_open_document (MainWindow* self, GFile* location, gboolean jump_to);
void utils_flush_queue (void);
GType document_get_type (void) G_GNUC_CONST;
Document* document_tab_get_document (DocumentTab* self);
void document_select_lines (Document* self, gint start, gint end);
void build_view_clear (BuildView* self);
void build_view_add_partition (BuildView* self, const gchar* msg, PartitionState state, GtkTreeIter* parent, gboolean bold, GtkTreeIter* result);
static gchar* build_view_get_icon_from_state (BuildView* self, PartitionState state);
void build_view_set_partition_state (BuildView* self, GtkTreeIter* partition_id, PartitionState state);
void build_view_append_messages (BuildView* self, GtkTreeIter* parent, GNode* messages, gboolean parent_is_partition);
void build_view_append_single_message (BuildView* self, GtkTreeIter* partition_id, BuildMsg* message, GtkTreeIter* result);
gchar* utils_replace_home_dir_with_tilde (const gchar* uri);
static gchar* build_view_get_icon_from_msg_type (BuildView* self, BuildMsgType type);
void build_view_show (BuildView* self);
void build_view_set_show_errors (BuildView* self, gboolean value);
void build_view_set_show_warnings (BuildView* self, gboolean value);
void build_view_set_show_badboxes (BuildView* self, gboolean value);
static void build_view_finalize (GObject* obj);
static void _vala_build_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_build_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType partition_state_get_type (void) {
	static volatile gsize partition_state_type_id__volatile = 0;
	if (g_once_init_enter (&partition_state_type_id__volatile)) {
		static const GEnumValue values[] = {{PARTITION_STATE_RUNNING, "PARTITION_STATE_RUNNING", "running"}, {PARTITION_STATE_SUCCEEDED, "PARTITION_STATE_SUCCEEDED", "succeeded"}, {PARTITION_STATE_FAILED, "PARTITION_STATE_FAILED", "failed"}, {PARTITION_STATE_ABORTED, "PARTITION_STATE_ABORTED", "aborted"}, {0, NULL, NULL}};
		GType partition_state_type_id;
		partition_state_type_id = g_enum_register_static ("PartitionState", values);
		g_once_init_leave (&partition_state_type_id__volatile, partition_state_type_id);
	}
	return partition_state_type_id__volatile;
}


GType build_msg_type_get_type (void) {
	static volatile gsize build_msg_type_type_id__volatile = 0;
	if (g_once_init_enter (&build_msg_type_type_id__volatile)) {
		static const GEnumValue values[] = {{BUILD_MSG_TYPE_ERROR, "BUILD_MSG_TYPE_ERROR", "error"}, {BUILD_MSG_TYPE_WARNING, "BUILD_MSG_TYPE_WARNING", "warning"}, {BUILD_MSG_TYPE_BADBOX, "BUILD_MSG_TYPE_BADBOX", "badbox"}, {BUILD_MSG_TYPE_OTHER, "BUILD_MSG_TYPE_OTHER", "other"}, {0, NULL, NULL}};
		GType build_msg_type_type_id;
		build_msg_type_type_id = g_enum_register_static ("BuildMsgType", values);
		g_once_init_leave (&build_msg_type_type_id__volatile, build_msg_type_type_id);
	}
	return build_msg_type_type_id__volatile;
}


void build_msg_copy (const BuildMsg* self, BuildMsg* dest) {
	dest->text = g_strdup (self->text);
	dest->type = self->type;
	dest->filename = g_strdup (self->filename);
	dest->lines_set = self->lines_set;
	dest->start_line = self->start_line;
	dest->end_line = self->end_line;
	dest->expand = self->expand;
}


void build_msg_destroy (BuildMsg* self) {
	_g_free0 ((*self).text);
	_g_free0 ((*self).filename);
}


BuildMsg* build_msg_dup (const BuildMsg* self) {
	BuildMsg* dup;
	dup = g_new0 (BuildMsg, 1);
	build_msg_copy (self, dup);
	return dup;
}


void build_msg_free (BuildMsg* self) {
	build_msg_destroy (self);
	g_free (self);
}


GType build_msg_get_type (void) {
	static volatile gsize build_msg_type_id__volatile = 0;
	if (g_once_init_enter (&build_msg_type_id__volatile)) {
		GType build_msg_type_id;
		build_msg_type_id = g_boxed_type_register_static ("BuildMsg", (GBoxedCopyFunc) build_msg_dup, (GBoxedFreeFunc) build_msg_free);
		g_once_init_leave (&build_msg_type_id__volatile, build_msg_type_id);
	}
	return build_msg_type_id__volatile;
}


static GType build_view_build_info_get_type (void) {
	static volatile gsize build_view_build_info_type_id__volatile = 0;
	if (g_once_init_enter (&build_view_build_info_type_id__volatile)) {
		static const GEnumValue values[] = {{BUILD_VIEW_BUILD_INFO_ICON, "BUILD_VIEW_BUILD_INFO_ICON", "icon"}, {BUILD_VIEW_BUILD_INFO_MESSAGE, "BUILD_VIEW_BUILD_INFO_MESSAGE", "message"}, {BUILD_VIEW_BUILD_INFO_MESSAGE_TYPE, "BUILD_VIEW_BUILD_INFO_MESSAGE_TYPE", "message-type"}, {BUILD_VIEW_BUILD_INFO_WEIGHT, "BUILD_VIEW_BUILD_INFO_WEIGHT", "weight"}, {BUILD_VIEW_BUILD_INFO_BASENAME, "BUILD_VIEW_BUILD_INFO_BASENAME", "basename"}, {BUILD_VIEW_BUILD_INFO_PATH, "BUILD_VIEW_BUILD_INFO_PATH", "path"}, {BUILD_VIEW_BUILD_INFO_FILE, "BUILD_VIEW_BUILD_INFO_FILE", "file"}, {BUILD_VIEW_BUILD_INFO_START_LINE, "BUILD_VIEW_BUILD_INFO_START_LINE", "start-line"}, {BUILD_VIEW_BUILD_INFO_END_LINE, "BUILD_VIEW_BUILD_INFO_END_LINE", "end-line"}, {BUILD_VIEW_BUILD_INFO_LINE, "BUILD_VIEW_BUILD_INFO_LINE", "line"}, {BUILD_VIEW_BUILD_INFO_N_COLUMNS, "BUILD_VIEW_BUILD_INFO_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType build_view_build_info_type_id;
		build_view_build_info_type_id = g_enum_register_static ("BuildViewBuildInfo", values);
		g_once_init_leave (&build_view_build_info_type_id__volatile, build_view_build_info_type_id);
	}
	return build_view_build_info_type_id__volatile;
}


static gboolean _lambda48_ (GtkTreeModel* model, GtkTreeIter* iter, BuildView* self) {
	gboolean result = FALSE;
	BuildMsgType msg_type = 0;
	g_return_val_if_fail (model != NULL, FALSE);
	gtk_tree_model_get (model, iter, BUILD_VIEW_BUILD_INFO_MESSAGE_TYPE, &msg_type, -1, -1);
	switch (msg_type) {
		case BUILD_MSG_TYPE_ERROR:
		{
			result = self->priv->_show_errors;
			return result;
		}
		case BUILD_MSG_TYPE_WARNING:
		{
			result = self->priv->_show_warnings;
			return result;
		}
		case BUILD_MSG_TYPE_BADBOX:
		{
			result = self->priv->_show_badboxes;
			return result;
		}
		default:
		{
			result = TRUE;
			return result;
		}
	}
}


static gboolean __lambda48__gtk_tree_model_filter_visible_func (GtkTreeModel* model, GtkTreeIter* iter, gpointer self) {
	gboolean result;
	result = _lambda48_ (model, iter, self);
	return result;
}


static void _lambda49_ (BuildView* self) {
	gtk_tree_model_filter_refilter (self->priv->_filtered_model);
}


static void __lambda49__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda49_ (self);
}


static void _lambda50_ (BuildView* self) {
	gtk_tree_model_filter_refilter (self->priv->_filtered_model);
}


static void __lambda50__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda50_ (self);
}


static void _lambda51_ (BuildView* self) {
	gtk_tree_model_filter_refilter (self->priv->_filtered_model);
}


static void __lambda51__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda51_ (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _lambda52_ (GtkTreeSelection* select, GtkTreeModel* model, GtkTreePath* path, gboolean path_currently_selected, BuildView* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (select != NULL, FALSE);
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	if (path_currently_selected) {
		result = TRUE;
		return result;
	}
	_tmp0_ = build_view_select_row (self, model, path);
	result = _tmp0_;
	return result;
}


static gboolean __lambda52__gtk_tree_selection_func (GtkTreeSelection* selection, GtkTreeModel* model, GtkTreePath* path, gboolean path_currently_selected, gpointer self) {
	gboolean result;
	result = _lambda52_ (selection, model, path, path_currently_selected, self);
	return result;
}


static void _lambda72_ (GtkTreePath* path, BuildView* self) {
	g_return_if_fail (path != NULL);
	build_view_select_row (self, (GtkTreeModel*) self->priv->_filtered_model, path);
}


static void __lambda72__gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
	_lambda72_ (path, self);
}


static void _lambda73_ (BuildView* self) {
	gtk_widget_hide ((GtkWidget*) self);
	gtk_toggle_action_set_active (self->priv->_action_view_bottom_panel, FALSE);
}


static void __lambda73__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda73_ (self);
}


BuildView* build_view_construct (GType object_type, MainWindow* main_window, GtkToolbar* toolbar, GtkToggleAction* view_bottom_panel) {
	BuildView * self = NULL;
	GtkTreeStore* _tmp0_ = NULL;
	GtkTreeModelFilter* _tmp1_ = NULL;
	GtkTreeView* _tmp2_ = NULL;
	GtkTreeViewColumn* _tmp3_ = NULL;
	GtkTreeViewColumn* column_job;
	const gchar* _tmp4_ = NULL;
	GtkCellRendererPixbuf* _tmp5_ = NULL;
	GtkCellRendererPixbuf* renderer_pixbuf;
	GtkCellRendererText* _tmp6_ = NULL;
	GtkCellRendererText* renderer_text;
	const gchar* _tmp7_ = NULL;
	GtkCellRendererText* _tmp8_ = NULL;
	GtkCellRendererText* _tmp9_;
	const gchar* _tmp10_ = NULL;
	GtkCellRendererText* _tmp11_ = NULL;
	GtkCellRendererText* _tmp12_;
	GtkTreeSelection* _tmp13_ = NULL;
	GtkTreeSelection* _tmp14_;
	GtkTreeSelection* select;
	GtkButton* _tmp15_ = NULL;
	GtkButton* close_button;
	const gchar* _tmp16_ = NULL;
	GtkImage* _tmp17_ = NULL;
	GtkImage* _tmp18_;
	GtkWidget* _tmp19_ = NULL;
	GtkWidget* sw;
	GtkVBox* _tmp20_ = NULL;
	GtkVBox* vbox;
	g_return_val_if_fail (main_window != NULL, NULL);
	g_return_val_if_fail (toolbar != NULL, NULL);
	g_return_val_if_fail (view_bottom_panel != NULL, NULL);
	self = (BuildView*) g_object_new (object_type, NULL);
	self->priv->_main_window = main_window;
	self->priv->_action_view_bottom_panel = view_bottom_panel;
	_tmp0_ = gtk_tree_store_new ((gint) BUILD_VIEW_BUILD_INFO_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, TYPE_BUILD_MSG_TYPE, G_TYPE_INT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_FILE, G_TYPE_INT, G_TYPE_INT, G_TYPE_STRING);
	_g_object_unref0 (self->priv->_store);
	self->priv->_store = _tmp0_;
	_tmp1_ = (GtkTreeModelFilter*) gtk_tree_model_filter_new ((GtkTreeModel*) self->priv->_store, NULL);
	_g_object_unref0 (self->priv->_filtered_model);
	self->priv->_filtered_model = _tmp1_;
	gtk_tree_model_filter_set_visible_func (self->priv->_filtered_model, __lambda48__gtk_tree_model_filter_visible_func, g_object_ref (self), g_object_unref);
	g_signal_connect_object ((GObject*) self, "notify::show-errors", (GCallback) __lambda49__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::show-warnings", (GCallback) __lambda50__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::show-badboxes", (GCallback) __lambda51__g_object_notify, self, 0);
	_tmp2_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) self->priv->_filtered_model);
	_g_object_unref0 (self->priv->_view);
	self->priv->_view = g_object_ref_sink (_tmp2_);
	_tmp3_ = gtk_tree_view_column_new ();
	column_job = g_object_ref_sink (_tmp3_);
	_tmp4_ = _ ("Job");
	gtk_tree_view_column_set_title (column_job, _tmp4_);
	_tmp5_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	renderer_pixbuf = g_object_ref_sink (_tmp5_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) column_job, (GtkCellRenderer*) renderer_pixbuf, FALSE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) column_job, (GtkCellRenderer*) renderer_pixbuf, "stock-id", (gint) BUILD_VIEW_BUILD_INFO_ICON);
	_tmp6_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	renderer_text = g_object_ref_sink (_tmp6_);
	g_object_set (renderer_text, "weight-set", TRUE, NULL);
	g_object_set (renderer_text, "editable", TRUE, NULL);
	g_object_set (renderer_text, "editable-set", TRUE, NULL);
	gtk_cell_layout_pack_start ((GtkCellLayout*) column_job, (GtkCellRenderer*) renderer_text, TRUE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) column_job, (GtkCellRenderer*) renderer_text, "text", (gint) BUILD_VIEW_BUILD_INFO_MESSAGE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) column_job, (GtkCellRenderer*) renderer_text, "weight", (gint) BUILD_VIEW_BUILD_INFO_WEIGHT);
	gtk_tree_view_append_column (self->priv->_view, column_job);
	_tmp7_ = _ ("File");
	_tmp8_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp9_ = g_object_ref_sink (_tmp8_);
	gtk_tree_view_insert_column_with_attributes (self->priv->_view, -1, _tmp7_, (GtkCellRenderer*) _tmp9_, "text", BUILD_VIEW_BUILD_INFO_BASENAME, NULL);
	_g_object_unref0 (_tmp9_);
	_tmp10_ = _ ("Line");
	_tmp11_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp12_ = g_object_ref_sink (_tmp11_);
	gtk_tree_view_insert_column_with_attributes (self->priv->_view, -1, _tmp10_, (GtkCellRenderer*) _tmp12_, "text", BUILD_VIEW_BUILD_INFO_LINE, NULL);
	_g_object_unref0 (_tmp12_);
	gtk_tree_view_set_tooltip_column (self->priv->_view, (gint) BUILD_VIEW_BUILD_INFO_PATH);
	_tmp13_ = gtk_tree_view_get_selection (self->priv->_view);
	_tmp14_ = _g_object_ref0 (_tmp13_);
	select = _tmp14_;
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
	gtk_tree_selection_set_select_function (select, __lambda52__gtk_tree_selection_func, g_object_ref (self), g_object_unref);
	g_signal_connect_object (self->priv->_view, "row-activated", (GCallback) __lambda72__gtk_tree_view_row_activated, self, 0);
	_tmp15_ = (GtkButton*) gtk_button_new ();
	close_button = g_object_ref_sink (_tmp15_);
	gtk_button_set_relief (close_button, GTK_RELIEF_NONE);
	gtk_button_set_focus_on_click (close_button, FALSE);
	_tmp16_ = _ ("Hide panel");
	gtk_widget_set_tooltip_text ((GtkWidget*) close_button, _tmp16_);
	_tmp17_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_CLOSE, GTK_ICON_SIZE_MENU);
	_tmp18_ = g_object_ref_sink (_tmp17_);
	gtk_container_add ((GtkContainer*) close_button, (GtkWidget*) _tmp18_);
	_g_object_unref0 (_tmp18_);
	g_signal_connect_object (close_button, "clicked", (GCallback) __lambda73__gtk_button_clicked, self, 0);
	_tmp19_ = utils_add_scrollbar ((GtkWidget*) self->priv->_view);
	sw = _tmp19_;
	gtk_box_pack_start ((GtkBox*) self, sw, TRUE, TRUE, (guint) 0);
	_tmp20_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
	vbox = g_object_ref_sink (_tmp20_);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) close_button, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) toolbar, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) vbox, FALSE, FALSE, (guint) 0);
	_g_object_unref0 (vbox);
	_g_object_unref0 (sw);
	_g_object_unref0 (close_button);
	_g_object_unref0 (select);
	_g_object_unref0 (renderer_text);
	_g_object_unref0 (renderer_pixbuf);
	_g_object_unref0 (column_job);
	return self;
}


BuildView* build_view_new (MainWindow* main_window, GtkToolbar* toolbar, GtkToggleAction* view_bottom_panel) {
	return build_view_construct (TYPE_BUILD_VIEW, main_window, toolbar, view_bottom_panel);
}


static gboolean build_view_select_row (BuildView* self, GtkTreeModel* model, GtkTreePath* path) {
	gboolean result = FALSE;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	BuildMsgType msg_type = 0;
	GFile* file = NULL;
	gint start_line = 0;
	gint end_line = 0;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp1_ = gtk_tree_model_get_iter (model, &_tmp0_, path);
	iter = _tmp0_;
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	gtk_tree_model_get (model, &iter, BUILD_VIEW_BUILD_INFO_MESSAGE_TYPE, &msg_type, BUILD_VIEW_BUILD_INFO_FILE, &file, BUILD_VIEW_BUILD_INFO_START_LINE, &start_line, BUILD_VIEW_BUILD_INFO_END_LINE, &end_line, -1, -1);
	if (msg_type != BUILD_MSG_TYPE_OTHER) {
		_tmp2_ = file != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		build_view_jump_to_file (self, file, start_line, end_line);
		result = TRUE;
		_g_object_unref0 (file);
		return result;
	} else {
		if (msg_type == BUILD_MSG_TYPE_OTHER) {
			gboolean _tmp3_;
			_tmp3_ = gtk_tree_model_iter_has_child (model, &iter);
			if (_tmp3_) {
				gboolean _tmp4_;
				_tmp4_ = gtk_tree_view_row_expanded (self->priv->_view, path);
				if (_tmp4_) {
					gtk_tree_view_collapse_row (self->priv->_view, path);
				} else {
					gtk_tree_view_expand_to_path (self->priv->_view, path);
				}
				result = FALSE;
				_g_object_unref0 (file);
				return result;
			}
		}
	}
	result = TRUE;
	_g_object_unref0 (file);
	return result;
}


static void build_view_jump_to_file (BuildView* self, GFile* file, gint start_line, gint end_line) {
	DocumentTab* _tmp0_ = NULL;
	DocumentTab* tab;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = main_window_open_document (self->priv->_main_window, file, TRUE);
	tab = _tmp0_;
	utils_flush_queue ();
	if (start_line != (-1)) {
		gint _tmp1_ = 0;
		gint end;
		Document* _tmp2_ = NULL;
		if (end_line != (-1)) {
			_tmp1_ = end_line - 1;
		} else {
			_tmp1_ = start_line;
		}
		end = _tmp1_;
		_tmp2_ = document_tab_get_document (tab);
		document_select_lines (_tmp2_, start_line - 1, end);
	}
	_g_object_unref0 (tab);
}


void build_view_clear (BuildView* self) {
	g_return_if_fail (self != NULL);
	gtk_tree_store_clear (self->priv->_store);
	gtk_tree_view_columns_autosize (self->priv->_view);
}


void build_view_add_partition (BuildView* self, const gchar* msg, PartitionState state, GtkTreeIter* parent, gboolean bold, GtkTreeIter* result) {
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	GtkTreePath* _tmp4_ = NULL;
	GtkTreePath* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	gtk_tree_store_append (self->priv->_store, &_tmp0_, parent);
	iter = _tmp0_;
	if (bold) {
		_tmp1_ = 800;
	} else {
		_tmp1_ = 400;
	}
	_tmp2_ = build_view_get_icon_from_state (self, state);
	_tmp3_ = _tmp2_;
	gtk_tree_store_set (self->priv->_store, &iter, BUILD_VIEW_BUILD_INFO_ICON, _tmp3_, BUILD_VIEW_BUILD_INFO_MESSAGE, msg, BUILD_VIEW_BUILD_INFO_MESSAGE_TYPE, BUILD_MSG_TYPE_OTHER, BUILD_VIEW_BUILD_INFO_WEIGHT, _tmp1_, -1, -1);
	_g_free0 (_tmp3_);
	_tmp4_ = gtk_tree_model_get_path ((GtkTreeModel*) self->priv->_store, &iter);
	_tmp5_ = _tmp4_;
	gtk_tree_view_expand_to_path (self->priv->_view, _tmp5_);
	_gtk_tree_path_free0 (_tmp5_);
	*result = iter;
	return;
}


void build_view_set_partition_state (BuildView* self, GtkTreeIter* partition_id, PartitionState state) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = build_view_get_icon_from_state (self, state);
	_tmp1_ = _tmp0_;
	gtk_tree_store_set (self->priv->_store, partition_id, BUILD_VIEW_BUILD_INFO_ICON, _tmp1_, -1, -1);
	_g_free0 (_tmp1_);
}


void build_view_append_messages (BuildView* self, GtkTreeIter* parent, GNode* messages, gboolean parent_is_partition) {
	GNode* _tmp0_ = NULL;
	GNode* cur_node;
	g_return_if_fail (self != NULL);
	g_return_if_fail (messages != NULL);
	_tmp0_ = g_node_first_child (messages);
	cur_node = _tmp0_;
	while (TRUE) {
		GtkTreeIter _tmp1_ = {0};
		GtkTreeIter _tmp2_ = {0};
		GtkTreeIter child;
		GNode* _tmp5_ = NULL;
		if (!(cur_node != NULL)) {
			break;
		}
		build_view_append_single_message (self, parent, (BuildMsg*) cur_node->data, &_tmp1_);
		_tmp2_ = _tmp1_;
		child = _tmp2_;
		if (cur_node->children != NULL) {
			gtk_tree_store_set (self->priv->_store, &child, BUILD_VIEW_BUILD_INFO_ICON, "completion_choice", -1, -1);
			build_view_append_messages (self, &child, cur_node, FALSE);
			if ((*((BuildMsg*) cur_node->data)).expand) {
				GtkTreePath* _tmp3_ = NULL;
				GtkTreePath* _tmp4_;
				_tmp3_ = gtk_tree_model_get_path ((GtkTreeModel*) self->priv->_store, &child);
				_tmp4_ = _tmp3_;
				gtk_tree_view_expand_to_path (self->priv->_view, _tmp4_);
				_gtk_tree_path_free0 (_tmp4_);
			}
		}
		_tmp5_ = g_node_next_sibling (cur_node);
		cur_node = _tmp5_;
	}
	if (parent_is_partition) {
		GtkTreePath* _tmp6_ = NULL;
		GtkTreePath* _tmp7_;
		_tmp6_ = gtk_tree_model_get_path ((GtkTreeModel*) self->priv->_store, parent);
		_tmp7_ = _tmp6_;
		gtk_tree_view_expand_row (self->priv->_view, _tmp7_, FALSE);
		_gtk_tree_path_free0 (_tmp7_);
	}
}


void build_view_append_single_message (BuildView* self, GtkTreeIter* partition_id, BuildMsg* message, GtkTreeIter* result) {
	GFile* file;
	gchar* path;
	gint start_line;
	gint end_line;
	gchar* line_str;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp4_ = {0};
	gchar* _tmp5_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	file = NULL;
	path = NULL;
	if ((*message).filename != NULL) {
		GFile* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		_tmp0_ = g_file_new_for_path ((*message).filename);
		_g_object_unref0 (file);
		file = _tmp0_;
		_tmp1_ = utils_replace_home_dir_with_tilde ((*message).filename);
		_g_free0 (path);
		path = _tmp1_;
		_tmp2_ = g_markup_escape_text (path, (gssize) (-1));
		_g_free0 (path);
		path = _tmp2_;
	}
	start_line = -1;
	end_line = -1;
	line_str = NULL;
	if ((*message).lines_set) {
		gchar* _tmp3_ = NULL;
		start_line = (*message).start_line;
		end_line = (*message).end_line;
		_tmp3_ = g_strdup_printf ("%i", start_line);
		_g_free0 (line_str);
		line_str = _tmp3_;
	}
	gtk_tree_store_append (self->priv->_store, &_tmp4_, partition_id);
	iter = _tmp4_;
	if (file != NULL) {
		gchar* _tmp6_ = NULL;
		_tmp6_ = g_file_get_basename (file);
		_g_free0 (_tmp5_);
		_tmp5_ = _tmp6_;
	} else {
		_g_free0 (_tmp5_);
		_tmp5_ = NULL;
	}
	_tmp7_ = build_view_get_icon_from_msg_type (self, (*message).type);
	_tmp8_ = _tmp7_;
	gtk_tree_store_set (self->priv->_store, &iter, BUILD_VIEW_BUILD_INFO_ICON, _tmp8_, BUILD_VIEW_BUILD_INFO_MESSAGE, (*message).text, BUILD_VIEW_BUILD_INFO_MESSAGE_TYPE, (*message).type, BUILD_VIEW_BUILD_INFO_WEIGHT, 400, BUILD_VIEW_BUILD_INFO_BASENAME, _tmp5_, BUILD_VIEW_BUILD_INFO_FILE, file, BUILD_VIEW_BUILD_INFO_PATH, path, BUILD_VIEW_BUILD_INFO_START_LINE, start_line, BUILD_VIEW_BUILD_INFO_END_LINE, end_line, BUILD_VIEW_BUILD_INFO_LINE, line_str, -1, -1);
	_g_free0 (_tmp8_);
	*result = iter;
	_g_free0 (_tmp5_);
	_g_free0 (line_str);
	_g_free0 (path);
	_g_object_unref0 (file);
	return;
}


static gchar* build_view_get_icon_from_state (BuildView* self, PartitionState state) {
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	switch (state) {
		case PARTITION_STATE_RUNNING:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (GTK_STOCK_EXECUTE);
			result = _tmp0_;
			return result;
		}
		case PARTITION_STATE_SUCCEEDED:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (GTK_STOCK_APPLY);
			result = _tmp1_;
			return result;
		}
		case PARTITION_STATE_FAILED:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (GTK_STOCK_DIALOG_ERROR);
			result = _tmp2_;
			return result;
		}
		case PARTITION_STATE_ABORTED:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (GTK_STOCK_STOP);
			result = _tmp3_;
			return result;
		}
		default:
		{
			g_return_val_if_reached (NULL);
		}
	}
}


static gchar* build_view_get_icon_from_msg_type (BuildView* self, BuildMsgType type) {
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	switch (type) {
		case BUILD_MSG_TYPE_ERROR:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (GTK_STOCK_DIALOG_ERROR);
			result = _tmp0_;
			return result;
		}
		case BUILD_MSG_TYPE_WARNING:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (GTK_STOCK_DIALOG_WARNING);
			result = _tmp1_;
			return result;
		}
		case BUILD_MSG_TYPE_BADBOX:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("badbox");
			result = _tmp2_;
			return result;
		}
		case BUILD_MSG_TYPE_OTHER:
		{
			result = NULL;
			return result;
		}
		default:
		{
			g_return_val_if_reached (NULL);
		}
	}
}


void build_view_show (BuildView* self) {
	g_return_if_fail (self != NULL);
	GTK_WIDGET_CLASS (build_view_parent_class)->show ((GtkWidget*) GTK_HBOX (self));
	gtk_toggle_action_set_active (self->priv->_action_view_bottom_panel, TRUE);
}


gboolean build_view_get_show_errors (BuildView* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_errors;
	return result;
}


void build_view_set_show_errors (BuildView* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_show_errors = value;
	g_object_notify ((GObject *) self, "show-errors");
}


gboolean build_view_get_show_warnings (BuildView* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_warnings;
	return result;
}


void build_view_set_show_warnings (BuildView* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_show_warnings = value;
	g_object_notify ((GObject *) self, "show-warnings");
}


gboolean build_view_get_show_badboxes (BuildView* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_badboxes;
	return result;
}


void build_view_set_show_badboxes (BuildView* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_show_badboxes = value;
	g_object_notify ((GObject *) self, "show-badboxes");
}


static void build_view_class_init (BuildViewClass * klass) {
	build_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BuildViewPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_build_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_build_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = build_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUILD_VIEW_SHOW_ERRORS, g_param_spec_boolean ("show-errors", "show-errors", "show-errors", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUILD_VIEW_SHOW_WARNINGS, g_param_spec_boolean ("show-warnings", "show-warnings", "show-warnings", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUILD_VIEW_SHOW_BADBOXES, g_param_spec_boolean ("show-badboxes", "show-badboxes", "show-badboxes", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void build_view_instance_init (BuildView * self) {
	self->priv = BUILD_VIEW_GET_PRIVATE (self);
}


static void build_view_finalize (GObject* obj) {
	BuildView * self;
	self = BUILD_VIEW (obj);
	_g_object_unref0 (self->priv->_store);
	_g_object_unref0 (self->priv->_filtered_model);
	_g_object_unref0 (self->priv->_view);
	G_OBJECT_CLASS (build_view_parent_class)->finalize (obj);
}


GType build_view_get_type (void) {
	static volatile gsize build_view_type_id__volatile = 0;
	if (g_once_init_enter (&build_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BuildViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) build_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BuildView), 0, (GInstanceInitFunc) build_view_instance_init, NULL };
		GType build_view_type_id;
		build_view_type_id = g_type_register_static (GTK_TYPE_HBOX, "BuildView", &g_define_type_info, 0);
		g_once_init_leave (&build_view_type_id__volatile, build_view_type_id);
	}
	return build_view_type_id__volatile;
}


static void _vala_build_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BuildView * self;
	self = BUILD_VIEW (object);
	switch (property_id) {
		case BUILD_VIEW_SHOW_ERRORS:
		g_value_set_boolean (value, build_view_get_show_errors (self));
		break;
		case BUILD_VIEW_SHOW_WARNINGS:
		g_value_set_boolean (value, build_view_get_show_warnings (self));
		break;
		case BUILD_VIEW_SHOW_BADBOXES:
		g_value_set_boolean (value, build_view_get_show_badboxes (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_build_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BuildView * self;
	self = BUILD_VIEW (object);
	switch (property_id) {
		case BUILD_VIEW_SHOW_ERRORS:
		build_view_set_show_errors (self, g_value_get_boolean (value));
		break;
		case BUILD_VIEW_SHOW_WARNINGS:
		build_view_set_show_warnings (self, g_value_get_boolean (value));
		break;
		case BUILD_VIEW_SHOW_BADBOXES:
		build_view_set_show_badboxes (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



