// 
// lat - Defines.cs
// Author: Loren Bandiera
// Copyright 2005 MMG Security, Inc.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//

using System;
using System.Xml;

namespace lat 
{
	public struct Defines
	{
		public static string PACKAGE = "lat";
		public static string VERSION = "1.0.7";
		public static string LOCALE_DIR = "/usr/local/share/locale";

		public static string VIEWS_XML = 
			"<views>" +
			"<view displayName=\"Contacts\" name=\"openldapContacts\" type=\"standard\">" +
			"<filter>objectClass=inetOrgPerson</filter>" +
			"<searchBase></searchBase>" +
			"<columns primaryKey=\"0\">" +
			"<column name=\"cn\">Name</column>" +
			"<column name=\"mail\">Email</column>" +
			"<column name=\"telephoneNumber\">Work</column>" +
			"<column name=\"homePhone\">Home</column>" +
			"<column name=\"mobile\">Mobile</column>" +
			"</columns>" +
			"</view>" +
			"<view displayName=\"Contacts\" name=\"adContacts\" type=\"standard\">" +
			"<filter>objectclass=contact</filter>" +
			"<searchBase></searchBase>" +
			"<columns primaryKey=\"0\">" +
			"<column name=\"name\">Name</column>" +
			"<column name=\"description\">Email</column>" +
			"<column name=\"mail\">Work</column>" +
			"<column name=\"wWWHomePage\">Home</column>" +
			"</columns>" +
			"</view>" +
			"<view displayName=\"Groups\" name=\"openldapGroups\" type=\"standard\">" +
			"<filter>objectclass=posixGroup</filter>" +
			"<searchBase></searchBase>" +
			"<columns primaryKey=\"1\">" +
			"<column name=\"gidNumber\">Group ID</column>" +
			"<column name=\"cn\">Name</column>" +
			"<column name=\"description\">Description</column>" +
			"</columns>" +
			"</view>" +
			"<view displayName=\"Groups\" name=\"adGroups\" type=\"standard\">" +
			"<filter>objectclass=group</filter>" +
			"<searchBase></searchBase>" +
			"<columns primaryKey=\"0\">" +
			"<column name=\"name\">Name</column>" +
			"<column name=\"description\">Description</column>" +
			"</columns>" +
			"</view>" +
			"<view displayName=\"Computers\" name=\"openldapComputers\" type=\"standard\">" +
			"<filter>objectclass=ipHost</filter>" +
			"<searchBase></searchBase>" +
			"<columns primaryKey=\"0\">" +
			"<column name=\"cn\">Hostname</column>" +
			"<column name=\"ipHostNumber\">IP address</column>" +
			"<column name=\"description\">Description</column>" +
			"</columns>" +
			"</view>" +
			"<view displayName=\"Computers\" name=\"adComputers\" type=\"standard\">" +
			"<filter>" + 
			XmlConvert.EncodeName ("(&(objectclass=user)(objectcategory=Computer))") +
			"</filter>" +
			"<searchBase></searchBase>" +
			"<columns primaryKey=\"0\">" +
			"<column name=\"name\">Hostname</column>" +
			"<column name=\"description\">Description</column>" +
			"<column name=\"operatingSystem\">Operating system</column>" +
			"</columns>" +
			"</view>" +
			"<view displayName=\"Users\" name=\"openldapUsers\" type=\"standard\">" +
			"<filter>" +
			XmlConvert.EncodeName ("(&(objectclass=posixAccount)(objectclass=shadowAccount))") +
			"</filter>" +
			"<searchBase></searchBase>" +
			"<columns primaryKey=\"0\">" +
			"<column name=\"uid\">Username</column>" +
			"<column name=\"cn\">Full name</column>" +
			"</columns>" +
			"</view>" +
			"<view displayName=\"Users\" name=\"adUsers\" type=\"standard\">" +
			"<filter>" +
			XmlConvert.EncodeName ("(&(objectclass=user)(objectcategory=Person))") +
			"</filter>" +
			"<searchBase></searchBase>" +
			"<columns primaryKey=\"0\">" +
			"<column name=\"sAMAccountName\">Username</column>" +
			"<column name=\"cn\">Full name</column>" +
			"</columns>" +
			"</view>" +
			"</views>";
	}
}
