/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Christian Muehlhaeuser, Last.fm Ltd <chris@last.fm>                *
 *      Erik Jaelevik, Last.fm Ltd <erik@last.fm>                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#include <QtGui>
#include <QPixmap>
#include <QHttp>

#include "userinfoextension.h"
#include "containerutils.h"
#include "webservice/webservice.h"
#include "webservice/Request.h"


UserInfoExtension::UserInfoExtension() :
    m_widget( 0 )
{
    qDebug() << "Initialising UserInfo Extension";

/*    m_delegate = new ExtendedInfoDelegate();
    m_friendsModel = new QStandardItemModel();

    m_iWebService = webService();
    m_iSettings = settingsService();

    QTimer* timer = new QTimer( this );
    timer->setInterval( 1000 * 60 * 3 );

    connect( timer,         SIGNAL( timeout() ),
             this,            SLOT( friends() ) );

    timer->start();

//    connect( m_coverLoader, SIGNAL( requestFinished( int, bool, QIODevice*, QString ) ),
//             this,            SLOT( coverLoaded( int, bool, QIODevice*, QString ) ) );

    connect( m_iWebService, SIGNAL( friendsResult( QString, QList<UserMetaData> ) ),
             this,            SLOT( updateFriends( QString, QList<UserMetaData> ) ) );*/
}


void
UserInfoExtension::initGui()
{
    qDebug() << "Initialising UserInfo GUI";

    m_widget = new QWidget( m_parent );
    ui.setupUi( m_widget );

    ui.resultList->setModel( m_friendsModel );
    ui.resultList->setItemDelegate( m_delegate );
}


void
UserInfoExtension::friends()
{
    if (frameEnabled()) {
        FriendsRequest *friends = new FriendsRequest;
        connect( friends, SIGNAL(result( Request* )), SLOT(updateFriends( FriendsRequest* )) );
        friends->start();
    }
}

void
UserInfoExtension::updateFriends( FriendsRequest* )
{
    if ( username.toLower() != The::webService()->currentUsername().toLower() )
        return;

    m_friendsModel->clear();
    m_friendsModel->insertRows( 0, friends.count() );
    m_friendsModel->insertColumns( 0, 1 );
    for ( int i = 0; i < friends.count(); i++ )
    {
        QUrl url = friends.at( i ).image();
        QString path = ( !url.encodedQuery().isEmpty() ) ? url.path() + "?" + QString( url.encodedQuery() ) : url.path();
//        m_coverLoader->get( url.host(), path, new QBuffer() );

        QStringList recentInfo;
        recentInfo << friends.at( i ).recentTracks();
        recentInfo << friends.at( i ).lastActivity();

        m_friendsModel->setData( m_friendsModel->index( i, 0, QModelIndex() ), QVariant( friends.at( i ).name() ), Qt::DisplayRole );
//        m_friendsModel->setData( m_friendsModel->index( i, 0, QModelIndex() ),
//                                 QVariant( m_coverLoader->pathToCachedCopy( m_coverLoader->key( url.host(), path ) ) ), Qt::UserRole );

        m_friendsModel->setData( m_friendsModel->index( i, 0, QModelIndex() ), QVariant( recentInfo ), Qt::DecorationRole );
    }
}


void
UserInfoExtension::coverLoaded( int id, bool error, QIODevice* to, QString path )
{
    if ( !error )
    {
        QImage p( path );
        if ( !p.isNull() )
        {
            p.scaled( QSize( 74, 74 ), Qt::KeepAspectRatio, Qt::SmoothTransformation ).save( path, "PNG" );
        }

        if ( m_widget )
        {
            ui.resultList->update();
            ui.resultList->repaint();
        }
    }

    delete to;
}


ExtendedInfoDelegate::ExtendedInfoDelegate( QObject *parent )
    : QAbstractItemDelegate( parent )
{
}


void
ExtendedInfoDelegate::paint( QPainter * painter, const QStyleOptionViewItem & option, const QModelIndex & index ) const
{
    QPalette::ColorGroup cg = option.state & QStyle::State_Enabled ? QPalette::Normal : QPalette::Disabled;
    bool selected = option.showDecorationSelected && ( option.state & QStyle::State_Selected );

    QString recentTrack;
    QString recentActivity;

    QStringList list = index.model()->data( index, Qt::DecorationRole ).toStringList();
    if ( list.count() >= 2 )
    {
        recentTrack = list.at( 0 );
        recentActivity = list.at( list.count() - 1 );
    }
    else
        recentTrack = tr( "No recently played tracks to display." );

    QString imgToken = QString( "<td><img src='%1'></td><td width='8'></td>" )
                          .arg( index.model()->data( index, Qt::UserRole ).toString() );
    if ( !QFile( index.model()->data( index, Qt::UserRole ).toString() ).exists() )
        imgToken = "";

    painter->setViewTransformEnabled( true );
    QRect cr = option.rect;
    QTextDocument doc;
    doc.setHtml( QString( "<html><body leftmargin='0' topmargin='0'><table cellspacing='0' cellpadding='0' border='0'><tr>"
                          "<td align=center width=88><table><tr>%1</tr></table></td>"
                          "<td><b>%2</b></font>"
                          "<br>%3<br>%4</td>"
                          "</tr></table></body></html>" )
                    .arg( imgToken )
                    .arg( index.model()->data( index, Qt::DisplayRole ).toString() )
                    .arg( recentTrack )
                    .arg( recentActivity ) );

    doc.setPageSize( QSize( cr.width(), INT_MAX ) );
    QAbstractTextDocumentLayout::PaintContext context;

    if ( selected )
        context.palette.setColor( QPalette::Text, option.palette.color( cg, QPalette::HighlightedText ) );

    // draw the background color
    if ( selected )
        painter->fillRect( option.rect, option.palette.brush( cg, QPalette::Highlight ) );

    QRect r = cr;
    r.translate( -cr.x(), -cr.y() );
    painter->save();
    painter->translate( cr.x(), cr.y() );
    painter->setClipRect( r );
    doc.documentLayout()->draw( painter, context );

    painter->restore();
}


QSize
ExtendedInfoDelegate::sizeHint( const QStyleOptionViewItem & option, const QModelIndex & index ) const
{
    return QSize( 400, 84 );
}


Q_EXPORT_PLUGIN2( extension_search, UserInfoExtension )
