// Copyright 2007 Last.fm Ltd.

#ifndef MACSTYLEOVERRIDES_H
#define MACSTYLEOVERRIDES_H

#include <QtGlobal>

#ifdef Q_WS_MAC
#include <QMacStyle>


class MacStyleOverrides : public QMacStyle
{
    Q_OBJECT

    public:
 
		MacStyleOverrides();
		
        virtual QSize
        sizeFromContents(
            ContentsType ct,
            const QStyleOption* opt,
            const QSize &csz,
            const QWidget* w = 0) const;

        virtual void 
        drawControl(
            ControlElement pe,
            const QStyleOption* opt,
            QPainter* p,
            const QWidget* w = 0) const;
				
		virtual int
		pixelMetric(
			PixelMetric metric,
			const QStyleOption* opt,
			const QWidget* widget) const;
		
		virtual void
		drawPrimitive(
			PrimitiveElement pe,
			const QStyleOption *opt,
			QPainter *p,
			const QWidget *w = 0) const;

        virtual QRect
        subElementRect(
            SubElement sr,
            const QStyleOption *opt,
            const QWidget *widget = 0) const;

};

#endif // Q_WS_MAC

#endif // MACSTYLEOVERRIDES_H
