
#include "containerutils.h"
#include <QIcon>
#include <QMimeData>
#include "last.fm.h"

namespace LastFm
{
    /** @function icon */
    
    QIcon icon( const char *name )
    {
        return QIcon( dataPath( QString("icons/") + name + ".png" ) );
    }

    
    /** @class MimeData */
    
    Track
    MimeData::track() const
    {
        Track track;
        track.setArtist( QString::fromUtf8( data( "item/artist" ) ) );
        track.setTitle( QString::fromUtf8( data( "item/track" ) ) );
        
        return track;
    }
    
    QString
    MimeData::tag() const
    {
        return QString::fromUtf8( data( "item/tag" ) );
    }
    
    QString
    MimeData::username() const
    {
        return QString::fromUtf8( data( "item/user" ) );
    }
    
    Station
    MimeData::station() const
    {
        Station station;
        station.setUrl( QString::fromUtf8( data( "item/station" ) ) );
        return station;
    }
    
    ItemType
    MimeData::itemType() const
    {
        if (hasFormat("item/type"))
            return (ItemType) QString::fromUtf8(data("item/type")).toInt();
    
        if (hasFormat("item/track"))
            return ItemTrack;        
        if (hasFormat("item/album"))
            return ItemAlbum;
        if (hasFormat("item/artist")) //leave last as album and track have this data too
            return ItemArtist;
            
        return ItemUnknown;
    }
    
    QString
    MimeData::toString() const
    {
        switch ((int)itemType())
        {
            case ItemTrack:  return track().toString();
            case ItemAlbum:  return QString::fromUtf8( data( "item/album" ) );
            case ItemArtist: return QString::fromUtf8( data( "item/artist" ) ); //leave last as album and track have this data too
        }
        
        return QString();
    }
    
    /** @function sortedCaseInsensitively */
    
    QStringList
    sortedCaseInsensitively( QStringList input )
    {
        // This cumbersome bit of code here is how the Qt docs suggests you sort
        // a string list case-insensitively
        QMap<QString, QString> map;
        foreach (QString s, input)
            map.insert( s.toLower(), s );
    
        QStringList output;
        QMapIterator<QString, QString> i( map );
        while (i.hasNext())
            output += i.next().value();
        
        return output;
    }    
}



        
