/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Christian Muehlhaeuser, Last.fm Ltd <chris@last.fm>                *
 *      Erik Jaelevik, Last.fm Ltd <erik@last.fm>                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#include "browserthread.h"
#include <QStringList>

#include <QStringList>
#include <QProcess>

#ifdef Q_WS_MAC
    #include <ApplicationServices/ApplicationServices.h>
#endif

#ifdef WIN32
    #include <windows.h>
#endif


void
BrowserThread::run()
{
#if 0
    #ifdef WIN32
    WCHAR val[1024];
    memset( val, 0, 1024 );
    MultiByteToWideChar( CP_UTF8, 0, m_url.toAscii(), m_url.length(), val, 1024 );
    ShellExecute( 0, 0, val, NULL, NULL, SW_SHOW );
    #endif

    #ifdef Q_WS_MAC
    ICInstance icInstance;
    OSType psiSignature = 'Psi ';
    OSStatus error = ICStart( &icInstance, psiSignature );

    ConstStr255Param hint( 0x0 );
    const char* data = m_url.toLocal8Bit().data();
    long length = m_url.length();
    long start( 0 );
    long end( length );

    ICLaunchURL( icInstance, hint, data, length, &start, &end );
    ICStop( icInstance );
    #endif

    #ifdef Q_WS_X11
    QString browser = "firefox";
    QStringList params;
    params.append( QString( QUrl::toPercentEncoding( m_url ) ) );

    QStringList options;
    options = browser.split( " " );
    if ( options.size() == 0 )
        options.append( browser );

    for ( int i = 1; i < options.size(); i++ )
    {
        qDebug( QString( "param: " + options.at( i ) ).toLocal8Bit() );
        params.append( "\"" + options.at( i ) + "\"" );
    }

    QProcess::startDetached( options.at( 0 ), params );
    #endif
#endif
}
