#ifndef LASTFM_COMMON
#define LASTFM_COMMON

#include "logger.h"
#include <QString>
#include <QtCore>


// CONSTANTS AND DEFAULTS
namespace Constants
{
    // SCROBBLING CONSTANTS

    // The plugin ID used by HttpInput when submitting radio tracks to the player listener
    const QString kRadioPluginId = "radio";

    // Limits for user-configurable scrobble point (%)
    const int kScrobblePointMin = 50;
    const int kScrobblePointMax = 100;

    // Shortest track length allowed to scrobble (s)
    const int kScrobbleMinLength = 31;

    // Upper limit for scrobble time (s)
    const int kScrobbleTimeMax = 240;

    // Min size of buffer holding streamed http data, i.e the size the http
    // buffer needs to get to before we start streaming.
    const int kHttpBufferMinSize = 16 * 1024;
    
    // Max
    const int kHttpBufferMaxSize = 256 * 1024;

};

namespace Defaults
{
    // Percentage of track length at which to scrobble
    const int kScrobblePoint = 50;    

};

#endif // LASTFM_COMMON
