/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Christian Muehlhaeuser, Last.fm Ltd <chris@last.fm>                *
 *      Erik Jaelevik, Last.fm Ltd <erik@last.fm>                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#ifndef ITUNESSCRIPT_H
#define ITUNESSCRIPT_H

#include <QtGui>

#ifdef Q_WS_MAC

#include <CoreFoundation/CoreFoundation.h>

class CPlayerListener;

class ITunesScript : public QObject
{
    Q_OBJECT

    public:
        ITunesScript( QObject* parent, const CPlayerListener* listener );

        static bool m_paused;
        static QString m_lastHash;

    private slots:
        void checkITunes();
        void ITunesData();

    private:
        const CPlayerListener* m_listener;

        static void iTunesCallback( CFNotificationCenterRef, void*, CFStringRef, const void*, CFDictionaryRef info );
        static bool isMusic();
        void transmit( QString data );

        bool isITunesResponding();
        bool isITunesRunning();
        bool isITunesPlaying();
        bool isITunesPaused();

        QString artist();
        QString album();
        QString track();
        QString path();
        QString duration();

        static QString encodeAmp( QString data ) { return data.replace( QString("&"), QString("&&") ); }

};

#include <Carbon/Carbon.h>

#ifdef __cplusplus
extern "C" {
#endif

    OSAID LowCompileAppleScript( const void* text, long textLength );

    /* LowRunAppleScript compiles and runs an AppleScript
    provided as text in the buffer pointed to by text.  textLength
    bytes will be compiled from this buffer and run as an AppleScript
    using all of the default environment and execution settings.  If
    resultData is not NULL, then the result returned by the execution
    command will be returned as typeChar in this descriptor record
    (or typeNull if there is no result information).  If the function
    returns errOSAScriptError, then resultData will be set to a
    descriptive error message describing the error (if one is
    available). */
    bool LowExecAppleScript( OSAID scriptID, QString& resultToken );

    /* AppleScriptAvailable returns true if AppleScript is available
    and the routines defined herein can be called. */
    bool AppleScriptAvailable();

#ifdef __cplusplus
}
#endif // end _cplusplus

#endif // end Q_WS_MAC

#endif // end ITUNESSCRIPT_H
