/***************************************************************************
 *   Copyright (C) 2007 by                                                 *
 *      Philipp Maihart, Last.fm Ltd <phil@last.fm>                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#include "last.fm.h"
#include "TagListWidget.h"

TagListWidget::TagListWidget( QWidget* parent ) 
    : QListWidget( parent )
{
    m_sortOrder = Tags::MostPopularOrder;
    
    m_actionSortMostPopular = m_sortTagsMenu.addAction( tr( "Sort by popularity" ) );
    m_actionSortMostPopular->setCheckable( true );
    
    m_actionSortAZ = m_sortTagsMenu.addAction( tr( "Sort tags A-Z" ) );
    m_actionSortAZ->setCheckable( true );
    
    m_actionSortZA = m_sortTagsMenu.addAction( tr( "Sort tags Z-A" ) );
    m_actionSortZA->setCheckable( true );
    
    QActionGroup* sortActions = new QActionGroup( this );
    sortActions->addAction( m_actionSortMostPopular );
    sortActions->addAction( m_actionSortAZ );
    sortActions->addAction( m_actionSortZA );
            
    m_actionSortMostPopular->setChecked( true );
    
    connect( this,                      SIGNAL( customContextMenuRequested( const QPoint& ) ),
             this,                        SLOT( showSortContextMenu( const QPoint& ) ) );
    connect( m_actionSortAZ,            SIGNAL( triggered() ),
             this,                        SLOT( sortAZ() ) );
    connect( m_actionSortZA,            SIGNAL( triggered() ),
             this,                        SLOT( sortZA() ) );
    connect( m_actionSortMostPopular,   SIGNAL( triggered() ), 
             this,                        SLOT( sortMostPopular() ) );
}


void
TagListWidget::showSortContextMenu( const QPoint& point )
{
    m_sortTagsMenu.exec( mapToGlobal( point ) );
}


void
TagListWidget::sortAZ()
{
    sortItems( Qt::AscendingOrder );
    repaint();
    
    m_sortOrder = Tags::AscendingOrder;
    m_actionSortAZ->setChecked( true );
}


void
TagListWidget::sortZA()
{
    sortItems( Qt::DescendingOrder );
    repaint();
    
    m_sortOrder = Tags::DescendingOrder;
    m_actionSortZA->setChecked( true );
}


void
TagListWidget::sortMostPopular()
{
    clear();
    QListWidget::addItems( m_tags );
    
    m_sortOrder = Tags::MostPopularOrder;
    m_actionSortMostPopular->setChecked( true );
}


void
TagListWidget::addItem( const QString & label )
{
    m_tags << label;
    QListWidget::addItem( label );
}


void 
TagListWidget::addItems( const QStringList & labels )
{
    m_tags << labels;
    QListWidget::addItems( labels );
}


void
TagListWidget::setSortOrder( Tags::SortOrder sortOrder )
{    
    if ( sortOrder == Tags::AscendingOrder )
        sortAZ();
    else if ( sortOrder == Tags::DescendingOrder )
        sortZA();
    else if ( sortOrder == Tags::MostPopularOrder )
        sortMostPopular();
}
