/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Christian Muehlhaeuser, Last.fm Ltd <chris@last.fm>                *
 *      Erik Jlevik, Last.fm Ltd <erik@last.fm>                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#ifndef CRASHREPORTER_H
#define CRASHREPORTER_H

#include <QDialog>
#include <QString>
#include <QFile>

#include "ui_CrashReporterDialog.h"

class Http;

class CrashReporter : public QDialog
{
    Q_OBJECT

    public:
        CrashReporter(
            int argc,
            char* argv[],
            QWidget* parent = 0 );

        virtual int exec();

    protected:
        virtual void reject();

    private:
        QString parseArg(
            const char* arg );
        void gatherData();
        bool zipFiles();
        void sendZip();
        void setProgress(
            int task,
            float percent );

        Ui::CrashReporterDialog ui;
        
        QString m_username;
        QString m_passMd5;
        QString m_pathMinidump;
        QString m_pathLogDir;
        
        QStringList m_filesToZip;
        
        Http* m_http;
        QFile m_zipFile;
        int m_reqId;

    private slots:
        void go();
        void sendFinished(
            int id,
            bool error );
        void sendProgressMade(
            int done,
            int total );

};

#endif // CRASHREPORTER_H
