# This needs to be added here to enable a japanese build.
#DEFINES += HIDE_RADIO

win32: ROOT_DIR = $$system( cd )
else:  ROOT_DIR = $$system( pwd )

BIN_DIR = $$ROOT_DIR/bin
BUILD_DIR = $$ROOT_DIR/build/$$TARGET
DESTDIR = $$BIN_DIR

# both debug and release can have the same directory as uic doesn't take into 
# account any preprocessor stuff or gcc flags
UI_DIR = $$ROOT_DIR/build

LIBPATH += $$BIN_DIR
INCLUDEPATH += $$ROOT_DIR/src $$ROOT_DIR/src/libLastFmTools $$UI_DIR
DEPENDPATH += $$ROOT_DIR/src/libLastFmTools


CONFIG( service ) {
    CONFIG += plugin
    
    win32: DESTDIR = $$BIN_DIR
    else:  DESTDIR = $$BIN_DIR/services
    
    TARGET = srv_$$TARGET
}

CONFIG( extension ) {
    CONFIG += plugin
    
    win32: DESTDIR = $$BIN_DIR
    else:  DESTDIR = $$BIN_DIR/extensions
    
    TARGET = ext_$$TARGET
}

CONFIG(debug, debug|release) {
    unix:mac:CONFIG += x86
    
    unix:EXT = _debug
    else:EXT = d

    TARGET = $$TARGET$$EXT

    OBJECTS_DIR = $$BUILD_DIR/debug
    MOC_DIR = $$BUILD_DIR/debug
    
    ##TODO service or extension CONFIG
    contains( TEMPLATE, lib ):DESTDIR = $$DESTDIR/debug
    
    # prevents the second instance just transferring control to the first 
    # via the socket, which is useful if you want to run a client for fun, and 
    # a client for debug -- mxcl
    DEFINES += LASTFM_MULTI_PROCESS_HACK

	VERSION_UPDATE_PATTERN = *.*.*.*
}

CONFIG(release, release|debug) {
    unix:mac:CONFIG += ppc x86
    
    OBJECTS_DIR = $$BUILD_DIR/release
    MOC_DIR = $$BUILD_DIR/release

	VERSION_UPDATE_PATTERN = *.*.*.+
}

plugin:LIBS += -lLastFmTools$$EXT
contains( TEMPLATE, app ):LIBS += -lLastFmTools$$EXT

win32 {
	# Build pdb files also for release builds
    QMAKE_LFLAGS_RELEASE += /DEBUG
    
    # Make the linker tell us what it's doing
    QMAKE_LFLAGS_DEBUG += /VERBOSE:LIB
    
    # Removes warnings about standard library usage
    DEFINES += _CRT_SECURE_NO_DEPRECATE _SCL_SECURE_NO_DEPRECATE
    
    # Prevents windows.h from including winsock.h as it will clash with
    # Winsock2.h which is included by the player listener.
    DEFINES += _WINSOCKAPI_
    
	# In order to request the proper priviliges on Vista, we need to embed the
	# default linker-generated manifest and then merge it with our hand-written
	# one containing the trustInfo section. The merging will be specified with a
	# QMAKE_POST_LINK directive in the project pro.
    CONFIG += embed_manifest_exe
}

linux* {
    DEFINES += LINUX
}
