/*
 *   LADCCA
 *    
 *   Copyright (C) 2002 Robert Ham <rah@bash.sh>
 *    
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __LADCCA_TYPES_H__
#define __LADCCA_TYPES_H__

#define CCA_DEFAULT_PORT 14541

#ifdef __cplusplus
extern "C" {
#endif


enum CCA_Client_Flag
{
  CCA_Config_Data_Set    =  0x00000001,  /* wants to save data on the server */
  CCA_Config_File        =  0x00000002,  /* wants to save data in files */

  CCA_Server_Interface   =  0x00000004,  /* is a server interface */
  CCA_No_Autoresume      =  0x00000008,  /* server shouldn't try to resume a lost client with this one */
  CCA_Terminal           =  0x00000010   /* runs in a terminal */
};

enum CCA_Event_Type
{
  /* for normal clients */
  CCA_Client_Name = 1,  /* set the client's user-visible name */
  CCA_Jack_Client_Name, /* tell the server what name the client is connected to jack with */
  CCA_Alsa_Client_ID,   /* tell the server what id the client is connected to the alsa sequencer with */
  CCA_Save_File,        /* tell clients to save to files */
  CCA_Restore_File,     /* tell clients to restore from files */
  CCA_Save_Data_Set,    /* tell clients to send the server a data set */
  CCA_Restore_Data_Set, /* tell clients a data set will be arriving */
  CCA_Save,             /* save the project */
  CCA_Quit,             /* tell the server to close the connection */
  CCA_Server_Lost,      /* the server disconnected */

  /* for the server interface */
  CCA_Project_Add,             /* new project has been created */
  CCA_Project_Remove,          /* existing project has been lost */
  CCA_Project_Dir,             /* change project dir */
  CCA_Project_Name,            /* change project name */
  CCA_Client_Add,              /* a new client has been added to a project */
  CCA_Client_Remove,           /* a client has been lost from a project */
  CCA_Percentage               /* display a percentage of an action to the user */
};


/* the set of ladcca-specific arguments that are extracted from argc/argv */
typedef struct _cca_args cca_args_t;

/* the main client-side handle for the server connection */
typedef struct _cca_client cca_client_t;

/* an event */
typedef struct _cca_event cca_event_t;

/* a bit of key-indexed data */
typedef struct _cca_config cca_config_t;


#ifdef __cplusplus
}
#endif


#endif /* __LADCCA_TYPES_H__ */
