//LabPlot : PruneListDialog.cc

#include "PruneListDialog.h"
#include "defs.h"

PruneListDialog::PruneListDialog(MainWin *mw, const char *name)
	: ListDialog(mw, name)
{
	setCaption(i18n("Prune Dialog"));
	KConfig *config = mw->Config();
	config->setGroup( "Prune" );

	QTabWidget *tw = new QTabWidget(vbox);
	QVBox *tab1 = new QVBox(tw);

	new QLabel(i18n(" Prune every n points : "),tab1);
	QHBox *hb = new QHBox(tab1);
	new QLabel(QString(" n = "),hb);
	nni = new KIntNumInput(config->readNumEntry("Points",3),hb);
	nni->setRange(1,INF,1,false);

	Style *style=0;
	Symbol *symbol=0;
	QVBox *styletab;
	if(p && p->getPlot(p->API())->Type() == PSURFACE)
		styletab = surfaceStyle(tw,true);
	else
		styletab = simpleStyle(tw, style, symbol);

	tw->addTab(tab1,i18n("Parameter"));
	tw->addTab(styletab,i18n("Style"));

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
        QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));
	QObject::connect(save,SIGNAL(clicked()),SLOT(saveSettings()));

	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}
 
void PruneListDialog::saveSettings() {
	KConfig *config = mw->Config();
	config->setGroup( "Prune" );
	
	config->writeEntry("Points", nni->value());
}

int PruneListDialog::apply_clicked() {
	int n = nni->value();

	if(s) {
		QTable *table = s->Table();
		int col = table->currentColumn();
		
		if(n >= table->numRows()) {
			KMessageBox::error(this,i18n("n bigger than number of rows!\nPlease use a smaller value."));
			return -1;
		}

		// add column if needed
		bool empty=true;
		for(int i=0;i<table->numRows();i++) {
			if(!table->text(i,table->numCols()-1).isEmpty()) {
				empty =false;
			}
		}
		if (!empty)
			s->addColumn();

		int newcol = table->numCols()-1;
		for (int i = 0;i<table->numRows()/n;i++) {
			double sum = 0;
			for (int j=0;j<n;j++) {
				sum+=table->text(i+j,col).toDouble();
			}
			sum = sum/n;
			
			// insert into last column
			int index = (int) (n*i+n/2);
			table->setText(index,newcol,table->text(index,col));
		}
		return 0;
	}

	GraphList *gl = p->getPlot(p->API())->getGraphList();
	if(gl->Number()==0) {
		KMessageBox::error(this,i18n("No graph found!"));
		return -2;
	}
	int item = (int) (lv->itemPos(lv->currentItem())/lv->currentItem()->height());

	GRAPHType st = gl->getStruct(item);

	Style *style=0;
	Symbol *symbol=0;
	if(st != GRAPHM) {
		style = new Style(cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color(),
			width->value(),pencb->currentItem(),brushcb->currentItem());
		style->setBoxWidth(boxwidth->value());
		style->setAutoBoxWidth(autobox->isChecked());
		style->setPointsSorting(sortpointscb->isChecked());
		symbol = new Symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->value(),
			(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());
	}	
	
	double xmin=0, xmax=1, ymin=0, ymax=1, zmin=0, zmax=1, tmin=0, tmax=1;
	if (st == GRAPH2D) {
		Graph2D *g = gl->getGraph2D(item);
		int nx = g->Number();
		Point *ptr = new Point[nx/n];
		Point *a = g->Data();

		if(n >= nx) {
			KMessageBox::error(this,i18n("n bigger than number of points!\nPlease use a smaller value."));
			return -1;
		}

		for (int i = 0;i<nx/n;i++) {
			int index = (int) (n*i+n/2);
			double x = a[index].X();
			double y = a[index].Y();

			ptr[i].setPoint(x,y);
		}

		mw->calculateRanges2D(ptr,g->Number()/n,&xmin,&xmax,&ymin,&ymax);

		LRange range[2];
		range[0] = LRange(xmin,xmax);
		range[1] = LRange(ymin,ymax);
		
		QString fun = QString(i18n("prune (")+QString::number(n)+i18n(") of ")+g->getLabel()->simpleTitle());
		
		Graph2D *ng = new Graph2D(fun,fun,range,SSPREADSHEET,P2D,style,symbol,ptr,g->Number()/n);
		mw->addGraph2D(ng,sheetcb->currentItem());
	}
	else if (st == GRAPH3D) {
		Graph3D *g = gl->getGraph3D(item);
		int nx = g->Number();
		Point3D *ptr = new Point3D[nx/n];
		Point3D *a = g->Data();

		if(n >= nx) {
			KMessageBox::error(this,i18n("n bigger than number of points!\nPlease use a smaller value."));
			return -1;
		}

		// TODO : PQWT3D
		if(type != P2D) {
			KMessageBox::error(this,i18n("Sorry. This function is not yet implemented!"));
			return -2;
		}
		
		for (int i = 0;i<nx/n;i++) {
			int index = (int) (n*i+n/2);
			double x = a[index].X(), y = a[index].Y(), z= a[index].Z();

			ptr[i].setPoint(x,y,z);
		}

		mw->calculateRanges3D(ptr,g->Number()/n,&xmin,&xmax,&ymin,&ymax,&zmin,&zmax);

		// create the new Graph
		LRange range[3];
		range[0] = LRange(xmin,xmax);
		range[1] = LRange(ymin,ymax);
		range[2] = LRange(zmin,zmax);
		
		QString fun = QString(i18n("prune (")+QString::number(n)+i18n(") of ")+g->getLabel()->simpleTitle());
		
		Graph3D *ng = new Graph3D(fun,fun,range,SSPREADSHEET,P2D,style,symbol,ptr,g->Number()/n,1);
		ng->setNumberX((int)(g->NX()/n));
		ng->setNumberY((int)(g->NY()));
		mw->addGraph3D(ng,sheetcb->currentItem(),type);
	}
	else if (st == GRAPH4D) {
		Graph4D *g = gl->getGraph4D(item);
		int nx = g->Number();
		Point4D *ptr = new Point4D[nx/n];
		Point4D *a = g->Data();

		if(n >= nx) {
			KMessageBox::error(this,i18n("n bigger than number of points!\nPlease use a smaller value."));
			return -1;
		}

		for (int i = 0;i<nx/n;i++) {
			int index = (int) (n*i+n/2);
			double x = a[index].X(), y = a[index].Y(), z= a[index].Z(), t= a[index].T();

			ptr[i].setPoint(x,y,z,t);
		}

		mw->calculateRanges4D(ptr,nx/n,&xmin,&xmax,&ymin,&ymax,&zmin,&zmax,&tmin,&tmax);

		LRange range[4];
		range[0] = LRange(xmin,xmax);
		range[1] = LRange(ymin,ymax);
		range[2] = LRange(zmin,zmax);
		range[3] = LRange(tmin,tmax);
		
		QString fun = QString(i18n("prune (")+QString::number(n)+i18n(") of ")+g->getLabel()->simpleTitle());
		
		Graph4D *ng = new Graph4D(fun,fun,range,SSPREADSHEET,type,style,symbol,ptr,nx/n,g->GType());
		mw->addGraph4D(ng,sheetcb->currentItem());
	}

	updateList();

	return 0;
}
