//LabPlot : Plot.h

#ifndef PLOT_H
#define PLOT_H

#include <math.h>
#include "Worksheet.h"
#include "Legend.h"
#include "Label.h"
#include "Axis.h"

#ifdef HAVE_GL
#include "qwt3d_surfaceplot.h"
#endif

class Legend;

class Plot {
public:
	Plot(class Worksheet *p);
	virtual ~Plot() {}
	GraphList *getGraphList() { return graphlist; }
	void clear() {graphlist->clear();}
	void save(QTextStream *t);
	void open(QTextStream *t, int version);
	QDomElement savePlotXML(QDomDocument doc);
	void openPlotXML(QDomNode node);
	virtual void saveXML(QDomDocument doc, QDomElement plottag) = 0;
	virtual void openXML(QDomElement e) = 0;
	virtual void saveAxes(QTextStream *t) = 0;
	virtual void openAxes(QTextStream *t, int version) = 0;
	void saveAxis(QTextStream *t,Axis *axis);
	void openAxis(QTextStream *t,int version, Axis *axis);

	QString TicLabel(int atlf, int prec, QString dtf, double value);
	double TicLabelValue(int atlf, QString string);
	
	virtual Axis *getAxis(int i) = 0;
	Legend* getLegend() { return &legend; }
	void setType(PType i) { type = i; }
	PType Type() { return type; }
	Label* Title() { return title; }
	virtual void setRange(LRange *,int i) = 0;
	LRange* Range(int i) { return &range[i];}
	virtual void setActRange(LRange *,int i) = 0;
	LRange* ActRange(int i) { return &actrange[i];}
	virtual void setRanges(LRange *) = 0;
	LRange* Ranges() { return range;}
	virtual void setActRanges(LRange *) = 0;
	LRange* ActRanges() { return actrange;}
	void setRegionMin(double min) {region->setMin(min);}
	void setRegionMax(double max) {region->setMax(max);}
	void setRegion(double min, double max) {region->setMin(min); region->setMax(max);}
	void setRegion(LRange *r) {region->setMin(r->rMin()); region->setMax(r->rMax());}
	double RegionMin() {return region->rMin();}
	double RegionMax() {return region->rMax();}
	LRange *Region() { return region; }
	bool regionEnabled() { return region_enabled; }
	void enableRegion(bool e=true) { region_enabled = e; }
	void setRegionEnabled(bool e=true) { enableRegion(e); }
	void setTransparent(bool t) { transparent = t; }
	bool Transparent() { return transparent; }
	void setClipOffset(int c) { clipoffset=c;}
	int ClipOffset() { return clipoffset;}

	bool BaselineEnabled() { return baseline_enabled; }
	void enableBaseline(bool e=true) { baseline_enabled = e; }
	void setBaselineEnabled(bool e=true) { enableBaseline(e); }
	double Baseline() { return baseline; }
	void setBaseline(double b) { baseline = b; }
	double XBaseline() { return xbaseline; }
	void setXBaseline(double b) { xbaseline = b; }
	bool XBaselineEnabled() { return xbaseline_enabled; }
	void enableXBaseline(bool e=true) { baseline_enabled = e; }
	void setXBaselineEnabled(bool e=true) { enableXBaseline(e); }

	bool marksEnabled() { return marks_enabled; }			// marker
	void enableMarks(bool m=true) { marks_enabled=m; }
	void setMarksEnabled(bool m=true) { enableMarks(m); }
	LRange *markX() { return markx; }
	void setMarkX(LRange *l) { markx=l; }
	LRange *markY() { return marky; }
	void setMarkY(LRange *l) { marky=l; }
	void setFill(bool f=true) { fill_enabled=f; }				// fill
	bool Fill() { return fill_enabled; }		
	void setFillType(int t) { filltype=t; }
	int  FillType() { return filltype; }
	void setFillG1(int f) { fillg1=f; }
	int FillG1() { return fillg1; }
	void setFillG2(int f) { fillg2=f; }
	int FillG2() { return fillg2; }
	void setFillBrush(QBrush b) { fillbrush=b; }
	QBrush FillBrush() { return fillbrush; }

	virtual void draw(QPainter *p, int w, int h) = 0;
	void sortPoints(QPointArray pa, int s, int e);
	void drawStyle(QPainter *p, Style *s, Symbol *symbol, QPointArray pa, int xmin, int xmax, int ymin, int ymax);
	void drawErrorBar(QPainter *p, QPointArray pa, QPointArray hpa, QPointArray vpa);
	bool inside(double x, double y) {
		if(x>position.X() && x<position.X()+size.X() && y>position.Y() && y<position.Y()+size.Y())
			return true;
		else
			return false;
	}
	bool insideLegend(int x,int y) { if (legend.inside(x,y)) return true; return false;}
	bool insidePlottingArea(double x,double y) {
		if (x>p1.X() && x<p2.X() && y>p1.Y() && y<p2.Y()) return true; return false;
	}
	bool insideF1Corner(double x, double y) {
		if(fabs(x-position.X()) < 0.01 && fabs(y-position.Y())<0.01)
			return true;
		return false;
	}
	bool insideF2Corner(double x, double y) {
		if(fabs(x-position.X()-size.X()) < 0.01 && fabs(y-position.Y()-size.Y())<0.01)
			return true;
		return false;
	}
	bool insideB1Corner(double x, double y) {
		if(fabs(x-position.X()) < 0.01 && fabs(y-position.Y()-size.Y())<0.01)
			return true;
		return false;
	}
	bool insideB2Corner(double x, double y) {
		if(fabs(x-position.X()-size.X()) < 0.01 && fabs(y-position.Y())<0.01)
			return true;
		return false;
	}
	bool insideX1Border(double x, double y) {
		if(x >position.X() && x<position.X()+size.X() && fabs(y-position.Y()-size.Y())<0.01)
			return true;
		return false;
	}
	bool insideX2Border(double x, double y) {
		if(x >position.X() && x<position.X()+size.X() && fabs(y-position.Y())<0.01)
			return true;
		return false;
	}
	bool insideY1Border(double x, double y) {
		if(y >position.Y() && y<position.Y()+size.Y() && fabs(x-position.X())<0.01)
			return true;
		return false;
	}
	bool insideY2Border(double x, double y) {
		if(y >position.Y() && y<position.Y()+size.Y() && fabs(x-position.X()-size.X())<0.01)
			return true;
		return false;
	}
	bool insideCenter(double x, double y) {
		if(fabs(x-position.X()-size.X()/2.0)<0.01 && fabs(y-position.Y()-size.Y()/2.0)<0.01)
			return true;
		return false;
	}
	void setPosition(Point p) { position = p; }
	void setPosition(double x, double y) { position = Point(x,y); }
	Point Position() { return position; }
	void setSize(Point s) { size = s; }
	void setSize(double x, double y) { size = Point(x,y); }
	Point Size() { return size; }
	void enableAspectRatio(bool a=true) { aspect_enabled=a; }
	bool AspectRatioEnabled() { return aspect_enabled; }
	QColor Background() { return bgcolor; }
	void setBackground(QColor c) { bgcolor = c; }
	void setBackground(QString c) { bgcolor = QColor(c); }
	QColor graphBackground() { return gbgcolor; }
	void setGraphBackground(QColor c) { gbgcolor = c;}
	void setGraphBackground(QString c) { gbgcolor = QColor(c);}
	void autoScaleX();
	void autoScaleY();
	void autoScaleZ();
	void autoScaleAll() { autoScaleX(); autoScaleY(); autoScaleZ(); }
	void setXRange(double x1, double x2) {actrange[0].setMin(x1); actrange[0].setMax(x2); }
	void setYRange(double y1, double y2) {actrange[1].setMin(y1); actrange[1].setMax(y2); }
	void setZRange(double z1, double z2) {actrange[2].setMin(z1); actrange[2].setMax(z2); }

	Point P1() { return p1;}
	Point P2() { return p2;}
	void setP1(Point p) { p1=p;}
	void setP2(Point p) { p2=p;}
	void setLeftPanel() { p1.setX(0.0); }
	void setRightPanel() { p2.setX(1.0); }
	void setTopPanel() { p1.setY(0.0); }
	void setBottomPanel() { p2.setY(1.0); }
	
	void setXMin(int xmin,int X) { p1.setPoint((xmin/(double)X-position.X())/size.X(),p1.Y()); }
	void setXMax(int xmax,int X) { p2.setPoint((xmax/(double)X-position.X())/size.X(),p2.Y()); }
	void setYMin(int ymin,int Y) { p1.setPoint(p1.X(),(ymin/(double)Y-position.Y())/size.Y()); }
	void setYMax(int ymax,int Y) { p2.setPoint(p2.X(),(ymax/(double)Y-position.Y())/size.Y()); }

	void shiftRight();
	void shiftLeft();
	void shiftUp();
	void shiftDown();
	void scaleXUp();
	void scaleXDown();
	void scaleYUp();
	void scaleYDown();
	void scaleZUp();
	void scaleZDown();
	void zoomIn();
	void zoomOut();

	Point dataValue(double x);
protected:
	int autoTicks(double min, double max);	// calcuate tick number for auto ticks
	void readAxisSettings(Axis *a, int type, int item=0);	// read default settings for axis
#ifdef HAVE_GL
	Qwt3D::ColorVector convertOldColormap(int index);
#endif
	Worksheet *worksheet;			// parent worksheet
	PType type;				// type of the plot
	GraphList *graphlist;			// list of graphs
	Point position, size;				// position and size (0..1)
	bool aspect_enabled;			// plot in aspect ratio
	Label *title;					// Title
	Legend legend;				// Legend
	QColor bgcolor, gbgcolor;		// background & graph background color
	Point p1, p2;					// plotting area	(0..1)
	LRange range[3];				// graph ranges	(x,y,z)
	LRange actrange[3];			// actual plotting range (x,y,z)
	double baseline;				// baseline
	bool baseline_enabled;			// draw it ?
	double xbaseline;				// x baseline
	bool xbaseline_enabled;			// draw it ?
	LRange *region;				// region
	bool region_enabled;			// draw it ?
	bool transparent;				// draw bgcolor & gbgcolor ?
	int clipoffset;					// offset for clipping area drawing (Symbols->full drawn, line section->limited)
	bool marks_enabled;
	LRange *markx, *marky;			// marker
	bool fill_enabled;				// fill between curve fillg1 and fillg2 ?
	int filltype;					// 0-all, 1-higher, 2-lower, 3-region
	int fillg1, fillg2;
	QBrush fillbrush;				// use brush for fill
};

#ifndef HAVE_LOG2
inline double log2(double x) {return log(x)/log(2.0);}
#endif

#endif // PLOT_H
