//LabPlot : LabPlot.cc
#include <iostream>
#include <kapp.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include "MainWin.h"
#include "qjp2io.h"
#include "qtiffio.h"

#include "LabPlotSplash.h"

using namespace std;

static KCmdLineOptions options[] = {
	{ "no-splash", I18N_NOOP("do not show the splash screen"), 0 },
	{ "+[file]", I18N_NOOP("open a project file"), 0 },
	KCmdLineLastOption
};

int main(int argc, char *argv[]) {
	KAboutData aboutData("LabPlot","LabPlot", LVERSION,
		I18N_NOOP("An application for plotting and analysis of 2d and 3d functions and data."),
		KAboutData::License_GPL, "(c) 2006, Stefan Gerlach",0,"http://labplot.sourceforge.net",
		"http://sourceforge.net/tracker/?group_id=90279&atid=593035");
	aboutData.addAuthor("Stefan Gerlach", 0, "gerlach@mbi-berlin.de");
	KCmdLineArgs::init(argc, argv, &aboutData);
	KCmdLineArgs::addCmdLineOptions(options);

	qInitJp2IO();
#ifdef HAVE_TIFF
	qInitTiffIO();
#endif
	const char *filename=0;
	KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
	if (args->count() > 0)
		filename = args->arg(0);

	KApplication a;
	
#if QT_VERSION > 0x030102
	if (args->isSet("-splash")) {
		static LabPlotSplash *splash = new LabPlotSplash("labplot.png");
		if (splash) splash->show();
	}
#endif

	MainWin *w = new MainWin("MainWindow",filename);
	args->clear();

	a.setMainWidget(w);
	w->show();

	
	return a.exec(); 
}
