//LabPlot : HankelListDialog.cc

#include "HankelListDialog.h"

#ifdef HAVE_GSL
#include <gsl/gsl_dht.h>
#endif
	
HankelListDialog::HankelListDialog(MainWin *mw, const char *name)
	: ListDialog(mw, name)
{
	kdDebug()<<"HankelListDialog()"<<endl;
	setCaption(i18n("Hankel Dialog"));
	KConfig *config = mw->Config();
	config->setGroup( "Hankel" );

	QTabWidget *tw = new QTabWidget(vbox);
	QVBox *tab1 = new QVBox(tw);

	QHBox *hb = new QHBox(tab1);
	new QLabel(i18n(" nu = "),hb);
	nule = new KLineEdit(config->readEntry("Nu","0"),hb);
	nule->setValidator(new QDoubleValidator(nule));
	
	Style *style=0;
	Symbol *symbol=0;
	QVBox *styletab;
	if(p && p->getPlot(p->API())->Type() == PSURFACE) {
		styletab = surfaceStyle(tw,true);
	}
	else {
		styletab = simpleStyle(tw, style, symbol);
	}

	tw->addTab(tab1,i18n("Parameter"));
	tw->addTab(styletab,i18n("Style"));

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
        QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));
	QObject::connect(save,SIGNAL(clicked()),SLOT(saveSettings()));

	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

void HankelListDialog::saveSettings() {
	KConfig *config = mw->Config();
	config->setGroup( "Hankel" );

	config->writeEntry("Nu",nule->text());
}

int HankelListDialog::apply_clicked() {
	kdDebug()<<"HankelListDialog::apply_clicked()"<<endl;
#ifdef HAVE_GSL

	// get Graph2D object
	Graph2D *g=0;
	Graph3D *g3=0;
	Graph4D *g4=0;
	if(s)
		g = s->getGraph2D();

	else if(p) {
		GraphList *gl = p->getPlot(p->API())->getGraphList();
		int item = (int) (lv->itemPos(lv->currentItem())/lv->currentItem()->height());
		GRAPHType st = gl->getStruct(item);

		if (st == GRAPH2D)
			g = gl->getGraph2D(item);
		else if (st == GRAPH3D)
			g3 = gl->getGraph3D(item);
		else if (st == GRAPH4D)
			g4 = gl->getGraph4D(item);
	}

	if(g != 0 || g3 != 0 || g4 != 0) {
		int n=0;
		LRange xrange;
		Point *data=0;
		Point3D *data3=0;
		Point4D *data4=0;
		QString label;
		 
		 if(g) {
			n = g->Number();
		 	data = g->Data();
			xrange = g->Range(0);
			label = g->getLabel()->simpleTitle();
		}
		 else if(g3) {
			n = g3->Number();
		 	data3 = g3->Data();
			xrange = g3->Range(0);
			label = g3->getLabel()->simpleTitle();
		}
		 else if(g4) {
			n = g4->Number();
		 	data4 = g4->Data();
			xrange = g4->Range(0);
			label = g4->getLabel()->simpleTitle();
		}

		double *oldtmp = new double[n];
		double *newtmp = new double[n];

		for(int i=0;i<n;i++) {
			if(g)
				oldtmp[i]=data[i].Y();
			else if (g3)
				oldtmp[i]=data3[i].Y();
			else if (g4)
				oldtmp[i]=data4[i].Y();
		}
		double nu=nule->text().toInt(), maxx=xrange.rMax();
		if(maxx<=0) {
			KMessageBox::error(this,i18n("xmax is not positive! Giving up."));
			return -1;
		}
	 	gsl_dht *h = gsl_dht_new(n,nu,maxx); 
		gsl_dht_apply(h,oldtmp,newtmp);
		gsl_dht_free(h);
		
		// TODO :What about gsl_dht_x_sample (const gsl_dht * t, int n) and gsl_dht_k_sample (const gsl_dht * t, int n) 
		
		double xmin=0, xmax=1, ymin=0, ymax=1;
		Point *ptr = new Point[n];
		for (int i = 0;i<n;i++) {
			double x=0;
			 if(g)
				x = data[i].X();
			else if (g3)
				x = data3[i].X();
			else if (g4)
				x = data4[i].X();
			double y = newtmp[i];

			ptr[i].setPoint(x,y);
		}

		mw->calculateRanges2D(ptr,n,&xmin,&xmax,&ymin,&ymax);
		
		// create the new Graph
		LRange range[2];
		range[0] = LRange(xmin,xmax);
		range[1] = LRange(ymin,ymax);

		QString fun = QString(i18n("hankel transform of ")+label);

		Style *style = 0;
		Symbol *symbol = 0;
		if(p) {
			style = new Style(cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color(),
				width->value(),pencb->currentItem(),brushcb->currentItem());
			style->setBoxWidth(boxwidth->value());
			style->setAutoBoxWidth(autobox->isChecked());
			style->setPointsSorting(sortpointscb->isChecked());
			symbol = new Symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->value(),
				(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());
		}

		Graph2D *ng = new Graph2D(fun,fun,range,SSPREADSHEET,P2D,style,symbol,ptr,n);
		//TODO : spreadsheet : select destination
		int item=0;
		if(p)
			item=sheetcb->currentItem();
		mw->addGraph2D(ng,item);
	}

	if(p) updateList();
#endif

	return 0;
}
