//LabPlot : Arrow.cc

#include <math.h>
#include <iostream>
#include <kdebug.h>
#include "Arrow.h"

using namespace std;

Arrow::Arrow(bool l,bool e,double le,double a,bool f,QColor fc)
	: location(l),enabled(e), length(le), angle(a),filled(f),fillcolor(fc)
{}

QStringList Arrow::Info() {
	QStringList s;

	s << QString::number(enabled) << QString::number(length);
	s << QString::number(angle);
	s << QString::number(filled);
	s << fillcolor.name();
	
	return s;
}

// draw the arrow on the worksheet
void Arrow::draw(QPainter *p, Point start, Point end,int X, int Y) {
	int sx = (int) (X*start.X()), sy = (int) (Y*start.Y());
	int ex = (int) (X*end.X()), ey = (int)(Y*end.Y());
	double dx = (ex-sx)*length;
	double dy = (ey-sy)*length;
	QPointArray a;
	
	if (enabled) {
		double l = length*sqrt(dx*dx+dy*dy);
		double a1 = M_PI*angle/180.0 + atan(dy/dx);
		double a2 = - M_PI*angle/180.0 + atan(dy/dx);
		if(location==0) {	//start
			int x1 = sx+(int) (l*cos(a1));
			int y1 = sy+(int) (l*sin(a1));
			int x2 = sx+(int) (l*cos(a2));
			int y2 = sy+(int) (l*sin(a2));
			if (filled) {
				p->setBrush(fillcolor);
	                        a.setPoints(3,sx,sy,x1,y1,x2,y2);
        	                p->drawPolygon(a);
			}
			else {
				p->drawLine(sx,sy,x1,y1);
				p->drawLine(sx,sy,x2,y2);
			}
		}
		else {		// end
			int x1 = ex-(int) (l*cos(a1));
			int y1 = ey-(int) (l*sin(a1));
			int x2 = ex-(int) (l*cos(a2));
			int y2 = ey-(int) (l*sin(a2));
			if (filled) {
				p->setBrush(fillcolor);
	                        a.setPoints(3,ex,ey,x1,y1,x2,y2);
        	                p->drawPolygon(a);
			}
			else {
				p->drawLine(ex,ey,x1,y1);
				p->drawLine(ex,ey,x2,y2);
			}
		}
	}
}

void Arrow::save(QTextStream *t){
	*t<<(int)location<<' '<<(int)enabled<<' '<<length<<' '<<angle<<' '<<(int)filled<<' '<<fillcolor.name()<<endl;
}

void Arrow::open(QTextStream *t,int) {
//	kdDebug()<<"Arrow::open() : "<<version<<endl;
	QString color;
	int l,e,f;

	*t>>l>>e>>length>>angle>>f>>color;
	location=l;
	enabled=e;
	filled=f;
	fillcolor=QColor(color);
}

QDomElement Arrow::saveXML(QDomDocument doc, QString id) {
	QDomElement arrowtag = doc.createElement( id );

	QDomElement tag = doc.createElement( "Location" );
    	arrowtag.appendChild( tag );
  	QDomText t = doc.createTextNode( QString::number(location) );
    	tag.appendChild( t );
	tag = doc.createElement( "Enabled" );
    	arrowtag.appendChild( tag );
  	t = doc.createTextNode( QString::number(enabled) );
    	tag.appendChild( t );
	tag = doc.createElement( "Length" );
    	arrowtag.appendChild( tag );
  	t = doc.createTextNode( QString::number(length) );
    	tag.appendChild( t );
	tag = doc.createElement( "Angle" );
    	arrowtag.appendChild( tag );
  	t = doc.createTextNode( QString::number(angle) );
    	tag.appendChild( t );
	tag = doc.createElement( "Filled" );
    	arrowtag.appendChild( tag );
  	t = doc.createTextNode( QString::number(filled) );
    	tag.appendChild( t );
	tag = doc.createElement( "FillColor" );
    	arrowtag.appendChild( tag );
  	t = doc.createTextNode( fillcolor.name() );
    	tag.appendChild( t );

	return arrowtag;
}

void Arrow::openXML(QDomNode node) {
	while(!node.isNull()) {
		QDomElement e = node.toElement();
		kdDebug()<<"ARROW TAG = "<<e.tagName()<<endl;
		kdDebug()<<"ARROW TEXT = "<<e.text()<<endl;
		
		if(e.tagName() == "Location")
			location = (bool) e.text().toInt();
		if(e.tagName() == "Enabled")
			enabled = (bool) e.text().toInt();
		if(e.tagName() == "Length")
			length = e.text().toDouble();
		if(e.tagName() == "Angle")
			angle = e.text().toDouble();
		if(e.tagName() == "Filled")
			filled = (bool) e.text().toInt();
		else if(e.tagName() == "FillColor")
			fillcolor = QColor(e.text());

		node = node.nextSibling();
	}
}
