//LabPlot : ArrangePlotDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <math.h>
#include <qlabel.h>
#include <qhbox.h>
#include <qfontdialog.h>
#include <qslider.h>
#include <klocale.h>
#include "ArrangePlotDialog.h"

ArrangePlotDialog::ArrangePlotDialog(MainWin *mw, const char *name)
	: PlotDialog(mw, name)
{
	setCaption(i18n("Arrange Plots"));
	KConfig *config = mw->Config();
	config->setGroup( "Arrange" );

	QHBox* hb = new QHBox(vbox);
        new QLabel(i18n("Arrangement : "),hb);
	xni = new KIntNumInput(config->readNumEntry("X",2),hb);
	xni->setRange(1,8,1,false);
	new QLabel(i18n(" x "),hb);
	yni = new KIntNumInput(config->readNumEntry("Y",2),hb);
	yni->setRange(1,8,1,false);

	hb = new QHBox(vbox);
        new QLabel(i18n("Gap : "),hb);
	gaple = new KLineEdit(QString::number(config->readDoubleNumEntry("Gap",0.05)),hb);
	gaple->setValidator(new QDoubleValidator(0,0.4,4,gaple));

	hb = new QHBox(vbox);
	panel = new QCheckBox(i18n("Panel Plot"),hb);
	panel->setChecked(config->readBoolEntry("Panel",false));
	QObject::connect(panel,SIGNAL(stateChanged(int)),this,SLOT(updatePanelSelected(int)));
	
	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));
	QObject::connect(save,SIGNAL(clicked()),SLOT(saveSettings()));

	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

void ArrangePlotDialog::saveSettings() {
	KConfig *config = mw->Config();
	config->setGroup( "Arrange" );
	config->writeEntry("X", xni->value());
	config->writeEntry("Y", yni->value());
	config->writeEntry("Gap",gaple->text());
	config->writeEntry("Panel",panel->isChecked());
}

void ArrangePlotDialog::updatePanelSelected(int state) {
	if(state == QButton::On)
		gaple->setText("0.15");
	else
		gaple->setText("0.05");
}

// horizontal panel for nr>1
void ArrangePlotDialog::hPanel(Plot *plot[], int nr, double gap) {
	plot[0]->setP1(Point(gap,gap)); 
	plot[0]->setP2(Point(1.0,1.0-gap));
	for(int i=1; i < nr-1; i++) {
		plot[i]->setP1(Point(0.0,gap)); 
		plot[i]->setP2(Point(1.0,1.0-gap));
	}
	plot[nr-1]->setP1(Point(0.0,gap));
	plot[nr-1]->setP2(Point(1.0-gap,1.0-gap));
}

// vertical panel for nr>1
void ArrangePlotDialog::vPanel(Plot *plot[], int nr, double gap) {
	plot[0]->setP1(Point(gap,gap));
	plot[0]->setP2(Point(1.0-gap,1.0));
	for(int i=1; i < nr-1; i++) {
		plot[i]->setP1(Point(gap,0.0)); 
		plot[i]->setP2(Point(1.0-gap,1.0));
	}
	plot[nr-1]->setP1(Point(gap,0.0));
	plot[nr-1]->setP2(Point(1.0-gap,1.0-gap));
}

//! set plot parameter for panel plot
void ArrangePlotDialog::applyPanel(int nrx, int nry, double gap) {
	int nr = p->NrPlots();
	// gap used as gap between plot and border
	// TODO : enable/disable axes ?

#ifdef HAVE_SOLARIS
	Plot *plot[NR_PLOTS];
#else
	Plot *plot[nr];
#endif
	for(int i=0; i < nr; i++)
		plot[i] = p->getPlot(i);

	// general cases
	if(nr>1 && nrx == nr && nry == 1) {	// 1|2|3|...
		hPanel(plot,nr,gap);
		return;
	}
	else if(nr>1 && nrx == 1 && nry == nr) {	// 1/2/3/...
		vPanel(plot,nr,gap);
		return;
	}

	// special cases
	switch(nr) {
	case 1 :
		plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0-gap,1.0-gap));
		break;
	case 3:
		if(nrx == 2 && nry == 2){	//1|2 / 3|
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0-gap,1.0));
			plot[2]->setP1(Point(gap,0.0)); plot[2]->setP2(Point(1.0,1.0-gap));
		}
		break;
	case 4:
		if(nrx == 2 && nry == 2) {	// 1|2 / 3|4
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0-gap,1.0));
			plot[2]->setP1(Point(gap,0.0)); plot[2]->setP2(Point(1.0,1.0-gap));
			plot[3]->setP1(Point(0.0,0.0)); plot[3]->setP2(Point(1.0-gap,1.0-gap));
		}
		break;
	case 5: 
		if(nrx == 3 && nry == 2) {	// 1|2|3 / 4|5|
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0,1.0));
			plot[2]->setP1(Point(0.0,gap))	; plot[2]->setP2(Point(1.0-gap,1.0));
			plot[3]->setP1(Point(gap,0.0)); plot[3]->setP2(Point(1.0,1.0-gap));
			plot[4]->setP1(Point(0.0,0.0)); plot[4]->setP2(Point(1.0,1.0-gap));
		}
		else if(nrx == 2 && nry == 3) {	// 1|2 / 3|4 / 5|
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0-gap,1.0));
			plot[2]->setP1(Point(gap,0.0)); plot[2]->setP2(Point(1.0,1.0));
			plot[3]->setP1(Point(0.0,0.0)); plot[3]->setP2(Point(1.0-gap,1.0));
			plot[4]->setP1(Point(gap,0.0)); plot[4]->setP2(Point(1.0,1.0-gap));
		}
		break;
	case 6:
		if(nrx == 3 && nry == 2) {	// 1|2|3 / 4|5|6
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0,1.0));
			plot[2]->setP1(Point(0.0,gap)); plot[2]->setP2(Point(1.0-gap,1.0));
			plot[3]->setP1(Point(gap,0.0)); plot[3]->setP2(Point(1.0,1.0-gap));
			plot[4]->setP1(Point(0.0,0.0)); plot[4]->setP2(Point(1.0,1.0-gap));
			plot[5]->setP1(Point(0.0,0.0)); plot[5]->setP2(Point(1.0-gap,1.0-gap));
		}
		else if(nrx == 2 && nry == 3) {	// 1|2 / 3|4 / 5|6
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0-gap,1.0));
			plot[2]->setP1(Point(gap,0.0)); plot[2]->setP2(Point(1.0,1.0));
			plot[3]->setP1(Point(0.0,0.0)); plot[3]->setP2(Point(1.0-gap,1.0));
			plot[4]->setP1(Point(gap,0.0)); plot[4]->setP2(Point(1.0,1.0-gap));
			plot[5]->setP1(Point(0.0,0.0)); plot[5]->setP2(Point(1.0-gap,1.0-gap));
		}
		break;
	case 7:
		if(nrx == 4 && nry == 2) {	// 1|2|3|4 / 5|6|7|
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0,1.0));
			plot[2]->setP1(Point(0.0,gap)); plot[2]->setP2(Point(1.0,1.0));
			plot[3]->setP1(Point(0.0,gap)); plot[3]->setP2(Point(1.0-gap,1.0));
			plot[4]->setP1(Point(gap,0.0)); plot[4]->setP2(Point(1.0,1.0-gap));
			plot[5]->setP1(Point(0.0,0.0)); plot[5]->setP2(Point(1.0,1.0-gap));
			plot[6]->setP1(Point(0.0,0.0)); plot[6]->setP2(Point(1.0,1.0-gap));
		}
		else if (nrx == 3 && nry == 3) {	// 1|2|3 / 4|5|6 / 7||
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0,1.0));
			plot[2]->setP1(Point(0.0,gap)); plot[2]->setP2(Point(1.0-gap,1.0));
			plot[3]->setP1(Point(gap,0.0)); plot[3]->setP2(Point(1.0,1.0));
			plot[4]->setP1(Point(0.0,0.0));	 plot[4]->setP2(Point(1.0,1.0));
			plot[5]->setP1(Point(0.0,0.0)); plot[5]->setP2(Point(1.0-gap,1.0));
			plot[6]->setP1(Point(gap,0.0)); plot[6]->setP2(Point(1.0,1.0-gap));
		}
		else if(nrx == 2 && nry == 4) {	// 1|2 / 3|4 / 5|6 / 7|
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0-gap,1.0));
			plot[2]->setP1(Point(gap,0.0)); plot[2]->setP2(Point(1.0,1.0));
			plot[3]->setP1(Point(0.0,0.0)); plot[3]->setP2(Point(1.0-gap,1.0));
			plot[4]->setP1(Point(gap,0.0)); plot[4]->setP2(Point(1.0,1.0));
			plot[5]->setP1(Point(0.0,0.0)); plot[5]->setP2(Point(1.0-gap,1.0));
			plot[6]->setP1(Point(gap,0.0)); plot[6]->setP2(Point(1.0,1.0-gap));
		}
		break;
	case 8:
		if(nrx == 4 && nry == 2) {	// 1|2|3|4 / 5|6|7|8
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0,1.0));
			plot[2]->setP1(Point(0.0,gap)); plot[2]->setP2(Point(1.0,1.0));
			plot[3]->setP1(Point(0.0,gap)); plot[3]->setP2(Point(1.0-gap,1.0));
			plot[4]->setP1(Point(gap,0.0)); plot[4]->setP2(Point(1.0,1.0-gap));
			plot[5]->setP1(Point(0.0,0.0)); plot[5]->setP2(Point(1.0,1.0-gap));
			plot[6]->setP1(Point(0.0,0.0)); plot[6]->setP2(Point(1.0,1.0-gap));
			plot[7]->setP1(Point(0.0,0.0)); plot[7]->setP2(Point(1.0-gap,1.0-gap));
		}
		else if (nrx == 3 && nry == 3) {	// 1|2|3 / 4|5|6 / 7|8|
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0,1.0));
			plot[2]->setP1(Point(0.0,gap)); plot[2]->setP2(Point(1.0-gap,1.0));
			plot[3]->setP1(Point(gap,0.0)); plot[3]->setP2(Point(1.0,1.0));
			plot[4]->setP1(Point(0.0,0.0)); plot[4]->setP2(Point(1.0,1.0));
			plot[5]->setP1(Point(0.0,0.0)); plot[5]->setP2(Point(1.0-gap,1.0));
			plot[6]->setP1(Point(gap,0.0)); plot[6]->setP2(Point(1.0,1.0-gap));
			plot[7]->setP1(Point(0.0,0.0)); plot[7]->setP2(Point(1.0,1.0-gap));
		}
		else if(nrx == 2 && nry == 4) {	// 1|2 / 3|4 / 5|6 / 7|8 
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0-gap,1.0));
			plot[2]->setP1(Point(gap,0.0)); plot[2]->setP2(Point(1.0,1.0));
			plot[3]->setP1(Point(0.0,0.0)); plot[3]->setP2(Point(1.0-gap,1.0));
			plot[4]->setP1(Point(gap,0.0)); plot[4]->setP2(Point(1.0,1.0));
			plot[5]->setP1(Point(0.0,0.0)); plot[5]->setP2(Point(1.0-gap,1.0));
			plot[6]->setP1(Point(gap,0.0)); plot[6]->setP2(Point(1.0,1.0-gap));
			plot[7]->setP1(Point(0.0,0.0)); plot[7]->setP2(Point(1.0-gap,1.0-gap));
		}
		break;
	case 9:
		if(nrx == 5 && nry == 2) {	// 1|2|3|4|5 / 6|7|8|9|
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0,1.0));
			plot[2]->setP1(Point(0.0,gap)); plot[2]->setP2(Point(1.0,1.0));
			plot[3]->setP1(Point(0.0,gap)); plot[3]->setP2(Point(1.0,1.0));
			plot[4]->setP1(Point(0.0,gap)); plot[4]->setP2(Point(1.0-gap,1.0));
			plot[5]->setP1(Point(gap,0.0)); plot[5]->setP2(Point(1.0,1.0-gap));
			plot[6]->setP1(Point(0.0,0.0)); plot[6]->setP2(Point(1.0,1.0-gap));
			plot[7]->setP1(Point(0.0,0.0)); plot[7]->setP2(Point(1.0,1.0-gap));
			plot[8]->setP1(Point(0.0,0.0)); plot[8]->setP2(Point(1.0,1.0-gap));
		}
		else if(nrx == 4 && nry == 3) {	// 1|2|3|4 / 5|6|7|8 / |9|||
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0,1.0));
			plot[2]->setP1(Point(0.0,gap)); plot[2]->setP2(Point(1.0,1.0));
			plot[3]->setP1(Point(0.0,gap)); plot[3]->setP2(Point(1.0-gap,1.0));
			plot[4]->setP1(Point(gap,0.0)); plot[4]->setP2(Point(1.0,1.0));
			plot[5]->setP1(Point(0.0,0.0)); plot[5]->setP2(Point(1.0,1.0));
			plot[6]->setP1(Point(0.0,0.0)); plot[6]->setP2(Point(1.0,1.0));
			plot[7]->setP1(Point(0.0,0.0)); plot[7]->setP2(Point(1.0-gap,1.0));
			plot[8]->setP1(Point(gap,0.0)); plot[8]->setP2(Point(1.0,1.0-gap));
		}
		else if(nrx == 3 && nry == 3) {	// 1|2|3 / 4|5|6 / 7|8|9
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0,1.0));
			plot[2]->setP1(Point(0.0,gap)); plot[2]->setP2(Point(1.0-gap,1.0));
			plot[3]->setP1(Point(gap,0.0)); plot[3]->setP2(Point(1.0,1.0));
			plot[4]->setP1(Point(0.0,0.0)); plot[4]->setP2(Point(1.0,1.0));
			plot[5]->setP1(Point(0.0,0.0)); plot[5]->setP2(Point(1.0-gap,1.0));
			plot[6]->setP1(Point(gap,0.0)); plot[6]->setP2(Point(1.0,1.0-gap));
			plot[7]->setP1(Point(0.0,0.0)); plot[7]->setP2(Point(1.0,1.0-gap));
			plot[8]->setP1(Point(0.0,0.0)); plot[8]->setP2(Point(1.0-gap,1.0-gap));
		}
		else if(nrx == 2 && nry == 5) {	// 1|2 / 3|4 / 5|6 / 7|8 / 9|
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0-gap,1.0));
			plot[2]->setP1(Point(gap,0.0)); plot[2]->setP2(Point(1.0,1.0));
			plot[3]->setP1(Point(0.0,0.0)); plot[3]->setP2(Point(1.0-gap,1.0));
			plot[4]->setP1(Point(gap,0.0)); plot[4]->setP2(Point(1.0,1.0));
			plot[5]->setP1(Point(0.0,0.0)); plot[5]->setP2(Point(1.0-gap,1.0));
			plot[6]->setP1(Point(gap,0.0)); plot[6]->setP2(Point(1.0,1.0));
			plot[7]->setP1(Point(0.0,0.0)); plot[7]->setP2(Point(1.0-gap,1.0));
			plot[8]->setP1(Point(gap,0.0)); plot[8]->setP2(Point(1.0,1.0-gap));
		}
		break;
	case 10:
		if(nrx == 5 && nry == 2) {	// 1|2|3|4|5 / 6|7|8|9|10
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0,1.0));
			plot[2]->setP1(Point(0.0,gap)); plot[2]->setP2(Point(1.0,1.0));
			plot[3]->setP1(Point(0.0,gap)); plot[3]->setP2(Point(1.0,1.0));
			plot[4]->setP1(Point(0.0,gap)); plot[4]->setP2(Point(1.0-gap,1.0));
			plot[5]->setP1(Point(gap,0.0)); plot[5]->setP2(Point(1.0,1.0-gap));
			plot[6]->setP1(Point(0.0,0.0)); plot[6]->setP2(Point(1.0,1.0-gap));
			plot[7]->setP1(Point(0.0,0.0)); plot[7]->setP2(Point(1.0,1.0-gap));
			plot[8]->setP1(Point(0.0,0.0)); plot[8]->setP2(Point(1.0,1.0-gap));
			plot[9]->setP1(Point(0.0,0.0)); plot[9]->setP2(Point(1.0-gap,1.0-gap));
		}
		else if(nrx == 4 && nry == 3) {	// 1|2|3|4 / 5|6|7|8 / |9|10||
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0,1.0));
			plot[2]->setP1(Point(0.0,gap)); plot[2]->setP2(Point(1.0,1.0));
			plot[3]->setP1(Point(0.0,gap)); plot[3]->setP2(Point(1.0-gap,1.0));
			plot[4]->setP1(Point(gap,0.0)); plot[4]->setP2(Point(1.0,1.0));
			plot[5]->setP1(Point(0.0,0.0)); plot[5]->setP2(Point(1.0,1.0));
			plot[6]->setP1(Point(0.0,0.0)); plot[6]->setP2(Point(1.0,1.0));
			plot[7]->setP1(Point(0.0,0.0)); plot[7]->setP2(Point(1.0-gap,1.0));
			plot[8]->setP1(Point(gap,0.0)); plot[8]->setP2(Point(1.0,1.0-gap));
			plot[9]->setP1(Point(0.0,0.0)); plot[9]->setP2(Point(1.0,1.0-gap));
		}
		else if(nrx == 3 && nry == 4) {	// 1|2|3 / 4|5|6 / 7|8|9 / 10||
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0,1.0));
			plot[2]->setP1(Point(0.0,gap)); plot[2]->setP2(Point(1.0-gap,1.0));
			plot[3]->setP1(Point(gap,0.0)); plot[3]->setP2(Point(1.0,1.0));
			plot[4]->setP1(Point(0.0,0.0)); plot[4]->setP2(Point(1.0,1.0));
			plot[5]->setP1(Point(0.0,0.0)); plot[5]->setP2(Point(1.0-gap,1.0));
			plot[6]->setP1(Point(gap,0.0)); plot[6]->setP2(Point(1.0,1.0));
			plot[7]->setP1(Point(0.0,0.0)); plot[7]->setP2(Point(1.0,1.0));
			plot[8]->setP1(Point(0.0,0.0)); plot[8]->setP2(Point(1.0-gap,1.0));
			plot[9]->setP1(Point(gap,0.0)); plot[9]->setP2(Point(1.0,1.0-gap));
		}
		else if(nrx == 2 && nry == 5) {	// 1|2 / 3|4 / 5|6 / 7|8 / 9|10
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0-gap,1.0));
			plot[2]->setP1(Point(gap,0.0)); plot[2]->setP2(Point(1.0,1.0));
			plot[3]->setP1(Point(0.0,0.0)); plot[3]->setP2(Point(1.0-gap,1.0));
			plot[4]->setP1(Point(gap,0.0)); plot[4]->setP2(Point(1.0,1.0));
			plot[5]->setP1(Point(0.0,0.0)); plot[5]->setP2(Point(1.0-gap,1.0));
			plot[6]->setP1(Point(gap,0.0)); plot[6]->setP2(Point(1.0,1.0));
			plot[7]->setP1(Point(0.0,0.0)); plot[7]->setP2(Point(1.0-gap,1.0));
			plot[8]->setP1(Point(gap,0.0)); plot[8]->setP2(Point(1.0,1.0-gap));
			plot[9]->setP1(Point(0.0,0.0)); plot[9]->setP2(Point(1.0-gap,1.0-gap));
		}
		break;
	case 11:
		if(nrx == 6 && nry == 2) {	// 1|2|3|4|5|6 / 7|8|9|10|11|
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0,1.0));
			plot[2]->setP1(Point(0.0,gap)); plot[2]->setP2(Point(1.0,1.0));
			plot[3]->setP1(Point(0.0,gap)); plot[3]->setP2(Point(1.0,1.0));
			plot[4]->setP1(Point(0.0,gap)); plot[4]->setP2(Point(1.0,1.0));
			plot[5]->setP1(Point(0.0,gap)); plot[5]->setP2(Point(1.0-gap,1.0));
			plot[6]->setP1(Point(gap,0.0)); plot[6]->setP2(Point(1.0,1.0-gap));
			plot[7]->setP1(Point(0.0,0.0)); plot[7]->setP2(Point(1.0,1.0-gap));
			plot[8]->setP1(Point(0.0,0.0)); plot[8]->setP2(Point(1.0,1.0-gap));
			plot[9]->setP1(Point(0.0,0.0)); plot[9]->setP2(Point(1.0,1.0-gap));
			plot[10]->setP1(Point(0.0,0.0)); plot[10]->setP2(Point(1.0,1.0-gap));
		}
		else if(nrx == 4 && nry == 3) {	// 1|2|3|4 / 5|6|7|8 / |9|10|11|
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0,1.0));
			plot[2]->setP1(Point(0.0,gap)); plot[2]->setP2(Point(1.0,1.0));
			plot[3]->setP1(Point(0.0,gap)); plot[3]->setP2(Point(1.0-gap,1.0));
			plot[4]->setP1(Point(gap,0.0)); plot[4]->setP2(Point(1.0,1.0));
			plot[5]->setP1(Point(0.0,0.0)); plot[5]->setP2(Point(1.0,1.0));
			plot[6]->setP1(Point(0.0,0.0)); plot[6]->setP2(Point(1.0,1.0));
			plot[7]->setP1(Point(0.0,0.0)); plot[7]->setP2(Point(1.0-gap,1.0));
			plot[8]->setP1(Point(gap,0.0)); plot[8]->setP2(Point(1.0,1.0-gap));
			plot[9]->setP1(Point(0.0,0.0)); plot[9]->setP2(Point(1.0,1.0-gap));
			plot[10]->setP1(Point(0.0,0.0)); plot[10]->setP2(Point(1.0,1.0-gap));
		}
		else if(nrx == 3 && nry == 4) {	// 1|2|3 / 4|5|6 / 7|8|9 / 10|11|
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0,1.0));
			plot[2]->setP1(Point(0.0,gap)); plot[2]->setP2(Point(1.0-gap,1.0));
			plot[3]->setP1(Point(gap,0.0)); plot[3]->setP2(Point(1.0,1.0));
			plot[4]->setP1(Point(0.0,0.0)); plot[4]->setP2(Point(1.0,1.0));
			plot[5]->setP1(Point(0.0,0.0)); plot[5]->setP2(Point(1.0-gap,1.0));
			plot[6]->setP1(Point(gap,0.0)); plot[6]->setP2(Point(1.0,1.0));
			plot[7]->setP1(Point(0.0,0.0)); plot[7]->setP2(Point(1.0,1.0));
			plot[8]->setP1(Point(0.0,0.0)); plot[8]->setP2(Point(1.0-gap,1.0));
			plot[9]->setP1(Point(gap,0.0)); plot[9]->setP2(Point(1.0,1.0-gap));
			plot[10]->setP1(Point(0.0,0.0)); plot[10]->setP2(Point(1.0,1.0-gap));
		}
		else if(nrx == 2 && nry == 6) {	// 1|2 / 3|4 / 5|6 / 7|8 / 9|10 / 11|
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0-gap,1.0));
			plot[2]->setP1(Point(gap,0.0)); plot[2]->setP2(Point(1.0,1.0));
			plot[3]->setP1(Point(0.0,0.0)); plot[3]->setP2(Point(1.0-gap,1.0));
			plot[4]->setP1(Point(gap,0.0)); plot[4]->setP2(Point(1.0,1.0));
			plot[5]->setP1(Point(0.0,0.0)); plot[5]->setP2(Point(1.0-gap,1.0));
			plot[6]->setP1(Point(gap,0.0)); plot[6]->setP2(Point(1.0,1.0));
			plot[7]->setP1(Point(0.0,0.0)); plot[7]->setP2(Point(1.0-gap,1.0));
			plot[8]->setP1(Point(gap,0.0)); plot[8]->setP2(Point(1.0,1.0));
			plot[9]->setP1(Point(0.0,0.0)); plot[9]->setP2(Point(1.0-gap,1.0));
			plot[10]->setP1(Point(gap,0.0)); plot[10]->setP2(Point(1.0,1.0-gap));
		}
		break;
	case 12:
		if(nrx == 6 && nry == 2) {	// 1|2|3|4|5|6 / 7|8|9|10|11|12
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0,1.0));
			plot[2]->setP1(Point(0.0,gap)); plot[2]->setP2(Point(1.0,1.0));
			plot[3]->setP1(Point(0.0,gap)); plot[3]->setP2(Point(1.0,1.0));
			plot[4]->setP1(Point(0.0,gap)); plot[4]->setP2(Point(1.0,1.0));
			plot[5]->setP1(Point(0.0,gap)); plot[5]->setP2(Point(1.0-gap,1.0));
			plot[6]->setP1(Point(gap,0.0)); plot[6]->setP2(Point(1.0,1.0-gap));
			plot[7]->setP1(Point(0.0,0.0)); plot[7]->setP2(Point(1.0,1.0-gap));
			plot[8]->setP1(Point(0.0,0.0)); plot[8]->setP2(Point(1.0,1.0-gap));
			plot[9]->setP1(Point(0.0,0.0)); plot[9]->setP2(Point(1.0,1.0-gap));
			plot[10]->setP1(Point(0.0,0.0)); plot[10]->setP2(Point(1.0,1.0-gap));
			plot[11]->setP1(Point(0.0,0.0)); plot[11]->setP2(Point(1.0-gap,1.0-gap));
		}
		else if(nrx == 4 && nry == 3) {	// 1|2|3|4 / 5|6|7|8 / |9|10|11|12
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0,1.0));
			plot[2]->setP1(Point(0.0,gap)); plot[2]->setP2(Point(1.0,1.0));
			plot[3]->setP1(Point(0.0,gap)); plot[3]->setP2(Point(1.0-gap,1.0));
			plot[4]->setP1(Point(gap,0.0)); plot[4]->setP2(Point(1.0,1.0));
			plot[5]->setP1(Point(0.0,0.0)); plot[5]->setP2(Point(1.0,1.0));
			plot[6]->setP1(Point(0.0,0.0)); plot[6]->setP2(Point(1.0,1.0));
			plot[7]->setP1(Point(0.0,0.0)); plot[7]->setP2(Point(1.0-gap,1.0));
			plot[8]->setP1(Point(gap,0.0)); plot[8]->setP2(Point(1.0,1.0-gap));
			plot[9]->setP1(Point(0.0,0.0)); plot[9]->setP2(Point(1.0,1.0-gap));
			plot[10]->setP1(Point(0.0,0.0)); plot[10]->setP2(Point(1.0,1.0-gap));
			plot[11]->setP1(Point(0.0,0.0)); plot[11]->setP2(Point(1.0-gap,1.0-gap));
		}
		else if(nrx == 3 && nry == 4) {	// 1|2|3 / 4|5|6 / 7|8|9 / 10|11|12
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0,1.0));
			plot[2]->setP1(Point(0.0,gap)); plot[2]->setP2(Point(1.0-gap,1.0));
			plot[3]->setP1(Point(gap,0.0)); plot[3]->setP2(Point(1.0,1.0));
			plot[4]->setP1(Point(0.0,0.0)); plot[4]->setP2(Point(1.0,1.0));
			plot[5]->setP1(Point(0.0,0.0)); plot[5]->setP2(Point(1.0-gap,1.0));
			plot[6]->setP1(Point(gap,0.0)); plot[6]->setP2(Point(1.0,1.0));
			plot[7]->setP1(Point(0.0,0.0)); plot[7]->setP2(Point(1.0,1.0));
			plot[8]->setP1(Point(0.0,0.0)); plot[8]->setP2(Point(1.0-gap,1.0));
			plot[9]->setP1(Point(gap,0.0)); plot[9]->setP2(Point(1.0,1.0-gap));
			plot[10]->setP1(Point(0.0,0.0)); plot[10]->setP2(Point(1.0,1.0-gap));
			plot[11]->setP1(Point(0.0,0.0)); plot[11]->setP2(Point(1.0-gap,1.0-gap));
		}
		else if(nrx == 2 && nry == 6) {	// 1|2 / 3|4 / 5|6 / 7|8 / 9|10 / 11|12
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0-gap,1.0));
			plot[2]->setP1(Point(gap,0.0)); plot[2]->setP2(Point(1.0,1.0));
			plot[3]->setP1(Point(0.0,0.0)); plot[3]->setP2(Point(1.0-gap,1.0));
			plot[4]->setP1(Point(gap,0.0)); plot[4]->setP2(Point(1.0,1.0));
			plot[5]->setP1(Point(0.0,0.0)); plot[5]->setP2(Point(1.0-gap,1.0));
			plot[6]->setP1(Point(gap,0.0)); plot[6]->setP2(Point(1.0,1.0));
			plot[7]->setP1(Point(0.0,0.0)); plot[7]->setP2(Point(1.0-gap,1.0));
			plot[8]->setP1(Point(gap,0.0)); plot[8]->setP2(Point(1.0,1.0));
			plot[9]->setP1(Point(0.0,0.0)); plot[9]->setP2(Point(1.0-gap,1.0));
			plot[10]->setP1(Point(gap,0.0)); plot[10]->setP2(Point(1.0,1.0-gap));
			plot[11]->setP1(Point(0.0,0.0)); plot[11]->setP2(Point(1.0-gap,1.0-gap));
		}
		break;
	case 13:
		if(nrx == 7 && nry == 2) {	// 1|2|3|4|5|6|7 / 8|9|10|11|12|13|
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0,1.0));
			plot[2]->setP1(Point(0.0,gap)); plot[2]->setP2(Point(1.0,1.0));
			plot[3]->setP1(Point(0.0,gap)); plot[3]->setP2(Point(1.0,1.0));
			plot[4]->setP1(Point(0.0,gap)); plot[4]->setP2(Point(1.0,1.0));
			plot[5]->setP1(Point(0.0,gap)); plot[5]->setP2(Point(1.0,1.0));
			plot[6]->setP1(Point(0.0,gap)); plot[6]->setP2(Point(1.0-gap,1.0));
			plot[7]->setP1(Point(gap,0.0)); plot[7]->setP2(Point(1.0,1.0-gap));
			plot[8]->setP1(Point(0.0,0.0)); plot[8]->setP2(Point(1.0,1.0-gap));
			plot[9]->setP1(Point(0.0,0.0)); plot[9]->setP2(Point(1.0,1.0-gap));
			plot[10]->setP1(Point(0.0,0.0)); plot[10]->setP2(Point(1.0,1.0-gap));
			plot[11]->setP1(Point(0.0,0.0)); plot[11]->setP2(Point(1.0,1.0-gap));
			plot[12]->setP1(Point(0.0,0.0)); plot[12]->setP2(Point(1.0,1.0-gap));
		}
		else if(nrx == 5 && nry == 3) {	// 1|2|3|4|5 / 6|7|8|9|10 / 11|12|13||
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0,1.0));
			plot[2]->setP1(Point(0.0,gap)); plot[2]->setP2(Point(1.0,1.0));
			plot[3]->setP1(Point(0.0,gap)); plot[3]->setP2(Point(1.0,1.0));
			plot[4]->setP1(Point(0.0,gap)); plot[4]->setP2(Point(1.0-gap,1.0));
			plot[5]->setP1(Point(gap,0.0)); plot[5]->setP2(Point(1.0,1.0));
			plot[6]->setP1(Point(0.0,0.0)); plot[6]->setP2(Point(1.0,1.0));
			plot[7]->setP1(Point(0.0,0.0)); plot[7]->setP2(Point(1.0,1.0));
			plot[8]->setP1(Point(0.0,0.0)); plot[8]->setP2(Point(1.0,1.0));
			plot[9]->setP1(Point(0.0,0.0)); plot[9]->setP2(Point(1.0-gap,1.0));
			plot[10]->setP1(Point(gap,0.0)); plot[10]->setP2(Point(1.0,1.0-gap));
			plot[11]->setP1(Point(0.0,0.0)); plot[11]->setP2(Point(1.0,1.0-gap));
			plot[12]->setP1(Point(0.0,0.0)); plot[12]->setP2(Point(1.0,1.0-gap));
		}
		else if(nrx == 4 && nry == 4) {	// 1|2|3|4 / 5|6|7|8 / |9|10|11|12 / 13|||
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0,1.0));
			plot[2]->setP1(Point(0.0,gap)); plot[2]->setP2(Point(1.0,1.0));
			plot[3]->setP1(Point(0.0,gap)); plot[3]->setP2(Point(1.0-gap,1.0));
			plot[4]->setP1(Point(gap,0.0)); plot[4]->setP2(Point(1.0,1.0));
			plot[5]->setP1(Point(0.0,0.0)); plot[5]->setP2(Point(1.0,1.0));
			plot[6]->setP1(Point(0.0,0.0)); plot[6]->setP2(Point(1.0,1.0));
			plot[7]->setP1(Point(0.0,0.0)); plot[7]->setP2(Point(1.0-gap,1.0));
			plot[8]->setP1(Point(gap,0.0)); plot[8]->setP2(Point(1.0,1.0));
			plot[9]->setP1(Point(0.0,0.0)); plot[9]->setP2(Point(1.0,1.0));
			plot[10]->setP1(Point(0.0,0.0)); plot[10]->setP2(Point(1.0,1.0));
			plot[11]->setP1(Point(0.0,0.0)); plot[11]->setP2(Point(1.0-gap,1.0));
			plot[12]->setP1(Point(gap,0.0)); plot[12]->setP2(Point(1.0,1.0-gap));
		}
		else if(nrx == 3 && nry == 5) {	// 1|2|3 / 4|5|6 / 7|8|9 / 10|11|12 / 13||
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0,1.0));
			plot[2]->setP1(Point(0.0,gap)); plot[2]->setP2(Point(1.0-gap,1.0));
			plot[3]->setP1(Point(gap,0.0)); plot[3]->setP2(Point(1.0,1.0));
			plot[4]->setP1(Point(0.0,0.0)); plot[4]->setP2(Point(1.0,1.0));
			plot[5]->setP1(Point(0.0,0.0)); plot[5]->setP2(Point(1.0-gap,1.0));
			plot[6]->setP1(Point(gap,0.0)); plot[6]->setP2(Point(1.0,1.0));
			plot[7]->setP1(Point(0.0,0.0)); plot[7]->setP2(Point(1.0,1.0));
			plot[8]->setP1(Point(0.0,0.0)); plot[8]->setP2(Point(1.0-gap,1.0));
			plot[9]->setP1(Point(gap,0.0)); plot[9]->setP2(Point(1.0,1.0));
			plot[10]->setP1(Point(0.0,0.0)); plot[10]->setP2(Point(1.0,1.0));
			plot[11]->setP1(Point(0.0,0.0)); plot[11]->setP2(Point(1.0-gap,1.0));
			plot[12]->setP1(Point(gap,0.0)); plot[12]->setP2(Point(1.0,1.0-gap));
		}
		else if(nrx == 2 && nry == 7) {	// 1|2 / 3|4 / 5|6 / 7|8 / 9|10 / 11|12 / 13|
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0-gap,1.0));
			plot[2]->setP1(Point(gap,0.0)); plot[2]->setP2(Point(1.0,1.0));
			plot[3]->setP1(Point(0.0,0.0)); plot[3]->setP2(Point(1.0-gap,1.0));
			plot[4]->setP1(Point(gap,0.0)); plot[4]->setP2(Point(1.0,1.0));
			plot[5]->setP1(Point(0.0,0.0)); plot[5]->setP2(Point(1.0-gap,1.0));
			plot[6]->setP1(Point(gap,0.0)); plot[6]->setP2(Point(1.0,1.0));
			plot[7]->setP1(Point(0.0,0.0)); plot[7]->setP2(Point(1.0-gap,1.0));
			plot[8]->setP1(Point(gap,0.0)); plot[8]->setP2(Point(1.0,1.0));
			plot[9]->setP1(Point(0.0,0.0)); plot[9]->setP2(Point(1.0-gap,1.0));
			plot[10]->setP1(Point(gap,0.0)); plot[10]->setP2(Point(1.0,1.0));
			plot[11]->setP1(Point(0.0,0.0)); plot[11]->setP2(Point(1.0-gap,1.0));
			plot[12]->setP1(Point(gap,0.0)); plot[12]->setP2(Point(1.0,1.0-gap));
		}
		break;
	case 14:
		if(nrx == 7 && nry == 2) {	// 1|2|3|4|5|6|7 / 8|9|10|11|12|13|14
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0,1.0));
			plot[2]->setP1(Point(0.0,gap)); plot[2]->setP2(Point(1.0,1.0));
			plot[3]->setP1(Point(0.0,gap)); plot[3]->setP2(Point(1.0,1.0));
			plot[4]->setP1(Point(0.0,gap)); plot[4]->setP2(Point(1.0,1.0));
			plot[5]->setP1(Point(0.0,gap)); plot[5]->setP2(Point(1.0,1.0));
			plot[6]->setP1(Point(0.0,gap)); plot[6]->setP2(Point(1.0-gap,1.0));
			plot[7]->setP1(Point(gap,0.0)); plot[7]->setP2(Point(1.0,1.0-gap));
			plot[8]->setP1(Point(0.0,0.0)); plot[8]->setP2(Point(1.0,1.0-gap));
			plot[9]->setP1(Point(0.0,0.0)); plot[9]->setP2(Point(1.0,1.0-gap));
			plot[10]->setP1(Point(0.0,0.0)); plot[10]->setP2(Point(1.0,1.0-gap));
			plot[11]->setP1(Point(0.0,0.0)); plot[11]->setP2(Point(1.0,1.0-gap));
			plot[12]->setP1(Point(0.0,0.0)); plot[12]->setP2(Point(1.0,1.0-gap));
			plot[13]->setP1(Point(0.0,0.0)); plot[13]->setP2(Point(1.0-gap,1.0-gap));
		}
		else if(nrx == 5 && nry == 3) {	// 1|2|3|4|5 / 6|7|8|9|10 / 11|12|13|14|
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0,1.0));
			plot[2]->setP1(Point(0.0,gap)); plot[2]->setP2(Point(1.0,1.0));
			plot[3]->setP1(Point(0.0,gap)); plot[3]->setP2(Point(1.0,1.0));
			plot[4]->setP1(Point(0.0,gap)); plot[4]->setP2(Point(1.0-gap,1.0));
			plot[5]->setP1(Point(gap,0.0)); plot[5]->setP2(Point(1.0,1.0));
			plot[6]->setP1(Point(0.0,0.0)); plot[6]->setP2(Point(1.0,1.0));
			plot[7]->setP1(Point(0.0,0.0)); plot[7]->setP2(Point(1.0,1.0));
			plot[8]->setP1(Point(0.0,0.0)); plot[8]->setP2(Point(1.0,1.0));
			plot[9]->setP1(Point(0.0,0.0)); plot[9]->setP2(Point(1.0-gap,1.0));
			plot[10]->setP1(Point(gap,0.0)); plot[10]->setP2(Point(1.0,1.0-gap));
			plot[11]->setP1(Point(0.0,0.0)); plot[11]->setP2(Point(1.0,1.0-gap));
			plot[12]->setP1(Point(0.0,0.0)); plot[12]->setP2(Point(1.0,1.0-gap));
			plot[13]->setP1(Point(0.0,0.0)); plot[13]->setP2(Point(1.0,1.0-gap));
		}
		else if(nrx == 4 && nry == 4) {	// 1|2|3|4 / 5|6|7|8 / |9|10|11|12 / 13|14||
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0,1.0));
			plot[2]->setP1(Point(0.0,gap)); plot[2]->setP2(Point(1.0,1.0));
			plot[3]->setP1(Point(0.0,gap)); plot[3]->setP2(Point(1.0-gap,1.0));
			plot[4]->setP1(Point(gap,0.0)); plot[4]->setP2(Point(1.0,1.0));
			plot[5]->setP1(Point(0.0,0.0)); plot[5]->setP2(Point(1.0,1.0));
			plot[6]->setP1(Point(0.0,0.0)); plot[6]->setP2(Point(1.0,1.0));
			plot[7]->setP1(Point(0.0,0.0)); plot[7]->setP2(Point(1.0-gap,1.0));
			plot[8]->setP1(Point(gap,0.0)); plot[8]->setP2(Point(1.0,1.0));
			plot[9]->setP1(Point(0.0,0.0)); plot[9]->setP2(Point(1.0,1.0));
			plot[10]->setP1(Point(0.0,0.0)); plot[10]->setP2(Point(1.0,1.0));
			plot[11]->setP1(Point(0.0,0.0)); plot[11]->setP2(Point(1.0-gap,1.0));
			plot[12]->setP1(Point(gap,0.0)); plot[12]->setP2(Point(1.0,1.0-gap));
			plot[13]->setP1(Point(0.0,0.0)); plot[13]->setP2(Point(1.0,1.0-gap));
		}
		else if(nrx == 3 && nry == 5) {	// 1|2|3 / 4|5|6 / 7|8|9 / 10|11|12 / 13|14|
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0,1.0));
			plot[2]->setP1(Point(0.0,gap)); plot[2]->setP2(Point(1.0-gap,1.0));
			plot[3]->setP1(Point(gap,0.0)); plot[3]->setP2(Point(1.0,1.0));
			plot[4]->setP1(Point(0.0,0.0)); plot[4]->setP2(Point(1.0,1.0));
			plot[5]->setP1(Point(0.0,0.0)); plot[5]->setP2(Point(1.0-gap,1.0));
			plot[6]->setP1(Point(gap,0.0)); plot[6]->setP2(Point(1.0,1.0));
			plot[7]->setP1(Point(0.0,0.0)); plot[7]->setP2(Point(1.0,1.0));
			plot[8]->setP1(Point(0.0,0.0)); plot[8]->setP2(Point(1.0-gap,1.0));
			plot[9]->setP1(Point(gap,0.0)); plot[9]->setP2(Point(1.0,1.0));
			plot[10]->setP1(Point(0.0,0.0)); plot[10]->setP2(Point(1.0,1.0));
			plot[11]->setP1(Point(0.0,0.0)); plot[11]->setP2(Point(1.0-gap,1.0));
			plot[12]->setP1(Point(gap,0.0)); plot[12]->setP2(Point(1.0,1.0-gap));
			plot[13]->setP1(Point(0.0,0.0)); plot[13]->setP2(Point(1.0,1.0-gap));
		}
		else if(nrx == 2 && nry == 7) {	// 1|2 / 3|4 / 5|6 / 7|8 / 9|10 / 11|12 / 13|14
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0-gap,1.0));
			plot[2]->setP1(Point(gap,0.0)); plot[2]->setP2(Point(1.0,1.0));
			plot[3]->setP1(Point(0.0,0.0)); plot[3]->setP2(Point(1.0-gap,1.0));
			plot[4]->setP1(Point(gap,0.0)); plot[4]->setP2(Point(1.0,1.0));
			plot[5]->setP1(Point(0.0,0.0)); plot[5]->setP2(Point(1.0-gap,1.0));
			plot[6]->setP1(Point(gap,0.0)); plot[6]->setP2(Point(1.0,1.0));
			plot[7]->setP1(Point(0.0,0.0)); plot[7]->setP2(Point(1.0-gap,1.0));
			plot[8]->setP1(Point(gap,0.0)); plot[8]->setP2(Point(1.0,1.0));
			plot[9]->setP1(Point(0.0,0.0)); plot[9]->setP2(Point(1.0-gap,1.0));
			plot[10]->setP1(Point(gap,0.0)); plot[10]->setP2(Point(1.0,1.0));
			plot[11]->setP1(Point(0.0,0.0)); plot[11]->setP2(Point(1.0-gap,1.0));
			plot[12]->setP1(Point(gap,0.0)); plot[12]->setP2(Point(1.0,1.0-gap));
			plot[13]->setP1(Point(0.0,0.0)); plot[13]->setP2(Point(1.0-gap,1.0-gap));
		}
		break;
	case 15:
		if(nrx == 8 && nry == 2) {	// 1|2|3|4|5|6|7|8 / 9|10|11|12|13|14|15|
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0,1.0));
			plot[2]->setP1(Point(0.0,gap)); plot[2]->setP2(Point(1.0,1.0));
			plot[3]->setP1(Point(0.0,gap)); plot[3]->setP2(Point(1.0,1.0));
			plot[4]->setP1(Point(0.0,gap)); plot[4]->setP2(Point(1.0,1.0));
			plot[5]->setP1(Point(0.0,gap)); plot[5]->setP2(Point(1.0,1.0));
			plot[6]->setP1(Point(0.0,gap)); plot[6]->setP2(Point(1.0,1.0));
			plot[7]->setP1(Point(0.0,gap)); plot[7]->setP2(Point(1.0-gap,1.0));
			plot[8]->setP1(Point(gap,0.0)); plot[8]->setP2(Point(1.0,1.0-gap));
			plot[9]->setP1(Point(0.0,0.0)); plot[9]->setP2(Point(1.0,1.0-gap));
			plot[10]->setP1(Point(0.0,0.0)); plot[10]->setP2(Point(1.0,1.0-gap));
			plot[11]->setP1(Point(0.0,0.0)); plot[11]->setP2(Point(1.0,1.0-gap));
			plot[12]->setP1(Point(0.0,0.0)); plot[12]->setP2(Point(1.0,1.0-gap));
			plot[13]->setP1(Point(0.0,0.0)); plot[13]->setP2(Point(1.0,1.0-gap));
			plot[14]->setP1(Point(0.0,0.0)); plot[14]->setP2(Point(1.0,1.0-gap));
		}
		else if(nrx == 5 && nry == 3) {	// 1|2|3|4|5 / 6|7|8|9|10 / 11|12|13|14|15
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0,1.0));
			plot[2]->setP1(Point(0.0,gap)); plot[2]->setP2(Point(1.0,1.0));
			plot[3]->setP1(Point(0.0,gap)); plot[3]->setP2(Point(1.0,1.0));
			plot[4]->setP1(Point(0.0,gap)); plot[4]->setP2(Point(1.0-gap,1.0));
			plot[5]->setP1(Point(gap,0.0)); plot[5]->setP2(Point(1.0,1.0));
			plot[6]->setP1(Point(0.0,0.0)); plot[6]->setP2(Point(1.0,1.0));
			plot[7]->setP1(Point(0.0,0.0)); plot[7]->setP2(Point(1.0,1.0));
			plot[8]->setP1(Point(0.0,0.0)); plot[8]->setP2(Point(1.0,1.0));
			plot[9]->setP1(Point(0.0,0.0)); plot[9]->setP2(Point(1.0-gap,1.0));
			plot[10]->setP1(Point(gap,0.0)); plot[10]->setP2(Point(1.0,1.0-gap));
			plot[11]->setP1(Point(0.0,0.0)); plot[11]->setP2(Point(1.0,1.0-gap));
			plot[12]->setP1(Point(0.0,0.0)); plot[12]->setP2(Point(1.0,1.0-gap));
			plot[13]->setP1(Point(0.0,0.0)); plot[13]->setP2(Point(1.0,1.0-gap));
			plot[14]->setP1(Point(0.0,0.0)); plot[14]->setP2(Point(1.0-gap,1.0-gap));
		}
		else if(nrx == 4 && nry == 4) {	// 1|2|3|4 / 5|6|7|8 / |9|10|11|12 / 13|14|15|
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0,1.0));
			plot[2]->setP1(Point(0.0,gap)); plot[2]->setP2(Point(1.0,1.0));
			plot[3]->setP1(Point(0.0,gap)); plot[3]->setP2(Point(1.0-gap,1.0));
			plot[4]->setP1(Point(gap,0.0)); plot[4]->setP2(Point(1.0,1.0));
			plot[5]->setP1(Point(0.0,0.0)); plot[5]->setP2(Point(1.0,1.0));
			plot[6]->setP1(Point(0.0,0.0)); plot[6]->setP2(Point(1.0,1.0));
			plot[7]->setP1(Point(0.0,0.0)); plot[7]->setP2(Point(1.0-gap,1.0));
			plot[8]->setP1(Point(gap,0.0)); plot[8]->setP2(Point(1.0,1.0));
			plot[9]->setP1(Point(0.0,0.0)); plot[9]->setP2(Point(1.0,1.0));
			plot[10]->setP1(Point(0.0,0.0)); plot[10]->setP2(Point(1.0,1.0));
			plot[11]->setP1(Point(0.0,0.0)); plot[11]->setP2(Point(1.0-gap,1.0));
			plot[12]->setP1(Point(gap,0.0)); plot[12]->setP2(Point(1.0,1.0-gap));
			plot[13]->setP1(Point(0.0,0.0)); plot[13]->setP2(Point(1.0,1.0-gap));
			plot[14]->setP1(Point(0.0,0.0)); plot[14]->setP2(Point(1.0,1.0-gap));
		}
		else if(nrx == 3 && nry == 5) {	// 1|2|3 / 4|5|6 / 7|8|9 / 10|11|12 / 13|14|15
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0,1.0));
			plot[2]->setP1(Point(0.0,gap)); plot[2]->setP2(Point(1.0-gap,1.0));
			plot[3]->setP1(Point(gap,0.0)); plot[3]->setP2(Point(1.0,1.0));
			plot[4]->setP1(Point(0.0,0.0)); plot[4]->setP2(Point(1.0,1.0));
			plot[5]->setP1(Point(0.0,0.0)); plot[5]->setP2(Point(1.0-gap,1.0));
			plot[6]->setP1(Point(gap,0.0)); plot[6]->setP2(Point(1.0,1.0));
			plot[7]->setP1(Point(0.0,0.0)); plot[7]->setP2(Point(1.0,1.0));
			plot[8]->setP1(Point(0.0,0.0)); plot[8]->setP2(Point(1.0-gap,1.0));
			plot[9]->setP1(Point(gap,0.0)); plot[9]->setP2(Point(1.0,1.0));
			plot[10]->setP1(Point(0.0,0.0)); plot[10]->setP2(Point(1.0,1.0));
			plot[11]->setP1(Point(0.0,0.0)); plot[11]->setP2(Point(1.0-gap,1.0));
			plot[12]->setP1(Point(gap,0.0)); plot[12]->setP2(Point(1.0,1.0-gap));
			plot[13]->setP1(Point(0.0,0.0)); plot[13]->setP2(Point(1.0,1.0-gap));
			plot[14]->setP1(Point(0.0,0.0)); plot[14]->setP2(Point(1.0-gap,1.0-gap));
		}
		else if(nrx == 2 && nry == 8) {	// 1|2 / 3|4 / 5|6 / 7|8 / 9|10 / 11|12 / 13|14 / 15|
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0-gap,1.0));
			plot[2]->setP1(Point(gap,0.0)); plot[2]->setP2(Point(1.0,1.0));
			plot[3]->setP1(Point(0.0,0.0)); plot[3]->setP2(Point(1.0-gap,1.0));
			plot[4]->setP1(Point(gap,0.0)); plot[4]->setP2(Point(1.0,1.0));
			plot[5]->setP1(Point(0.0,0.0)); plot[5]->setP2(Point(1.0-gap,1.0));
			plot[6]->setP1(Point(gap,0.0)); plot[6]->setP2(Point(1.0,1.0));
			plot[7]->setP1(Point(0.0,0.0)); plot[7]->setP2(Point(1.0-gap,1.0));
			plot[8]->setP1(Point(gap,0.0)); plot[8]->setP2(Point(1.0,1.0));
			plot[9]->setP1(Point(0.0,0.0)); plot[9]->setP2(Point(1.0-gap,1.0));
			plot[10]->setP1(Point(gap,0.0)); plot[10]->setP2(Point(1.0,1.0));
			plot[11]->setP1(Point(0.0,0.0)); plot[11]->setP2(Point(1.0-gap,1.0));
			plot[12]->setP1(Point(gap,0.0)); plot[12]->setP2(Point(1.0,1.0));
			plot[13]->setP1(Point(0.0,0.0)); plot[13]->setP2(Point(1.0,1.0));
			plot[14]->setP1(Point(gap,0.0)); plot[14]->setP2(Point(1.0,1.0-gap));
		}
		break;
	case 16:
		if(nrx == 8 && nry == 2) {	// 1|2|3|4|5|6|7|8 / 9|10|11|12|13|14|15|16
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0,1.0));
			plot[2]->setP1(Point(0.0,gap)); plot[2]->setP2(Point(1.0,1.0));
			plot[3]->setP1(Point(0.0,gap)); plot[3]->setP2(Point(1.0,1.0));
			plot[4]->setP1(Point(0.0,gap)); plot[4]->setP2(Point(1.0,1.0));
			plot[5]->setP1(Point(0.0,gap)); plot[5]->setP2(Point(1.0,1.0));
			plot[6]->setP1(Point(0.0,gap)); plot[6]->setP2(Point(1.0,1.0));
			plot[7]->setP1(Point(0.0,gap)); plot[7]->setP2(Point(1.0-gap,1.0));
			plot[8]->setP1(Point(gap,0.0)); plot[8]->setP2(Point(1.0,1.0-gap));
			plot[9]->setP1(Point(0.0,0.0)); plot[9]->setP2(Point(1.0,1.0-gap));
			plot[10]->setP1(Point(0.0,0.0)); plot[10]->setP2(Point(1.0,1.0-gap));
			plot[11]->setP1(Point(0.0,0.0)); plot[11]->setP2(Point(1.0,1.0-gap));
			plot[12]->setP1(Point(0.0,0.0)); plot[12]->setP2(Point(1.0,1.0-gap));
			plot[13]->setP1(Point(0.0,0.0)); plot[13]->setP2(Point(1.0,1.0-gap));
			plot[14]->setP1(Point(0.0,0.0)); plot[14]->setP2(Point(1.0,1.0-gap));
			plot[15]->setP1(Point(0.0,0.0)); plot[15]->setP2(Point(1.0-gap,1.0-gap));
		}
		if(nrx == 6 && nry == 3) {	// 1|2|3|4|5|6 / 7|8|9|10|11|12 / 13|14|15|16||
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0,1.0));
			plot[2]->setP1(Point(0.0,gap)); plot[2]->setP2(Point(1.0,1.0));
			plot[3]->setP1(Point(0.0,gap)); plot[3]->setP2(Point(1.0,1.0));
			plot[4]->setP1(Point(0.0,gap)); plot[4]->setP2(Point(1.0,1.0));
			plot[5]->setP1(Point(0.0,gap)); plot[5]->setP2(Point(1.0-gap,1.0));
			plot[6]->setP1(Point(gap,0.0)); plot[6]->setP2(Point(1.0,1.0));
			plot[7]->setP1(Point(0.0,0.0)); plot[7]->setP2(Point(1.0,1.0));
			plot[8]->setP1(Point(0.0,0.0)); plot[8]->setP2(Point(1.0,1.0));
			plot[9]->setP1(Point(0.0,0.0)); plot[9]->setP2(Point(1.0,1.0));
			plot[10]->setP1(Point(0.0,0.0)); plot[10]->setP2(Point(1.0,1.0));
			plot[11]->setP1(Point(0.0,0.0)); plot[11]->setP2(Point(1.0-gap,1.0));
			plot[12]->setP1(Point(gap,0.0)); plot[12]->setP2(Point(1.0,1.0-gap));
			plot[13]->setP1(Point(0.0,0.0)); plot[13]->setP2(Point(1.0,1.0-gap));
			plot[14]->setP1(Point(0.0,0.0)); plot[14]->setP2(Point(1.0,1.0-gap));
			plot[15]->setP1(Point(0.0,0.0)); plot[15]->setP2(Point(1.0-gap,1.0-gap));
		}
		else if(nrx == 4 && nry == 4) {	// 1|2|3|4 / 5|6|7|8 / |9|10|11|12 / 13|14|15|16
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0,1.0));
			plot[2]->setP1(Point(0.0,gap)); plot[2]->setP2(Point(1.0,1.0));
			plot[3]->setP1(Point(0.0,gap)); plot[3]->setP2(Point(1.0-gap,1.0));
			plot[4]->setP1(Point(gap,0.0)); plot[4]->setP2(Point(1.0,1.0));
			plot[5]->setP1(Point(0.0,0.0)); plot[5]->setP2(Point(1.0,1.0));
			plot[6]->setP1(Point(0.0,0.0)); plot[6]->setP2(Point(1.0,1.0));
			plot[7]->setP1(Point(0.0,0.0)); plot[7]->setP2(Point(1.0-gap,1.0));
			plot[8]->setP1(Point(gap,0.0)); plot[8]->setP2(Point(1.0,1.0));
			plot[9]->setP1(Point(0.0,0.0)); plot[9]->setP2(Point(1.0,1.0));
			plot[10]->setP1(Point(0.0,0.0)); plot[10]->setP2(Point(1.0,1.0));
			plot[11]->setP1(Point(0.0,0.0)); plot[11]->setP2(Point(1.0-gap,1.0));
			plot[12]->setP1(Point(gap,0.0)); plot[12]->setP2(Point(1.0,1.0-gap));
			plot[13]->setP1(Point(0.0,0.0)); plot[13]->setP2(Point(1.0,1.0-gap));
			plot[14]->setP1(Point(0.0,0.0)); plot[14]->setP2(Point(1.0,1.0-gap));
			plot[15]->setP1(Point(0.0,0.0)); plot[15]->setP2(Point(1.0-gap,1.0-gap));
		}
		else if(nrx == 3 && nry == 6) {	// 1|2|3 / 4|5|6 / 7|8|9 / 10|11|12 / 13|14|15 / 16||
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0,1.0));
			plot[2]->setP1(Point(0.0,gap)); plot[2]->setP2(Point(1.0-gap,1.0));
			plot[3]->setP1(Point(gap,0.0)); plot[3]->setP2(Point(1.0,1.0));
			plot[4]->setP1(Point(0.0,0.0)); plot[4]->setP2(Point(1.0,1.0));
			plot[5]->setP1(Point(0.0,0.0)); plot[5]->setP2(Point(1.0-gap,1.0));
			plot[6]->setP1(Point(gap,0.0)); plot[6]->setP2(Point(1.0,1.0));
			plot[7]->setP1(Point(0.0,0.0)); plot[7]->setP2(Point(1.0,1.0));
			plot[8]->setP1(Point(0.0,0.0)); plot[8]->setP2(Point(1.0-gap,1.0));
			plot[9]->setP1(Point(gap,0.0)); plot[9]->setP2(Point(1.0,1.0));
			plot[10]->setP1(Point(0.0,0.0)); plot[10]->setP2(Point(1.0,1.0));
			plot[11]->setP1(Point(0.0,0.0)); plot[11]->setP2(Point(1.0-gap,1.0));
			plot[12]->setP1(Point(gap,0.0)); plot[12]->setP2(Point(1.0,1.0));
			plot[13]->setP1(Point(0.0,0.0)); plot[13]->setP2(Point(1.0,1.0));
			plot[14]->setP1(Point(0.0,0.0)); plot[14]->setP2(Point(1.0-gap,1.0));
			plot[15]->setP1(Point(gap,0.0)); plot[15]->setP2(Point(1.0,1.0-gap));
		}
		else if(nrx == 2 && nry == 8) {	// 1|2 / 3|4 / 5|6 / 7|8 / 9|10 / 11|12 / 13|14 / 15|16
			plot[0]->setP1(Point(gap,gap)); plot[0]->setP2(Point(1.0,1.0));
			plot[1]->setP1(Point(0.0,gap)); plot[1]->setP2(Point(1.0-gap,1.0));
			plot[2]->setP1(Point(gap,0.0)); plot[2]->setP2(Point(1.0,1.0));
			plot[3]->setP1(Point(0.0,0.0)); plot[3]->setP2(Point(1.0-gap,1.0));
			plot[4]->setP1(Point(gap,0.0)); plot[4]->setP2(Point(1.0,1.0));
			plot[5]->setP1(Point(0.0,0.0)); plot[5]->setP2(Point(1.0-gap,1.0));
			plot[6]->setP1(Point(gap,0.0)); plot[6]->setP2(Point(1.0,1.0));
			plot[7]->setP1(Point(0.0,0.0)); plot[7]->setP2(Point(1.0-gap,1.0));
			plot[8]->setP1(Point(gap,0.0)); plot[8]->setP2(Point(1.0,1.0));
			plot[9]->setP1(Point(0.0,0.0)); plot[9]->setP2(Point(1.0-gap,1.0));
			plot[10]->setP1(Point(gap,0.0)); plot[10]->setP2(Point(1.0,1.0));
			plot[11]->setP1(Point(0.0,0.0)); plot[11]->setP2(Point(1.0-gap,1.0));
			plot[12]->setP1(Point(gap,0.0)); plot[12]->setP2(Point(1.0,1.0));
			plot[13]->setP1(Point(0.0,0.0)); plot[13]->setP2(Point(1.0,1.0));
			plot[14]->setP1(Point(gap,0.0)); plot[14]->setP2(Point(1.0,1.0-gap));
			plot[15]->setP1(Point(0.0,0.0)); plot[15]->setP2(Point(1.0-gap,1.0-gap));
		}
		break;
	default : break;
	}
}

void ArrangePlotDialog::apply_clicked() {
	unsigned int nr = p->NrPlots();
	int nrx = xni->value();
	int nry = yni->value();
	double gap = gaple->text().toDouble();

	bool pan = panel->isChecked();
	if(pan) {
		applyPanel(nrx,nry,gap);
		gap=0;	// no plot gap
	}

	// arrange plots
	double sizex = (1.0-(nrx+1)*gap)/nrx;
	double sizey = (1.0-(nry+1)*gap)/nry;
	kdDebug()<<" SIZE : "<<sizex<<' '<<sizey<<endl;
	double posx,posy;
	for (unsigned int i = 0; i < nr; i++) {
		posx = ((i % nrx)+1) * gap+(i%nrx)*sizex;
		posy = (i/nrx+1) * gap+(i/nrx)*sizey;

		// panel plot need adapted size&position
		if(pan) {
			double dx,dy;
			gap = gaple->text().toDouble();	// use gap again
			switch(nr) {
			case 5:
				if(nrx == 3 && nry == 2) {
					dx=1./3.;
					switch(i){
					case 0: sizex=dx+gap/9.; posx=0; break;
					case 1: sizex=dx-2./9.*gap; posx=dx+gap/9.; break;
					case 2: sizex=dx+gap/9.; posx=2*dx-gap/9.; break;
					case 3: sizex=dx+gap/9.; posx=0; break;
					case 4: sizex=dx-2./9.*gap; posx=dx+gap/9.; break;
					}
				}
				else if (nrx == 2 && nry == 3) {
					dy = 1./3.;
					switch(i){
					case 0: sizey=dy+gap/9.; posy=0; break;
					case 1: sizey=dy+gap/9.; posy=0; break;
					case 2: sizey=dy-2./9.*gap; posy=dy+gap/9.; break;
					case 3: sizey=dy-2./9.*gap; posy=dy+gap/9.; break;
					case 4: sizey=dy+gap/9.; posy=2*dy-gap/9.; break;
					}
				}
				break;
			case 6:
				if(nrx == 3 && nry == 2) {
					dx=1./3.;
					switch(i){
					case 0: sizex=dx+gap/9.; posx=0; break;
					case 1: sizex=dx-2./9.*gap; posx=dx+gap/9.; break;
					case 2: sizex=dx+gap/9.; posx=2*dx-gap/9.; break;
					case 3: sizex=dx+gap/9.; posx=0; break;
					case 4: sizex=dx-2./9.*gap; posx=dx+gap/9.; break;
					case 5: sizex=dx+gap/9.; posx=2*dx-gap/9.; break;
					}
				}
				else if (nrx == 2 && nry == 3) {
					dy = 1./3.;
					switch(i){
					case 0: sizey=dy+gap/9.; posy=0; break;
					case 1: sizey=dy+gap/9.; posy=0; break;
					case 2: sizey=dy-2./9.*gap; posy=dy+gap/9.; break;
					case 3: sizey=dy-2./9.*gap; posy=dy+gap/9.; break;
					case 4: sizey=dy+gap/9.; posy=2*dy-gap/9.; break;
					case 5: sizey=dy+gap/9.; posy=2*dy-gap/9.; break;
					}
				}
				break;
			case 7:
				if(nrx == 4 && nry == 2) {
					dx=1./4.;
					switch(i){
					case 0: sizex=dx+gap/8.; posx=0; break;
					case 1: sizex=dx-gap/8.; posx=dx+gap/8.; break;
					case 2: sizex=dx-gap/8.; posx=2*dx; break;
					case 3: sizex=dx+gap/8.; posx=3*dx-gap/8.; break;
					case 4: sizex=dx+gap/8.; posx=0; break;
					case 5: sizex=dx-gap/8.; posx=dx+gap/8.; break;
					case 6: sizex=dx-gap/8.; posx=2*dx; break;
					}
				}
				else if (nrx == 3 && nry == 3) {
					dx=dy=1./3.;
					switch(i){
					case 0: sizex=dx+gap/9.;sizey=dy+gap/9.; posx=posy=0; break;
					case 1: sizex=dx-2./9.*gap;sizey=dy+gap/9.; posx=dx+gap/9.; posy=0; break;
					case 2: sizex=dx+gap/9.;sizey=dy+gap/9.; posx=2*dx-gap/9.;posy=0; break;
					case 3: sizex=dx+gap/9.;sizey=dy-2./9.*gap; posx=0; posy=dy+gap/9.; break;
					case 4: sizex=dx-2./9.*gap;sizey=dy-2./9.*gap; posx=posy=dy+gap/9.; break;
					case 5: sizex=dx+gap/9.;sizey=dy-2./9.*gap; posx=2*dx-gap/9.;posy=dy+gap/9.; break;
					case 6: sizex=dx+gap/9.;sizey=dy+gap/9.; posx=0; posy=2*dy-gap/9.; break;
					}
				}
				else if (nrx == 2 && nry == 4) {
					dy=1./4.;
					switch(i){
					case 0: sizey=dy+gap/8.; posy=0; break;
					case 1: sizey=dy+gap/8.; posy=0; break;
					case 2: sizey=dy-gap/8.; posy=dy+gap/8.; break;
					case 3: sizey=dy-gap/8.; posy=dy+gap/8.; break;
					case 4: sizey=dy-gap/8.; posy=2*dy; break;
					case 5: sizey=dy-gap/8.; posy=2*dy; break;
					case 6: sizey=dy+gap/8.; posy=3*dy-gap/8.; break;
					}
				}
				break;
			case 8:
				if(nrx == 4 && nry == 2) {
					dx=1./4.;
					switch(i){
					case 0: sizex=dx+gap/8.; posx=0; break;
					case 1: sizex=dx-gap/8.; posx=dx+gap/8.; break;
					case 2: sizex=dx-gap/8.; posx=2*dx; break;
					case 3: sizex=dx+gap/8.; posx=3*dx-gap/8.; break;
					case 4: sizex=dx+gap/8.; posx=0; break;
					case 5: sizex=dx-gap/8.; posx=dx+gap/8.; break;
					case 6: sizex=dx-gap/8.; posx=2*dx; break;
					case 7: sizex=dx+gap/8.; posx=3*dx-gap/8.; break;
					}
				}
				else if (nrx == 3 && nry == 3) {
					dx=dy=1./3.;
					switch(i){
					case 0: sizex=dx+gap/9.;sizey=dy+gap/9.; posx=posy=0; break;
					case 1: sizex=dx-2./9.*gap;sizey=dy+gap/9.; posx=dx+gap/9.; posy=0; break;
					case 2: sizex=dx+gap/9.;sizey=dy+gap/9.; posx=2*dx-gap/9.;posy=0; break;
					case 3: sizex=dx+gap/9.;sizey=dy-2./9.*gap; posx=0; posy=dy+gap/9.; break;
					case 4: sizex=dx-2./9.*gap;sizey=dy-2./9.*gap; posx=posy=dy+gap/9.; break;
					case 5: sizex=dx+gap/9.;sizey=dy-2./9.*gap; posx=2*dx-gap/9.;posy=dy+gap/9.; break;
					case 6: sizex=dx+gap/9.;sizey=dy+gap/9.; posx=0; posy=2*dy-gap/9.; break;
					case 7: sizex=dx-2./9.*gap;sizey=dy+gap/9.; posx=dx+gap/9.; posy=2*dy-gap/9.; break;
					}
				}
				else if (nrx == 2 && nry == 4) {
					dy=1./4.;
					switch(i){
					case 0: sizey=dy+gap/8.; posy=0; break;
					case 1: sizey=dy+gap/8.; posy=0; break;
					case 2: sizey=dy-gap/8.; posy=dy+gap/8.; break;
					case 3: sizey=dy-gap/8.; posy=dy+gap/8.; break;
					case 4: sizey=dy-gap/8.; posy=2*dy; break;
					case 5: sizey=dy-gap/8.; posy=2*dy; break;
					case 6: sizey=dy+gap/8.; posy=3*dy-gap/8.; break;
					case 7: sizey=dy+gap/8.; posy=3*dy-gap/8.; break;
					}
				}
				break;
			case 9:
				if(nrx == 5 && nry == 2) {
					//TODO 
				}
				else if (nrx == 4 && nry == 3) {
					// TODO
				}
				else if(nrx == 3 && nry == 3) {
					dx=dy=1./3.;
					switch(i){
					case 0: sizex=dx+gap/9.;sizey=dy+gap/9.; posx=posy=0; break;
					case 1: sizex=dx-2./9.*gap;sizey=dy+gap/9.; posx=dx+gap/9.; posy=0; break;
					case 2: sizex=dx+gap/9.;sizey=dy+gap/9.; posx=2*dx-gap/9.;posy=0; break;
					case 3: sizex=dx+gap/9.;sizey=dy-2./9.*gap; posx=0; posy=dy+gap/9.; break;
					case 4: sizex=dx-2./9.*gap;sizey=dy-2./9.*gap; posx=posy=dy+gap/9.; break;
					case 5: sizex=dx+gap/9.;sizey=dy-2./9.*gap; posx=2*dx-gap/9.;posy=dy+gap/9.; break;
					case 6: sizex=dx+gap/9.;sizey=dy+gap/9.; posx=0; posy=2*dy-gap/9.; break;
					case 7: sizex=dx-2./9.*gap;sizey=dy+gap/9.; posx=dx+gap/9.; posy=2*dy-gap/9.; break;
					case 8: sizex=dx+gap/9.;sizey=dy+gap/9.; posx=2*dx-gap/9.;posy=2*dy-gap/9.; break;
					}
				}
				else if (nrx == 2 && nry == 5) {
					// TODO
				}
				break;
			case 10:
				//TODO 
				break;
			case 11:
				//TODO 
				break;
			case 12:
				//TODO 
				break;
			case 13:
				//TODO 
				break;
			case 14:
				//TODO 
				break;
			case 15:
				//TODO 
				break;
			case 16:
				if(nrx == 4 && nry == 4) {
					dx=dy=1./4.;
					switch(i){
					case 0: sizex=dx+gap/16.;sizey=dy+gap/16.; posx=posy=0; break;
					case 1: sizex=dx-gap/16.;sizey=dy+gap/16.; posx=dx+gap/16.; posy=0; break;
					case 2: sizex=dx-gap/16.;sizey=dy+gap/16.; posx=2*dx; posy=0; break;
					case 3: sizex=dx+gap/16.;sizey=dy+gap/16.; posx=3*dx-gap/16.;posy=0; break;
					
					case 4: sizex=dx+gap/16.;sizey=dy-gap/16.; posx=0; posy=dy+gap/16.; break;
					case 5: sizex=dx-gap/16.;sizey=dy-gap/16.; posx=posy=dy+gap/16.; break;
					case 6: sizex=dx-gap/16.;sizey=dy-gap/16.; posx=2*dx; posy=dy+gap/16.; break;
					case 7: sizex=dx+gap/6.;sizey=dy-gap/16.; posx=3*dx-gap/16.;posy=dy+gap/16.; break;
					
					case 8: sizex=dx+gap/16.;sizey=dy-gap/16.; posx=0; posy=2*dy; break;
					case 9: sizex=dx-gap/16.;sizey=dy-gap/16.; posx=dx+gap/16.; posy=2*dy; break;
					case 10: sizex=dx-gap/16.;sizey=dy-gap/16.; posx=2*dx; posy=2*dy; break;
					case 11: sizex=dx+gap/6.;sizey=dy-gap/16.; posx=3*dx-gap/16.;posy=2*dy; break;
					
					case 12: sizex=dx+gap/16.;sizey=dy+gap/16.; posx=0; posy=3*dy-gap/16.; break;
					case 13: sizex=dx-gap/16.;sizey=dy+gap/16.; posx=dx+gap/16.; posy=3*dy-gap/16.; break;
					case 14: sizex=dx-gap/16.;sizey=dy+gap/16.; posx=2*dx; posy=3*dy-gap/16.; break;
					case 15: sizex=dx+gap/6.;sizey=dy+gap/16.; posx=3*dx-gap/16.;posy=3*dy-gap/16.; break;
					}
				}
				//TODO 
				break;
			default:break;
			}
			gap=0;
		}

		p->getPlot(i)->setPosition(posx,posy);
		p->getPlot(i)->setSize(sizex,sizey);
		kdDebug()<<" POS : "<<posx<<' '<<posy<<endl;
	}
	
	p->updatePixmap();
	mw->updatePlotSettingsDialog();

	updateList();
}
