%define version 1.5.1.pre5

Name: 		LabPlot
URL:		http://labplot.sourceforge.net/
Version:	%{version}
Summary:	Function and Data Plotter
Release:	1
Source:		LabPlot-%{version}.tar.gz
Group:		Applications/Engineering	
Copyright:	GPL
Packager:	Stefan Gerlach <gerlach@mbi-berlin.de>
Distribution:	Enterprise Linux 4
Vendor:		http://labplot.sourceforge.net/
BuildPrereq:	gsl-devel >= 1.6 , ImageMagick-c++-devel, audiofile-devel, fftw-devel, jasper-devel, pstoedit, ocaml, fftw3-devel
Requires:	ImageMagick >= 6.0.7.1 , ImageMagick-c++ >= 6.0.7.1 , gsl >= 1.6 , audiofile, fftw, jasper, pstoedit, ocaml, fftw3
BuildRoot:	%{_tmppath}/LabPlot

%description
This is a program for plotting of functions and data manipulation.

%prep
rm -rf $RPM_BUILD_ROOT
rm -rf $RPM_BUILD_DIR/LabPlot-%{version}
%setup
export CFLAGS="-O2 -Wall"
export CXXFLAGS="-O2 -Wall"
./configure --prefix=/usr --disable-static --enable-texvc

%build
make

%clean
rm -rf $RPM_BUILD_ROOT
rm -rf $RPM_BUILD_DIR/LabPlot-%{version}

%install
make DESTDIR="$RPM_BUILD_ROOT" install
cd "$RPM_BUILD_ROOT"/usr
mv man share/
%ifarch x86_64 sparc64 ppc64 amd64
mv lib lib64
%endif
if [ -f /usr/bin/texvc ] ; then cp /usr/bin/texvc bin/ ; fi

%post
/sbin/ldconfig

%postun
/sbin/ldconfig

%files
%defattr(644,root,root,755)
%doc README TODO INSTALL ChangeLog CHANGES FEATURES LabPlot.lsm
%{_docdir}/HTML/*/labplot
%{_docdir}/HTML/*/LabPlot/*
%attr(755,root,root) %{_bindir}/*
%attr(755,root,root) %{_libdir}/*
%{_mandir}/man1/*.1*
%{_datadir}/apps/LabPlot/*
%{_datadir}/applnk/Applications/*.desktop
%{_datadir}/*/*/*/*/*.png
%{_datadir}/locale/*/LC_MESSAGES/LabPlot.mo
%{_datadir}/mimelnk/application/x-lpl.desktop

#%undefine __check_files

%changelog
* Mon Jan 23 2006 - Phil Schaffner <pschaff@cox.net>
- update to 1.5.1-pre5
* Thu Jan 12 2006 - Phil Schaffner <pschaff@cox.net>
- update to 1.5.1-pre4 with ocaml, Fedora gsl 1.7, for EL4 (CentOS4)
* Fri Aug 12 2005 - Stefan Gerlach
- update 1.5.0
* Sun Mar 27 2005 - Stefan Gerlach
- created for version 1.4.1
