//LabPlot : WaveletListDialog.h

#ifndef WAVELETLISTDIALOG_H
#define WAVELETLISTDIALOG_H

#include "ListDialog.h"

class WaveletListDialog : public ListDialog
{
	Q_OBJECT
public:
	WaveletListDialog(MainWin *mw, const char *name);
public slots:
	void setDirection(bool d=false) {	transform->setCurrentItem(d); }	//!< set direction forward/backward
	void setForm(bool t=false) { form->setCurrentItem(t); }			//!< set form of transformation
	void setType(int t) { typecb->setCurrentItem(t); }					//!< set type of transform
	void setK(int k) { kle->setText(QString::number(k)); }				//!< set k value
private:
	KComboBox *transform, *form, *typecb;
	KLineEdit *kle;
private slots:
	int apply_clicked();
};

#endif // WAVELETLISTDIALOG_H
