//LabPlot : TitleDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <qlabel.h>
#include <qfontdialog.h>
#include <qcolordialog.h>
#include <qdatetime.h>
#include <klocale.h>
#include <kpopupmenu.h>
#include "TitleDialog.h"

using namespace std;

TitleDialog::TitleDialog(MainWin *mw, const char *name)
	: Dialog(mw, name)
{
	kdDebug()<<"TitleDialog()"<<endl;
	setCaption(i18n("Title Settings")+i18n(" : ")+QString(name));

	title = p->getPlot(p->API())->Title();

	if(mw->activeWorksheet() && mw->activeWorksheet()->getPlot(0) &&
		mw->activeWorksheet()->getPlot(0)->Type() == PQWT3D )
		rtw = new RichTextWidget((QWidget *)vbox,title,0,1);
	else
		rtw = new RichTextWidget((QWidget *)vbox,title,0);

	QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));
	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
	
	setMinimumWidth(2*vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

void TitleDialog::apply_clicked() {
	kdDebug()<<"TitleDialog::apply_clicked()"<<endl;
	
	title = rtw->label();
	
	mw->updateSheetList();
	p->updatePixmap();
}

void TitleDialog::ok_clicked() {
	apply_clicked();
	accept();	
}
