//LabPlot : SeasonalListDialog.cc

#include "SeasonalListDialog.h"
#include "source.h"

using namespace std;

SeasonalListDialog::SeasonalListDialog(MainWin *mw, const char *name)
	: ListDialog(mw, name)
{
	setCaption(i18n("Seasonal Dialog"));

	QTabWidget *tw = new QTabWidget(vbox);
	QVBox *tab1 = new QVBox(tw);

	new QLabel(i18n(" Period :"),tab1);
	QHBox *hb = new QHBox(tab1);
	new QLabel(QString(" n = "),hb);
	nle = new KLineEdit(QString("3"),hb);
	nle->setValidator(new QIntValidator(nle));

	hb = new QHBox(tab1);
	new QLabel(i18n("Operation : "),hb);
        ocb= new KComboBox(hb);
	QStringList slist;
	slist << i18n("sum");
	slist << i18n("difference");
	ocb->insertStringList(slist);
	ocb->setCurrentItem(0);

	Style *style=0;
	Symbol *symbol=0;
	QVBox *styletab;
	if(p && p->getPlot(p->API())->Type() == PSURFACE)
		styletab = surfaceStyle(tw,true);
	else
		styletab = simpleStyle(tw, style, symbol);

	tw->addTab(tab1,i18n("Parameter"));
	tw->addTab(styletab,i18n("Style"));

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
        QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));
	
	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

int SeasonalListDialog::apply_clicked() {
	int n = (nle->text()).toInt();
	
	if(s) {
		QTable *table = s->Table();
		int col = table->currentColumn();
		
		if(n >= table->numRows()) {
			KMessageBox::error(this,i18n("n bigger than number of rows!\nPlease use a smaller value."));
			return -1;
		}
		
		// add column if needed
		bool empty=true;
		for(int i=0;i<table->numRows();i++) {
			if(table->text(i,table->numCols()-1).length()>0) {
				empty =false;
			}
		}
		if (!empty)
			s->addColumn();

		int newcol = table->numCols()-1;
		for (int i = 0;i<table->numRows()-n;i++) {
			double y=0;
			switch(ocb->currentItem()) {
			case 0: y = table->text(i+n,col).toDouble()+table->text(i,col).toDouble(); break;
			case 1: y = table->text(i+n,col).toDouble()-table->text(i,col).toDouble(); break;
			}

			// insert into last column
			table->setText(i,newcol,QString::number(y));
		}
		return 0;
	}
	
	GraphList *gl = p->getPlot(p->API())->getGraphList();
	if(gl->Number()==0) {
		KMessageBox::error(this,i18n("No graph found!"));
		return -2;
	}	
	int item = (int) (lv->itemPos(lv->currentItem())/lv->currentItem()->height());
	GRAPHType st = gl->getStruct(item);

	Style *style=0;
	Symbol *symbol=0;
	if(st != GRAPHM) {
		style = new Style(cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color(),
			widthle->text().toInt(),pencb->currentItem(),brushcb->currentItem());
		symbol = new Symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->text().toInt(),
			(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());
	}

	double xmin=0, xmax=1, ymin=0, ymax=1, zmin=0, zmax=1, tmin=0, tmax=1;
	if (st == GRAPH2D) {
		Graph2D *g = gl->getGraph2D(item);
		int nx = g->Number();
		
		if(n >= nx) {
			KMessageBox::error(this,i18n("n bigger than number of points!\nPlease use a smaller value."));
			return -1;
		}

		Point *ptr = new Point[nx-n];
		Point *a = g->Data();

		for (int i = 0;i<nx-n;i++) {
			double x = a[i].X();
			double y=0;
			switch(ocb->currentItem()) {
			case 0: y = a[i+n].Y()+a[i].Y(); break;
			case 1: y = a[i+n].Y()-a[i].Y(); break;
			}

			ptr[i].setPoint(x,y);
		}

		mw->calculateRanges2D(ptr,nx-n,&xmin,&xmax,&ymin,&ymax);

		// create the new Graph
		LRange range[2];
		range[0] = LRange(xmin,xmax);
		range[1] = LRange(ymin,ymax);

		QString fun = QString(i18n("seasonal (")+QString::number(n)+i18n(") of ")+g->Label());

		Graph2D *ng = new Graph2D(fun,fun,range,SSPREADSHEET,P2D,style,symbol,ptr,nx-n);
		mw->addGraph2D(ng,sheetcb->currentItem());
	}
	else if (st == GRAPH3D) {
		Graph3D *g = gl->getGraph3D(item);
		int nx = g->Number();
		
		if(n >= nx) {
			KMessageBox::error(this,i18n("n bigger than number of points!\nPlease use a smaller value."));
			return -1;
		}

		Point3D *ptr = new Point3D[nx-n];
		Point3D *a = g->Data();

		// TODO : PQWT3D
		if(type != P2D) {
			KMessageBox::error(this,i18n("Sorry. This function is not yet implemented!"));
			return -2;
		}
		
		// do it
		for (int i = 0;i<nx-n;i++) {
			double x = a[i].X();
			double y=0, z=a[i].Z();
			switch(ocb->currentItem()) {
			case 0: y = a[i+n].Y()+a[i].Y(); break;
			case 1: y = a[i+n].Y()-a[i].Y(); break;
			}

			ptr[i].setPoint(x,y,z);
		}

		mw->calculateRanges3D(ptr,nx-n,&xmin,&xmax,&ymin,&ymax,&zmin,&zmax);

		// create the new Graph
		LRange range[3];
		range[0] = LRange(xmin,xmax);
		range[1] = LRange(ymin,ymax);
		range[2] = LRange(zmin,zmax);
		
		QString fun = QString(i18n("seasonal (")+QString::number(n)+i18n(") of ")+g->Label());
		
		Graph3D *ng = new Graph3D(fun,fun,range,SSPREADSHEET,type,style,symbol,ptr,nx-n,1);
		ng->setNumberX((int)(g->NX()-n));
		ng->setNumberY((int)(g->NY()));
		mw->addGraph3D(ng,sheetcb->currentItem(),type);
	}
	else if (st == GRAPH4D) {
		Graph4D *g = gl->getGraph4D(item);
		int nx = g->Number();
		
		if(n >= nx) {
			KMessageBox::error(this,i18n("n bigger than number of points!\nPlease use a smaller value."));
			return -1;
		}

		Point4D *ptr = new Point4D[nx-n];
		Point4D *a = g->Data();

		for (int i = 0;i<nx-n;i++) {
			double x = a[i].X();
			double y=0, z=a[i].Z(),t=a[i].T();
			switch(ocb->currentItem()) {
			case 0: y = a[i+n].Y()+a[i].Y(); break;
			case 1: y = a[i+n].Y()-a[i].Y(); break;
			}

			ptr[i].setPoint(x,y,z,t);
		}

		mw->calculateRanges4D(ptr,nx-n,&xmin,&xmax,&ymin,&ymax,&zmin,&zmax,&tmin,&tmax);

		// create the new Graph
		LRange range[4];
		range[0] = LRange(xmin,xmax);
		range[1] = LRange(ymin,ymax);
		range[2] = LRange(zmin,zmax);
		range[2] = LRange(tmin,tmax);
		
		QString fun = QString(i18n("seasonal (")+QString::number(n)+i18n(") of ")+g->Label());
		
		Graph4D *ng = new Graph4D(fun,fun,range,SSPREADSHEET,type,style,symbol,ptr,nx-n,g->GType());
		mw->addGraph4D(ng,sheetcb->currentItem());
	}
	else if (st == GRAPHM) {		// PSURFACE and PQWT3D
		//TODO
		KMessageBox::error(this,i18n("Sorry. This function is not yet implemented!"));
		return -3;
		
		GraphM *g = gl->getGraphM(item);
		int N = g->Number();
		int nx = g->NX();
		int ny = g->NY();
		double *ptr = new double[N];
		//double *a = g->Data();

		// do it
		for (int i = 0;i<nx;i+=n) {
			for (int j = 0;j<ny;j+=n) {
			// TODO
			/*	double z = 0;
		
				for (int l=0;l<n;l++) {
					int a1 = i+l;
					for (int k=0;k<n;k++) {
						int a2 = j+k;
						z += a[a2+nx*a1];
					}
				}

				// new ranges
				if (i==0) {
					zmin=zmax=z;
				}
				else {
					z<zmin?zmin=z:0;
					z>zmax?zmax=z:0;
				}

				ptr[j/n+(nx)*i/n]=z;
			*/
			}
		}

		// create the new Graph
		LRange range[3];
		range[0] = LRange(1,nx);
		range[1] = LRange(1,ny);
		range[2] = LRange(zmin,zmax);
		
		QString fun = QString(i18n("seasonal (")+QString::number(n)+i18n(") of ")+g->Label());

		GraphM *ng = new GraphM(fun,fun,range,SSPREADSHEET,type,style,symbol,ptr,nx/n,ny/n);
		mw->addGraphM(ng,sheetcb->currentItem(),type);
	}

	updateList();

	return 0;
}
