//LabPlot : RichTextWidget.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <math.h>
#include <qlabel.h>
#include <qvbox.h>
#include <qhbox.h>
#include <qfontdialog.h>
#include <qvalidator.h>
#include <kpushbutton.h>
#include <qgroupbox.h>
#include <klocale.h>
#include "RichTextWidget.h"

RichTextWidget::RichTextWidget(QWidget *parent, Label *label, const char *name, bool qwtplot)
	: QWidget(parent,name), l(label)
{
	QGroupBox *gb = new QGroupBox(1,QGroupBox::Horizontal,QString(""),parent);

	QHBox *hb = new QHBox(gb);
	new QLabel(i18n("Position : "),hb);
	
	hb = new QHBox(gb);
	new QLabel(QString("x : "),hb);
	xle = new KLineEdit(QString::number(l->X()),hb);
	xle->setValidator(new QDoubleValidator(0.0,1.0,3,xle));
	new QLabel(QString(" y : "),hb);
	yle = new KLineEdit(QString::number(l->Y()),hb);
	yle->setValidator(new QDoubleValidator(0.0,1.0,3,yle));
	
	hb = new QHBox(gb);
	texcb = new QCheckBox(i18n("TeX label"),hb);
	if(qwtplot)
		texcb->hide();

	// if QWT3D Plot disable boxed and rotation
	hb = new QHBox(gb);
	boxedcb = new QCheckBox(i18n("Boxed"),hb);
	QObject::connect(boxedcb,SIGNAL(toggled(bool)),this,SLOT(boxedChanged(bool)));
	QLabel *rotl = new QLabel(QString("Rotation : "),hb);
	rotle = new KLineEdit(QString::number(l->Rotation()),hb);
	rotle->setMaximumWidth(150);
	rotle->setValidator(new QDoubleValidator(-360.0,360.0,3,rotle));
	if(qwtplot) {
		rotl->hide();
		boxedcb->hide();
		rotle->hide();
	}
	
	hb = new QHBox(gb);
	new QLabel(i18n("Font : "),hb); 
	titleFont = new KLineEdit(QString(""),hb);
	titleFont->setMaximumWidth(200);
	KPushButton *newtitleFont = new KPushButton(i18n("Change"),hb);
	QObject::connect(newtitleFont,SIGNAL(clicked()),SLOT(selectFont()));

	hb = new QHBox(gb);
	bold = new QToolButton(hb);
	QFont f1( QString("Adobe Times"), 12, QFont::Bold );
    	bold->setFont( f1 );
	bold->setText(QString("B"));
	bold->setToggleButton(true);
	bold->setOn(false);
	QObject::connect(bold,SIGNAL(clicked()),SLOT(toggleBold()));

	italic = new QToolButton(hb);
	QFont f2( QString("Adobe Times"), 12);
	f2.setItalic(true);
    	italic->setFont( f2 );
	italic->setText(QString("I"));
	italic->setToggleButton(true);
	italic->setOn(false);
	QObject::connect(italic,SIGNAL(clicked()),SLOT(toggleItalic()));

	underline = new QToolButton(hb);
	QFont f3( QString("Adobe Times"), 12);
	f3.setUnderline(true);
    	underline->setFont( f3 );
	underline->setText(QString("U"));
	underline->setToggleButton(true);
	underline->setOn(false);
	QObject::connect(underline,SIGNAL(clicked()),SLOT(toggleUnderline()));

	superscript = new QToolButton(hb);
	superscript->setText(QString("x"));
	superscript->setToggleButton(true);
	superscript->setOn(false);
	QObject::connect(superscript,SIGNAL(clicked()),SLOT(toggleSuperscript()));

	subscript = new QToolButton(hb);
	subscript->setText(QString("x_2"));
	subscript->setToggleButton(true);
	subscript->setOn(false);
	QObject::connect(subscript,SIGNAL(clicked()),SLOT(toggleSubscript()));

	hb = new QHBox(gb);
	kcb = new KColorButton(l->Color(),hb);
	kcb->setMaximumWidth(150);
	QObject::connect(kcb,SIGNAL(changed(const QColor &)),this,SLOT(setTEColor()));
	
	KPushButton *smallgreekpb = new KPushButton( QString("\341"), hb );
	sgletters = new KPopupMenu();
	sgletters->setFont(QFont(QString("Greek Times")));
	QObject::connect(sgletters,SIGNAL(activated(int)),SLOT(insertGChar(int)));
	smallgreekpb->setPopup(sgletters);
	for (int i=0;i<25;i++) {
		sgletters->insertItem(QString(QChar(i+225)),i+225);
	}
	KPushButton *biggreekpb = new KPushButton( QString("\303"), hb );
	bgletters = new KPopupMenu();
	bgletters->setFont(QFont(QString("Greek Times")));
	QObject::connect(bgletters,SIGNAL(activated(int)),SLOT(insertGChar(int)));
	biggreekpb->setPopup(bgletters);
	for (int i=0;i<24;i++) {
		bgletters->insertItem(QString(QChar(i+193)),i+193);
	}
	KPushButton *otherpb = new KPushButton(QString("\243"), hb );
	oletters = new KPopupMenu();
	QObject::connect(oletters,SIGNAL(activated(int)),SLOT(insertChar(int)));
	otherpb->setPopup(oletters);
	for (int i=0;i<222;i++) {
		oletters->insertItem(QString(QChar(i+161)),i+1161);	// +1000 to avoid crossing with greeks 
	}
	
	smallgreekpb->setMaximumWidth(40);
	biggreekpb->setMaximumWidth(40);
	otherpb->setMaximumWidth(40);
	smallgreekpb->setFont(QFont(QString("Greek Times")));
	biggreekpb->setFont(QFont(QString("Greek Times")));
	otherpb->setFont(QFont(QString("Greek Times")));

	te = new QTextEdit(gb);
	te->setTextFormat(Qt::RichText);
	update();
}

void RichTextWidget::update() {
	kdDebug()<<"RTW::update()"<<endl;
	
	xle->setText(QString::number(l->X()));
	yle->setText(QString::number(l->Y()));
	
	texcb->setChecked(l->isTeXLabel());
	boxedcb->setChecked(l->Boxed());
	rotle->setText(QString::number(l->Rotation()));
	
	te->setFont(l->Font());
	titleFont->setText(l->Font().family() + " " + QString::number(l->Font().pointSize()));
	te->setText(l->Title());
	kcb->setColor(l->Color());
}

void RichTextWidget::insertChar(int ch) {
	te->setFamily(QString("Adobe Times"));
	te->insert(QString(QChar(ch-1000)));
}

void RichTextWidget::insertGChar(int ch) {
	te->setFamily(QString("Greek Times"));
	te->insert(QString(QChar(ch)));
}

void RichTextWidget::toggleBold() {
	if(bold->isOn()) {
		bold->setOn(false);
		te->setBold(true);
	}
	else {
		bold->setOn(true);
		te->setBold(false);
	}
	bold->toggle();
}

void RichTextWidget::toggleItalic() {
	if(italic->isOn()) {
		italic->setOn(false);
		te->setItalic(true);
	}
	else {
		italic->setOn(true);
		te->setItalic(false);
	}
	italic->toggle();
}

void RichTextWidget::toggleUnderline() {
	if(underline->isOn()) {
		underline->setOn(false);
		te->setUnderline(true);
	}
	else {
		underline->setOn(true);
		te->setUnderline(false);
	}
	underline->toggle();
}

void RichTextWidget::toggleSuperscript() {
	if(superscript->isOn()) {
		superscript->setOn(false);
		te->setVerticalAlignment(QTextEdit::AlignSuperScript);
		if(subscript->isOn())
			subscript->toggle();
		subscript->setOn(false);
	}
	else {
		superscript->setOn(true);
		te->setVerticalAlignment(QTextEdit::AlignNormal);
	}
	superscript->toggle();
}

void RichTextWidget::toggleSubscript() {
	if(subscript->isOn()) {
		subscript->setOn(false);
		te->setVerticalAlignment(QTextEdit::AlignSubScript);
		if(superscript->isOn())
			superscript->toggle();
		superscript->setOn(false);
	}
	else {
		subscript->setOn(true);
		te->setVerticalAlignment(QTextEdit::AlignNormal);
	}
	subscript->toggle();
}

void RichTextWidget::selectFont() {
    bool ok;
    // first time it doesn't work with helvetia font !
    QFont f = QFontDialog::getFont( &ok,l->Font() ,this );
    if ( ok ) {
	l->setFont(f);
	titleFont->setText(f.family()+ " " + QString::number(f.pointSize()));
	te->setFont(f);
    }
}

void RichTextWidget::setTEColor() {
	QColor c = kcb->color();
	l->setColor(c);
	te->setColor(c);
}

void RichTextWidget::apply() {
	l->setTeXLabel(texcb->isChecked());
	if(l->isTeXLabel())
		te->setTextFormat(Qt::PlainText);
	kdDebug()<<"RichTextWidget::apply() : text = "<<te->text()<<endl;
	kdDebug()<<"	RICHTEXT = "<<te->text()<<endl;

	// doesn't work :-(
/*	const QChar *utf8text = te->text().unicode();
	
	te->setTextFormat(Qt::PlainText);
	kdDebug()<<"	PLAINTEXT = "<<te->text().utf8()<<endl;
	kdDebug()<<"	PLAINTEXT = "<<te->text().local8Bit()<<endl;
	kdDebug()<<"	PLAINTEXT = "<<te->text().unicode()<<endl;
	kdDebug()<<"	UTF8 TEXT = "<<utf8text<<endl;
*/
	l->setTitle(te->text());
	l->setPosition(xle->text().toDouble(),yle->text().toDouble());
	l->setBoxed(boxedcb->isChecked());
	l->setRotation(rotle->text().toDouble());
}
