//LabPlot : Rect.cc

#include <math.h>
#include <iostream>
#include <kdebug.h>
#include "Rect.h"

using namespace std;

Rect::Rect(Point s,Point e,QColor c,int w, bool f, QColor fi) {
	start = s;
	end = e;
	color = c;
	width = w;
	filled = f;
	fill = fi;
}

QStringList Rect::Info() {
	QStringList s;

	// no rect
	if(start.X() == end.X() && start.Y() == end.Y())
		return s;

        s << QString::number(start.X())+"/"+QString::number(start.Y());
        s << QString::number(end.X())+"/"+QString::number(end.Y());
	s << QString::number(width);
        s << color.name();
	s << QString::number(filled);
	s << fill.name();

	return s;
}

// draw the line on the worksheet
void Rect::draw(QPainter *p, int X, int Y) {
//	kdDebug()<<"Rect::draw() from "<<X*start.X()<<'/'<<Y*start.Y()<<" to "<<X*end.X()<<'/'<<Y*end.Y()<<endl;

	if(fabs(end.X()-start.X())>1.0e-6) {
	        p->setPen(QPen(color,width));
		
		if (filled)
			p->setBrush(fill);
		else
			p->setBrush(Qt::NoBrush);
		
		p->drawRect((int)(X*start.X()),(int)(Y*start.Y()),(int)(X*end.X()),(int)(Y*end.Y()));
	}
}

// save
void Rect::save(QTextStream *t) {
	*t<<start.X()<<' '<<start.Y()<<' '<<end.X()<<' '<<end.Y()<<endl;
	*t<<color.name()<<' '<<width<<' '<<filled<<' '<<fill.name()<<endl;
}

// open
void Rect::open(QTextStream *t,int version) {
	kdDebug()<<"Rect::open() : "<<version<<endl;
	double sx,sy,ex,ey;
	QString colorstring, fillstring;
	int f;
	
	*t>>sx>>sy>>ex>>ey;

	start.setPoint(sx,sy);
	end.setPoint(ex,ey);
	
	*t>>colorstring>>width>>f>>fillstring;
	color=QColor(colorstring);
	fill=f;
	fill=QColor(fillstring);
}

bool Rect::inside(int x, int y, int w, int h) {
	double sx=start.X(), sy=start.Y();
	double ex=end.X(), ey=end.Y();
	if(x>sx*w && x<(ex+sx)*w && y>sy*h && y<(ey+sy)*h)
		return true;
	return false;
}
