// LabPlot : PlotTernary.cc

#include <iostream>
#include <klocale.h>
#include <kdebug.h>
#include "PlotTernary.h"

using namespace std;

//! general ternary Plot class
PlotTernary::PlotTernary(Worksheet *p)
	: Plot(p)
{
	QFont font = p->getMainWin()->defaultFont();
	title = new Label(i18n("Ternary Plot"),font,QColor(Qt::black));
	title->setPosition(0.4,0.02);

	font.setPointSize((int)(0.7*font.pointSize()));	// for tic label
	axis.setTicsFont(font);

	for (int i=0;i<2;i++)
		gridenabled[i]=true;

	borderenabled=true;
	axis.setMajorTics(6);
}

//! Infos for project explorer
QStringList PlotTernary::Info() {
	QStringList s;
	s<<"Ternary";

	s<<QString::number(position.X())+QString(" , ")+QString::number(position.Y());
	s<<QString::number(size.X())+QString(" X ")+QString::number(size.Y());
	if (transparent)
		s<<QString("yes");
	else
		s<<QString("no");
	s<<bgcolor.name();
	s<<gbgcolor.name();

	return s;
}

void PlotTernary::draw(QPainter *p, int w, int h) {
	kdDebug()<<"PlotTernary::draw() w/h : "<<w<<' '<<h<<endl;

	if (!transparent) {
		// background color
		p->setBrush(bgcolor);
		p->setPen(Qt::NoPen);
		p->drawRect((int)(w*position.X()),(int)(h*position.Y()),(int)(w*size.X()),(int)(h*size.Y()));

		// graph background color
		p->setBrush(gbgcolor);
		p->setPen(Qt::NoPen);
	}

	kdDebug()<<"PlotTernary : title->draw() pos:"<<position.X()<<' '<<position.Y()<<endl;
	kdDebug()<<" 			size:"<<size.X()<<' '<<size.Y()<<endl;
	title->draw(worksheet,p,position,size,w,h,0);

	drawCurves(p, w, h);

	if(legend.enabled())
		legend.draw(p,type,graphlist,position,size,w,h);
	p->setPen(Qt::NoPen);
}

void PlotTernary::drawCurves(QPainter *p, int w, int h) {
	kdDebug()<<"PlotTernary::drawCurves()"<<endl;
	int xmin = (int)(w*(size.X()*p1.X()+position.X()));
	int xmax = (int)(w*(size.X()*p2.X()+position.X()));
	int ymin = (int)(h*(size.Y()*p1.Y()+position.Y()));
	int ymax = (int)(h*(size.Y()*p2.Y()+position.Y()));

	xmax-=20;	// some space for tic label
	
	double maxx = actrange[0].rMax();
	kdDebug()<<"maxx = "<<maxx<<endl;

	kdDebug()<<"xmin/xmax ymin/ymax : "<<xmin<<'/'<<xmax<<' '<<ymin<<'/'<<ymax<<endl;
	kdDebug()<<"width/height : "<<w<<'/'<<h<<endl;
	
	// TODO : tic color ???
	p->setPen(Qt::black);

	// border lines
	if (borderenabled) {
		p->drawLine(xmin,ymax,xmax,ymax);
		p->drawLine(xmin,ymax,(int)(xmax+xmin)/2,ymin);
		p->drawLine(xmax,ymax,(int)(xmax+xmin)/2,ymin);
	}
	
	// TODO : use 3 custom axes label, use label properties
	QFont font = worksheet->getMainWin()->defaultFont();
	font.setPointSize((int)(0.7*font.pointSize()));
	p->setFont(font);
	p->drawText((xmax+xmin)/2-10,ymax+40,QString("a"));
	p->drawText(xmax-(xmax-xmin)/5+10,(ymax+ymin)/2,QString("b"));
	p->drawText(xmin+(xmax-xmin)/5-10,(ymax+ymin)/2,QString("c"));
	
	int major_tics = axis.MajorTics();
	if(major_tics==-1)
		major_tics=autoTics(0,maxx);

	// int minor_tics = axis.MinorTics();
	for (int i=0;i<major_tics;i++) {
		// TODO : fix rounding problem
		 int x1 = xmin+i*(xmax-xmin)/(major_tics-1);
		 int x2 = (xmax+xmin)/2-i*(xmax-xmin)/(2*(major_tics-1));
		 int y2 = ymin+i*(ymax-ymin)/(major_tics-1);
		 int x3 = xmax-i*(xmax-xmin)/(2*(major_tics-1));
		 int y3 = ymax-i*(ymax-ymin)/(major_tics-1);
	
		// major tics & tic label
		if (axis.MajorTicsEnabled()) {
			// tics
			p->drawLine(x1,ymax,x1-7,ymax+7);
			p->drawLine(x2-7,y2-7,x2,y2);
			p->drawLine(x3+10,y3,x3,y3);
	
			// tic label		TODO : tic label format
			QFont f = axis.TicsFont();
			f.setPointSize((int)(f.pointSize()*size.X()));
			p->setFont(f);
	
			QString label = QString::number(maxx*i/(major_tics-1));
			QFontMetrics fm(axis.TicsFont());
			p->save();	// a
			p->translate(x1-fm.width(label)/2-5,ymax+fm.ascent()/2+10);
			p->rotate(axis.TicsLabelRotation());
			p->drawText(-fm.width(label)/2,fm.ascent()/2,label);
			p->restore();
			p->save();	// c
			p->translate(x2-fm.width(label)/2-15,y2+fm.ascent()/2-20);
			p->rotate(axis.TicsLabelRotation());
			p->drawText(-fm.width(label)/2,fm.ascent()/2,label);
			p->restore();
			p->save();	// b
			p->translate(x3-fm.width(label)/2+30,y3+fm.ascent()/2-10);
			p->rotate(axis.TicsLabelRotation());
			p->drawText(-fm.width(label)/2,fm.ascent()/2,label);
			p->restore();
		}
		if (gridenabled[0] && i<major_tics-1) {
			p->drawLine(x1,ymax,(xmax+xmin)/2-x2+xmin,y3);
			p->drawLine(x2,y2,xmax+xmin-x2,y2);
			p->drawLine(x3,y3,xmax+xmin-x1,ymax);
		}
		
		// TODO : minor tics
		// TODO : minor grid
	}
	
	// TODO : clipping rect with some space (clipoffset)
	//p->setClipRect(xmin-clipoffset,ymin-clipoffset,xmax-xmin+2*clipoffset,ymax-ymin+2*clipoffset);
	
	// draw curves
	for (unsigned int nr=0; nr < graphlist->Number() ; nr++) {
		if(graphlist->getGraph(nr)->isShown() == false)
			continue;
		
		GRAPHType s = graphlist->getStruct(nr);
		if (s == GRAPH3D) {
			Graph3D *g = graphlist->getGraph3D(nr);	

			kdDebug()<<"GRAPH3D / 3D number="<<g->Number()<<endl;

			Point3D *d = g->Data();
			int N = g->Number();
			Style *style =  g->getStyle();
			Symbol *symbol = g->getSymbol();	

			double oldx=0.0, oldy=0.0;
			QPointArray pa(N);
			int pointindex=0;
			for (int i=0;i<N;i++) {
				if(d[i].Masked())
					continue;
				
				if(worksheet->getMainWin()->speedMode()) {
					int mod = (int) (N/worksheet->getMainWin()->speedModeValue());
					if(mod==0) mod=1;
					if(i%mod != 0) continue;	// speed mode
				}
				
				double a = d[i].X(), c = d[i].Z();

				// point 1 :  a baseline
				double p1x=(xmin+xmax)/2.0+a/(2.0*maxx)*(xmax-xmin);
				double p1y=ymin+a/maxx*(ymax-ymin);
				// point 2 : b baseline
				double p2x=xmin+a/maxx*(xmax-xmin);
				double p2y=ymax;
				
				int y = (int) (p1y+(int)(c/maxx*(ymax-ymin)));
				int x = (int) (p1x+(y-p1y)/(p2y-p1y)*(p2x-p1x));
				
				// fix possible problem
				if (a==maxx)
					x=xmax;
				
//				kdDebug()<<"POINT "<<i<<endl;
//				kdDebug()<<"p1 = "<<p1x<<'/'<<p1y<<endl;
//				kdDebug()<<"p2 = "<<p2x<<'/'<<p2y<<endl;
//	test line		p->drawLine(p1x,p1y,p2x,p2y);
//				kdDebug()<<"x/y = "<<x<<' '<<y<<endl;
				
				pa[pointindex++]=QPoint(x,y);
				oldx=x;oldy=y;
			}
			pa.resize(pointindex);	// resize to clear all unneeded points (from draw outside border)
			drawStyle(p,style,symbol,pa,xmin,xmax,ymin,ymax);
		}
	}

	p->setClipping(false);
}

void PlotTernary::saveAxes(QTextStream *t) {
	saveAxis(t,&axis,gridenabled[0],borderenabled,gridenabled[1]);
}

void PlotTernary::openAxes(QTextStream *t, int version) {
	openAxis(t,version, &axis,&gridenabled[0],&borderenabled,&gridenabled[1]);
}
