//LabPlot : PlotQWT3D.h

#ifndef PLOTQWT3D_H
#define PLOTQWT3D_H

#ifdef HAVE_GL
#include "qwt3d_surfaceplot.h"
#endif
#include "Plot.h"

class PlotQWT3D : public Plot
#ifdef HAVE_GL
	, public Qwt3D::SurfacePlot
#endif
{
public:
	PlotQWT3D(Worksheet *p);
	QStringList Info();
	void mouseDoubleClickEvent(QMouseEvent *e);
	
	void Export(QPainter *p, QString fn,QString format, int w, int h);
	void draw(QPainter *p, int w, int h);
	void drawCurves(QPainter *p, int w, int h);
#ifdef HAVE_GL
	void setPlotStyle(Qwt3D::PLOTSTYLE p) { plotstyle = p; }
	Qwt3D::PLOTSTYLE PlotStyle() { return plotstyle; }
	void setCoordinateStyle(Qwt3D::COORDSTYLE c) { coordinatestyle = c; }
	Qwt3D::COORDSTYLE CoordinateStyle() { return coordinatestyle; }
	void setFloorStyle( Qwt3D::FLOORSTYLE f) { floorstyle = f; }
	Qwt3D::FLOORSTYLE FloorStyle() { return floorstyle; }
	void setColorVector(Qwt3D::ColorVector c) { cv=c; }
	Qwt3D::ColorVector getColorVector() { return cv; }
#endif
	// unused	
	void saveAxes(QTextStream *) {}
	void openAxes(QTextStream *,int) {}
	Axis *getAxis(int i) { return &axis[i]; }
	void setRange(LRange* r ,int i) {range[i] = *r; }
	void setActRange(LRange* r,int i) {actrange[i] = *r; }
	void setRanges(LRange* r) {range[0]=r[0];range[1]=r[1];range[2]=r[2]; }
	void setActRanges(LRange* r) {actrange[0]=r[0];actrange[1]=r[1];actrange[2]=r[2]; }
	void enableGrid(int index,bool b=true) { gridenabled[index] = b; }
	bool gridEnabled(int index) { return gridenabled[index]; }
	void enableBorder(int index,bool b=true) { borderenabled[index] = b; }
	bool borderEnabled(int index) { return borderenabled[index]; }
	void setBorder(int item, bool on) { kdDebug()<<"PlotQWT3D::setBorder() : "<<item<<' '<<on<<endl; }
	int aspectRatio() { return aspect_ratio; }
	void setAspectRatio(int a) { aspect_ratio=a; }
	bool mouseDisabled() { return mouse_disabled; }
	void disableMouse(bool m) { mouse_disabled=m; }
	double majorTicLength(int i) { return major_length[i]; }
	void setMajorTicLength(int i, double v) {major_length[i]=v; }
	double minorTicLength(int i) { return minor_length[i]; }
	void setMinorTicLength(int i, double v) {minor_length[i]=v; }
	int Resolution() { return resolution; }
	void setDataResolution(int res) { resolution=res; }
private:
	void draw();
#ifdef HAVE_GL
	Qwt3D::PLOTSTYLE plotstyle;
	Qwt3D::COORDSTYLE coordinatestyle;
	Qwt3D::FLOORSTYLE floorstyle;
	Qwt3D::ColorVector cv;
#endif
	Axis axis[12];			//unused
	bool borderenabled[4];	// unused
	bool gridenabled[24];	// unused
	// x, xmin, y, ymin, z, zmin, x2, x2min, y2, y2min , z2, z2min, 
	// x3, x3min, y3, y3min, z3, z3min, x4, x4min, y4, y4min, z4, z4min
	int aspect_ratio;	
	bool mouse_disabled;
	double major_length[12];
	double minor_length[12];
	int resolution;
};

#endif //PLOTQWT3D_H
