//LabPlot : PlotDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <qlabel.h>
#include <qhbox.h>
#include <qlayout.h>
#include <qcolordialog.h>
#include <qbuttongroup.h>
#include <klocale.h>
#include "PlotDialog.h"
#include "Plot2DSimple.h"
#include "Plot2DSurface.h"
#include "Plot3D.h"
#include "PlotPie.h"
#include "PlotPolar.h"
#include "PlotTernary.h"
#include "PlotQWT3D.h"

//! general class for plot settings
PlotDialog::PlotDialog(MainWin *mw, const char *name)
	: Dialog(mw, name)
{
	setCaption(i18n("Plot Dialog")+i18n(" : ")+QString(name));

	lv = new QListView(vbox,0);
	lv->addColumn(i18n("Number"));
	lv->addColumn(i18n("Type"));
	lv->addColumn(i18n("Position"));
	lv->addColumn(i18n("Size"));
	lv->addColumn(i18n("Transparent"));
	lv->addColumn(i18n("Background Color"));
	lv->addColumn(i18n("Graph Background Color"));

	lv->setAllColumnsShowFocus(true);
	for (int i=0;i<lv->columns();i++)
		lv->setColumnAlignment(i,Qt::AlignHCenter);
	// multi selection with CTRL and SHIFT
	lv->setSelectionMode(QListView::Extended);
	lv->setMinimumWidth(350);

	// popup menu
	if(p) {
		menu = new QPopupMenu( lv );
		menu->insertItem( i18n( "Clone" ),this,SLOT(clonePlot()) );
		menu->insertItem( i18n( "Delete" ),this,SLOT(deletePlot()) );
		connect(lv, SIGNAL( rightButtonPressed( QListViewItem *, const QPoint& , int ) ),
			this, SLOT( Menu(QListViewItem *, const QPoint& , int) ) );
	}
	updateList();
}

void PlotDialog::updateList() {
	lv->clear();
	lv->setSorting(-1);

	for (int i= p->NrPlots()-1;i>=0;i--) {
		QListViewItem *lvi = new QListViewItem(lv);
		QStringList s;
		s += QString::number(i+1);

		Plot *plot = p->getPlot(i);
		if(plot==0) continue;
		PType type = plot->Type();
		switch (type) {
		case P2D:	s += ((Plot2DSimple *)plot)->Info();break;
		case PSURFACE:	s += ((Plot2DSurface *)plot)->Info();break;
		case P3D:	s += ((Plot3D *)plot)->Info();break;
		case PPIE:	s += ((PlotPie *)plot)->Info();break;
		case PPOLAR:	s += ((PlotPolar *)plot)->Info();break;
		case PTERNARY:	s += ((PlotTernary *)plot)->Info();break;
		case PQWT3D:	s += ((PlotQWT3D *)plot)->Info();break;
		default:	break;
		}
			
		for (unsigned int j = 0;j < s.count();j++) {
			lvi->setText(j,s[j]);
		}
	}
}

void PlotDialog::deletePlot(int item) {
#if QT_VERSION > 0x030102
	QListViewItemIterator it(lv,QListViewItemIterator::Selected);
#else
	QListViewItemIterator it(lv);
#endif
	for ( ; it.current(); ++it ) {
#if QT_VERSION <= 0x030102
		if(!it.current()->isSelected())
			continue;
#endif
		if(item == -1)
			item = (int) (lv->itemPos(it.current())/it.current()->height());
		p->deletePlot(item);
	}

	updateList();
}

void PlotDialog::clonePlot(int pitem) {
#if QT_VERSION > 0x030102
	QListViewItemIterator it(lv,QListViewItemIterator::Selected);
#else
	QListViewItemIterator it(lv);
#endif
	for ( ; it.current(); ++it ) {
#if QT_VERSION <= 0x030102
		if(!it.current()->isSelected())
			continue;
#endif
		if(pitem == -1)
			pitem = (int) (lv->itemPos(it.current())/it.current()->height());
		Plot *plot = p->getPlot(pitem);
		p->newPlot(plot->Type());
		Plot *newplot = p->getPlot(p->NrPlots()-1);
		
		// copy ranges
		newplot->setRanges(plot->Ranges());
		newplot->setActRanges(plot->ActRanges());

		// TODO : copy all settings
		newplot->setRegion(plot->Region());
		newplot->setRegionEnabled(plot->regionEnabled());
		newplot->setTransparent(plot->Transparent());
		newplot->setClipOffset(plot->ClipOffset());

		// copy border/grid for all axes
		int nr_axes=0;
		switch (plot->Type()) {
		case P2D: case PSURFACE : nr_axes=4; break;
		case P3D: nr_axes=12; break;
		case PPOLAR: nr_axes=2; break;
		case PTERNARY: nr_axes=1; break;
		default:break;
		}
		for(int i=0;i<nr_axes;i++) {
			newplot->enableBorder(i,plot->borderEnabled(i));
			newplot->enableGrid(2*i,plot->gridEnabled(2*i));	// major
			newplot->enableGrid(2*i+1,plot->gridEnabled(2*i+1));	// minor
		}

		newplot->setBaselineEnabled(plot->baselineEnabled());
		newplot->setXBaselineEnabled(plot->xbaselineEnabled());
		newplot->setBaseline(plot->Baseline());
		newplot->setXBaseline(plot->XBaseline());
		newplot->setMarksEnabled(plot->marksEnabled());
		newplot->setMarkX(plot->markX());
		newplot->setMarkY(plot->markY());
		newplot->setBackground(plot->Background());
		newplot->setGraphBackground(plot->graphBackground());
		
		// clone all graphs
		GraphList *gl = plot->getGraphList();
		GraphList *newgl = newplot->getGraphList();
		for(unsigned int item=0;item<gl->Number();item++) {
			switch(gl->getStruct(item)) {
			case GRAPH2D: {
				Graph2D *g = new Graph2D(*(gl->getGraph2D(item)));
				newgl->addGraph2D(g);
				}; break;
			case GRAPH3D: {
				Graph3D *g = new Graph3D(*(gl->getGraph3D(item)));
				newgl->addGraph3D(g);
				}; break;
			case GRAPH4D: {
				Graph4D *g = new Graph4D(*(gl->getGraph4D(item)));
				newgl->addGraph4D(g);
				}; break;
			case GRAPHM: {
				GraphM *g = new GraphM(*(gl->getGraphM(item)));
				newgl->addGraphM(g);
				}; break;
			case GRAPHIMAGE: {
				GraphIMAGE *g = new GraphIMAGE(*(gl->getGraphIMAGE(item)));
				newgl->addGraphIMAGE(g);
				}; break;
			default: break;
			}
		}
	}
	
	updateList();
	p->updatePixmap();
}
