//LabPlot : PeriodicListDialog.h

#ifndef PERIODICLISTDIALOG_H
#define PERIODICLISTDIALOG_H

#include "ListDialog.h"

class PeriodicListDialog : public ListDialog
{
	Q_OBJECT
public:
	PeriodicListDialog(MainWin *mw, const char *name);
public slots:
	void setPeriod(int p) {nle->setText(QString::number(p)); }			//!< set period number of points
	void setAverage(bool a=true) { averagecb->setChecked(a); }	//!< average over period
private:
	KLineEdit *nle;
	QCheckBox *averagecb;
private slots:
	int apply_clicked();
};

#endif // PERIODICLISTDIALOG_H
