//LabPlot : ObjectDialog.h

#ifndef OBJECTDIALOG_H
#define OBJECTDIALOG_H

#include <qfont.h>
#include <qcheckbox.h>
#include <qlistview.h>
#include "Worksheet.h"
#include "Dialog.h"
#include "RichTextWidget.h"

class ObjectDialog: public Dialog
{
	Q_OBJECT
public:
	ObjectDialog(MainWin *mw, const char *name, int activetab,int item);
public slots:
	void ok_clicked() { apply_clicked(); accept(); }
	void apply_clicked();
private slots:
	void deleteObject();
	void selectFile();
	void updateLine();
	void updateLineListView();
	void updateLabel();
	void updateLabelListView();
	void updateRect();
	void updateRectListView();
	void updateEllipse();
	void updateEllipseListView();
	void updateImage();
	void updateImageListView();
private:
	QTabWidget *tw;
	RichTextWidget *rtw;
	QListView *lv1, *lv2, *lv3, *lv4, *lv5;	// line, label, rect, ellipse, image
	KLineEdit *lx1le, *ly1le, *lx2le, *ly2le;	//line
	KLineEdit *rx1le, *ry1le, *rx2le, *ry2le;	//rect
	KLineEdit *ex1le, *ey1le, *ex2le, *ey2le;	//ellipse
	KLineEdit *ixle, *iyle;				//image
	KLineEdit *lwle, *rwle, *ewle, *ile, *isle, *iale, *salle, *saale, *ealle, *eaale;
	KColorButton *lcb, *rcb, *rfcb, *ecb, *efcb, *safccb, *eafccb;
	QCheckBox *rfccb, *efccb, *startcb, *endcb, *safcb, *eafcb;
	int item;							// current item
};

#endif //OBJECTDIALOG_H
