//LabPlot : NoiseListDialog.cc

#include "NoiseListDialog.h"

#if HAVE_GSL
//#include <gsl/gsl_dht.h>
#endif
	
NoiseListDialog::NoiseListDialog(MainWin *mw, const char *name)
	: ListDialog(mw, name)
{
	kdDebug()<<"NoiseListDialog()"<<endl;
	setCaption(i18n("Noise Dialog"));

	QTabWidget *tw = new QTabWidget(vbox);
	QVBox *tab1 = new QVBox(tw);

	Style *style=0;
	Symbol *symbol=0;
	QVBox *styletab;
	if(p && p->getPlot(p->API())->Type() == PSURFACE) {
		styletab = surfaceStyle(tw,true);
	}
	else {
		styletab = simpleStyle(tw, style, symbol);
	}

	tw->addTab(tab1,i18n("Parameter"));
	tw->addTab(styletab,i18n("Style"));

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
        QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));

	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

int NoiseListDialog::apply_clicked() {
	kdDebug()<<"NoiseListDialog::apply_clicked()"<<endl;
#if HAVE_GSL
	// TODO

	if(p) updateList();
#endif

	return 0;
}
