//LabPlot: Legend.h

#ifndef LEGEND_H
#define LEGEND_H

#include <qfont.h>
#include <qpainter.h>
#include "GraphList.h"
#include "Symbol.h"

class Legend {
public:
	Legend();
	void save(QTextStream *t);
	void open(QTextStream *t, int version);
	void setFont(QFont font) { f = font; }
	QFont Font() { return f; }
	void enable(bool b=true) { e = b; }
	bool enabled() { return e; }
	void setPosition(double X, double Y) { x = X; y = Y; }
	double X() { return x; }
	double Y() { return y; }
	void enableBorder(bool b=true) { border = b; }
	bool borderEnabled() { return border; }
	bool getOrientation() { return orientation; }
	void setOrientation(bool o) { orientation=o; }
	void draw(QPainter *p, PType type, GraphList *graphlist, Point pos, Point size,int w, int h);
	bool inside(int X, int Y);
	int TicLabelLength() { return ticlabellength; }
	void setTicLabelLength(int l) { ticlabellength = l; }
private:
	double x,y;			// position 0..1
	int x1, y1, x2, y2;		// legend box
	QFont f;				// legend font
	bool border;			// border enabled
	bool e;				// legend enabled
	int namelength;		// legend width
	bool orientation;		// 0: BottomTop, 1:LeftRight
	int ticlabellength;		// max length of tic label. used for border 
};

#endif //LEGEND_H
