//LabPlot: Label.h

#ifndef LABEL_H
#define LABEL_H

#include <qtextstream.h>
#include <qfont.h>
#include <qcolor.h>
#include <qsimplerichtext.h>
#include <qstringlist.h>
#include "Point.h"

class Label {
public:
	Label(QString string = QString(""), QFont font = QFont(QString("Adobe Times"),14),QColor color = QColor("black"));
	QStringList Info();
	void save(QTextStream *ts);
	void open(QTextStream *ts,int version);
	void draw(class Worksheet *ws, QPainter *p,Point pos,Point size, int w, int h, double phi);	
										// draw the label with given width and height
	bool inside(int x0, int y0, Point pos, Point size, int w, int h);
	bool insideY(int x0, int y0, Point pos, Point size, int w, int h);
	bool insideZ(int x0, int y0, Point pos, Point size, int w, int h);	// for 3d y-axes
	void setPosition(double X, double Y) { x=X; y=Y; }
	double X() { return x;}
	double Y() { return y;}
	QString Title() { return t; }		
	void setTitle(QString title) { t = title; }
	void setColor(QColor color) { c = color; }
	void setColor(QString color) { c = QColor(color); }
	QColor Color() { return c; }
	void setFont(QFont font) { f = font; }
	QFont Font() { return f; }
	void setBoxed(bool b) { boxed = b; }
	bool Boxed() { return boxed; }
	double Rotation() { return rotation; }
	void setRotation(double r) { rotation = r; }
	bool isTeXLabel() { return is_texlabel; }
	void setTeXLabel(bool t) { is_texlabel=t; }
private:
	double x, y;		// position
	QString t;			// label string
	QFont f;			// label font
	QColor c;			// label color
	QSimpleRichText *richtext;
	bool boxed;		// surrounding box
	double rotation;	// label rotation
	bool is_texlabel;	// if it is a tex label
};

#endif //LABEL_H
