//LabPlot: Label.cc

#include <sys/stat.h>
#include <iostream>
#include <qbrush.h>
#include <qpalette.h>
#include <qpainter.h>
#include <qregexp.h>
#include <qmime.h>
#include <qstylesheet.h>
#include <qdir.h>
#include <qimage.h>
#include <kdebug.h>
#include <kdeversion.h>
#if KDE_VERSION > 0x030104
#include <ktempdir.h>
#endif
#include <kprocess.h>
#include <kmessagebox.h>
#include <klocale.h>
#include "Label.h"

using namespace std;

Label::Label(QString string, QFont font, QColor color) {
	t = string;
	f = font;
	c = color;
	x=y=0;
	richtext = new QSimpleRichText(t,f);
	boxed=false;
	rotation = 0.0;
	is_texlabel=false;
}

QStringList Label::Info() {
	QStringList s;
	
	// no label
	if(t.length()==0)
		return s;

        s << QString::number(x) + "/" + QString::number(y);

	return s;
}

void Label::save(QTextStream *ts) {
	t.replace( QRegExp(QString("\n")), QString("") ); // strip all newlines from t
	*ts<<t<<endl;
	
	*ts<<f.family()<<endl;
	*ts<<f.pointSize()<<' ';
	*ts<<f.weight()<<' '<<f.italic()<<endl;
	
	*ts<<c.name()<<endl;
	
	*ts<<x<<' '<<y<<endl;
	*ts<<(int)boxed<<endl;
	*ts<<rotation<<endl;	
	*ts<<(int)is_texlabel<<endl;	
}
void Label::open(QTextStream *ts,int version) {
	kdDebug()<<"Label::open()"<<endl;
	QString title, family, color;
	int pointsize, weight, italic, tmp;
	double tmpx,tmpy;

	ts->readLine();
	t=ts->readLine();

	if(version>3) {
		family=ts->readLine();
		*ts>>pointsize>>weight>>italic;
	}
	else {
		*ts>>family>>pointsize>>weight>>italic;
	}

	f=QFont(family,pointsize,weight,italic);

	kdDebug()<<"Label : "<<t<<endl;
	kdDebug()<<"(family/pointsize/weight/italic) : "<<family<<' '<<pointsize<<' '<<weight<<' '<<italic<<endl;

	if (version > 3) {
		*ts>>color;
		c=color;
		*ts>>tmpx>>tmpy;
		x=tmpx;
		y=tmpy;
	}
	if (version > 8) {
		*ts>>tmp;
		boxed = (bool)tmp;
	}
	if (version > 16)
		*ts>>rotation;
	if (version > 20) {
		*ts>>tmp;
		is_texlabel = (bool)tmp;
	}
} 

void Label::draw(Worksheet *ws, QPainter *p,Point pos,Point size,int w, int h,double phi) {
	if(is_texlabel) {
#if KDE_VERSION > 0x030104
		KTempDir *tmpdir = new KTempDir();
		QString dirname = tmpdir->name();        
#else
		QString dirname("/tmp/LabPlot-texvc");
		mkdir(dirname.latin1(),S_IRWXU);
#endif		
		KProcess *proc = new KProcess;
		*proc << "texvc";
		*proc << "/tmp"<<dirname<<t;
		if( proc->start(KProcess::Block) == false) {
			kdDebug()<<"COULD NOT FIND texvc! Gving up."<<endl;
			KMessageBox::error((QWidget *)ws,i18n("Could not find texvc! Falling back to normal label."));
			is_texlabel = false;
		}
		else {
			// take resulting image and show it
			QDir d(dirname);
			QString filename = dirname+QString(d[2]);
			QImage *image = new QImage(filename);
 			if(!image->isNull()) {
//				kdDebug()<<"\n	drawing TeX image file "<<filename<<endl;
				p->save();
				p->translate((pos.X()+x*size.X())*w,(pos.Y()+y*size.Y())*h);
				// phi : normal angle, rotation : additional rotation
				p->rotate(phi+rotation);
				if (boxed) {
					p->setPen(QColor("black"));
					p->drawRect(-1,-1,image->width()+2,image->height()+2);
				}
				p->drawImage(0,0,*image);
				p->restore();
			}
#if KDE_VERSION > 0x030104
			tmpdir->unlink();
#else
		rmdir(dirname.latin1());
#endif		
			return;
		}
	}
	
	// resize font with plot size
	QFont tmp = f;
	int tmpsize = f.pointSize();
	tmp.setPointSize((int)(size.X()*tmpsize));
	richtext = new QSimpleRichText(t,tmp);
	richtext->setWidth(p,500);
	
	p->save();
	p->translate((pos.X()+x*size.X())*w,(pos.Y()+y*size.Y())*h);
	// phi : normal angle, rotation : additional rotation
	p->rotate(phi+rotation);
	
	if (boxed) {
		p->setPen(QColor("black"));
		p->drawRect(-5,0,richtext->widthUsed(),richtext->height());
	}
	richtext->draw(p,0,0,QRect(),QColorGroup());
	p->restore();
}

//! return true if mouse inside (x0,y0)
bool Label::inside(int x0, int y0, Point pos, Point size, int w, int h) {
	int x1 = (int)(w*(pos.X()+size.X()*x));		// left
	int x2 = (int)(x1+richtext->widthUsed());	// right
	int y1 = (int)(h*(pos.Y()+size.Y()*y));		// top
	int y2 = (int)(y1+richtext->height());		// botton
	
	if (x0>x1 && x0<x2 && y0>y1 && y0<y2 )
		return true;
	return false;
}

bool Label::insideY(int x0, int y0, Point pos, Point size, int w, int h) {
	int x1 = (int)(w*(pos.X()+size.X()*x));		// left
	int x2 = (int)(x1+richtext->widthUsed());	// right
	int y2 = (int)(h*(pos.Y()+size.Y()*y));		// top
	int y1 = (int)(y2-richtext->widthUsed());		// botton

	//kdDebug()<<"Label::insideY()  X/Y    X1/X2 | Y1/Y2"<<endl;
	//kdDebug()<<"       "<<x0<<' '<<y0<<"   "<<x1<<'/'<<x2<<" | "<<y1<<'/'<<y2<<endl;
	
	if (x0>x1 && x0<x2 && y0>y1 && y0<y2 )
		return true;
	return false;
}

bool Label::insideZ(int x0, int y0, Point pos, Point size, int w, int h) {
	int x1 = (int)(w*(pos.X()+size.X()*x)-richtext->height());
	int x2 = (int)(w*(pos.X()+size.X()*x)+richtext->width());
	int y1 = (int)(h*(pos.Y()+size.Y()*y)-richtext->height());
	int y2 = (int)(h*(pos.Y()+size.Y()*y)+richtext->width());
	
	if (x0>x1 && x0<x2 && y0>y1 && y0<y2 )
		return true;
	return false;
}
