//LabPlot : LabPlotDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <math.h>
#include <qlabel.h>
#include <qhbox.h>
#include <qfontdialog.h>
#include <klocale.h>
#include "LabPlotDialog.h"

#ifdef HAVE_JASPER
#include <jasper/jas_config.h>
#endif

#include <audiofile.h>

#ifdef HAVE_GSL
#include <gsl/gsl_version.h>
#endif

#ifdef HAVE_FFTW_CONFIG
#include <fftw-config.h>
#endif

#ifdef HAVE_MAGICK
#include <magick/api.h>
#include <magick/version.h>
#endif

#ifdef HAVE_QSA
#include <qsaglobal.h>
#endif

#ifdef HAVE_CDF_CONFIG
#include <cdfrev.h>
#endif

LabPlotDialog::LabPlotDialog(MainWin *mw,const char *name)
	: Dialog(mw, name)
{
	setCaption(i18n("LabPlot")+i18n(" : ")+QString(name));
	
	QLabel *tmp;
	QString s("no");

	// TODO : get more versions of libraries
	// TODO : COPYRIGHT infos
	
	// LabPlot
	QHBox *hb = new QHBox(vbox);
	new QLabel(i18n("Version : "),hb);
	tmp = new QLabel(QString(LVERSION),hb);
	tmp->setAlignment(Qt::AlignRight);
	hb = new QHBox(vbox);
	new QLabel(i18n("Project Version : "),hb);
	tmp = new QLabel(QString::number(PROJECT_VERSION),hb);
	tmp->setAlignment(Qt::AlignRight);

	// gsl
	hb = new QHBox(vbox);
	new QLabel(i18n("GNU Scientific Library (GSL) : "),hb);
#ifdef HAVE_GSL
	s= GSL_VERSION;
#endif
	tmp = new QLabel(s,hb);
	tmp->setAlignment(Qt::AlignRight);
	
	// fftw
	hb = new QHBox(vbox);
	new QLabel(i18n("FFTW 3 : "),hb);
	s = "no";
#ifdef HAVE_FFTW3
	s= "yes";
#endif
	tmp = new QLabel(s,hb);
	tmp->setAlignment(Qt::AlignRight);
	hb = new QHBox(vbox);
	new QLabel(i18n("FFTW : "),hb);
#ifdef HAVE_FFTW_CONFIG
	s=FFTW_VERSION;
#elif defined(HAVE_FFTW3)
	s="unused";
#elif defined(HAVE_FFTW)
	s="unknown";
#else
	s="no";
#endif
	tmp = new QLabel(s,hb);
	tmp->setAlignment(Qt::AlignRight);

	// pstoedit
	hb = new QHBox(vbox);
	new QLabel(i18n("pstoedit : "),hb);
	s = "no";
#ifdef HAVE_PSTOEDIT
	s= "yes";
#endif
	tmp = new QLabel(s,hb);
	tmp->setAlignment(Qt::AlignRight);
	
	// texvc
	hb = new QHBox(vbox);
	new QLabel(i18n("TeX support (texvc) : "),hb);
	s= "yes";
	tmp = new QLabel(s,hb);
	tmp->setAlignment(Qt::AlignRight);
	
	// ImageMagick
	hb = new QHBox(vbox);
	new QLabel(i18n("ImageMagick : "),hb);
	s = "no";
#ifdef HAVE_MAGICK
	s= MagickLibVersionText;
#endif
	tmp = new QLabel(s,hb);
	tmp->setAlignment(Qt::AlignRight);
	
	// Jasper
	hb = new QHBox(vbox);
	new QLabel(i18n("JasPer library : "),hb);
	s = "no";
#ifdef HAVE_JASPER
	s = JAS_VERSION;
#endif
	tmp = new QLabel(s,hb);
	tmp->setAlignment(Qt::AlignRight);
	
	// qsa
	hb = new QHBox(vbox);
	new QLabel(i18n("Qt Script for Applications (QSA) : "),hb);
	s = "no";
#ifdef HAVE_QSA
	s= QSA_VERSION_STRING;
#endif
	tmp = new QLabel(s,hb);
	tmp->setAlignment(Qt::AlignRight);
	
	// CDF
	hb = new QHBox(vbox);
	new QLabel(i18n("Common Data Form library (CDF) : "),hb);
	s = "no";
#ifdef HAVE_CDF_CONFIG
	s = QString::number(CDF_LIBRARY_VERSION)+'.'+QString::number(CDF_LIBRARY_RELEASE)+'.'+ 
		QString::number(CDF_LIBRARY_INCREMENT);
#elif defined(HAVE_CDF)
	s = "yes";
#endif
	tmp = new QLabel(s,hb);
	tmp->setAlignment(Qt::AlignRight);
	
	// netCDF
	hb = new QHBox(vbox);
	new QLabel(i18n("netCDF : "),hb);
	tmp = new QLabel("yes",hb);
	tmp->setAlignment(Qt::AlignRight);
	
	// audiofile
	hb = new QHBox(vbox);
	new QLabel(i18n("audiofile library : "),hb);
	s=QString::number(LIBAUDIOFILE_MAJOR_VERSION)+'.'+QString::number(LIBAUDIOFILE_MINOR_VERSION);
#ifdef LIBAUDIOFILE_MICRO_VERSION
        s += '.'+QString::number(LIBAUDIOFILE_MICRO_VERSION);
#endif
	tmp = new QLabel(s,hb);
	tmp->setAlignment(Qt::AlignRight);
	
	QObject::connect(ok,SIGNAL(clicked()),SLOT(accept()));
	apply->hide();
	
	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}
