//LabPlot : LImage.cc

#include <iostream>
#include <qimage.h>
#include <kmessagebox.h>
#include <kdebug.h>
#include "LImage.h"

using namespace std;

LImage::LImage(Point p,QString n, double s, double a) {
	pos = p;
	name = n;
	scale = s;
	angle = a;
}

QStringList LImage::Info() {
	QStringList s;

	if(name.length()==0)
		return s;

	s << QString::number(pos.X())+"/"+QString::number(pos.Y());
	s << name;
	s << QString::number(scale);
	s << QString::number(angle);

	return s;
}

// draw the image on the worksheet
void LImage::draw(QPainter *p, double X, double Y) {
	//kdDebug()<<"DRAW Image \n";

	if (name.length()>0) {
		int x = (int) (pos.X()*X);
		int y = (int) (pos.Y()*Y);
		QImage *image = new QImage(name);
		if (!image) { 
			kdDebug()<<"Error opening image !"<<endl;
		}
		else {
			QImage tmpimage = image->smoothScale((int)(image->width()*scale),
				(int)(image->height()*scale),QImage::ScaleMin);
			p->translate(x,y);
			p->rotate(angle);
			p->drawImage(0,0,tmpimage);
			p->rotate(-angle);
			p->translate(-x,-y);
		}
	}
}

// save
void LImage::save(QTextStream *t) {
	*t<<pos.X()<<' '<<pos.Y()<<endl;
	*t<<name<<endl;
	*t<<scale<<' '<<angle<<endl;
}

// open
void LImage::open(QTextStream *t,int version) {
	kdDebug()<<"LImage::open() : "<<version<<endl;
	double x,y;
	
	*t>>x>>y;
	pos.setPoint(x,y);
	t->readLine();
	name=t->readLine();
	*t>>scale>>angle;

	kdDebug()<<"X/Y :"<<x<<' '<<y<<endl;
	kdDebug()<<"IMAGE :"<<name<<' '<<scale<<' '<<angle<<endl;
}

bool LImage::inside(int x, int y, int w, int h) {
	if(name.length() == 0)
		return false;
		
	QImage *image = new QImage(name);
	
	if (x>pos.X()*w && x<pos.X()*w+image->width()*scale &&
		y>pos.Y()*h && y<pos.Y()*h+image->height()*scale )
		return true;

	return false;
}
