//LabPlot : ImportDialog.h

#ifndef IMPORTDIALOG_H
#define IMPORTDIALOG_H

#include "FilterKexiDB.h"
#include "Dialog.h"

/*! Main class for Data Import*/
class ImportDialog: public Dialog
{
	Q_OBJECT
public:
	ImportDialog(MainWin *mw, QString filename="", InputFilter filter=FUSER,const char *name=0);
private slots :	
	int apply_clicked();
	void wizardKexiDB(const QString &name);
	void finishKexiDB();
public slots :
	void Apply() { if (!apply_clicked()) accept(); }
private:
	FilterKexiDB *kexi;					//KexiDB
	KComboBox *driver, *databases, *tables;
	QLabel *connectionlabel, *tablelabel;
	KLineEdit *host, *user, *password;
};
#endif //IMPORTDIALOG_H
