//LabPlot : ImageMagickDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <math.h>
#include <qlabel.h>
#include <qhbox.h>
#include <qfiledialog.h>
#include <klocale.h>
#include <ktempfile.h>
#include <kprocess.h>
#include <kmessagebox.h>
#include "ImageMagickDialog.h"

using namespace std;

#ifdef HAVE_MAGICK
#include <list>
#include "Magick++.h"
using namespace Magick;
#endif

ImageMagickDialog::ImageMagickDialog(MainWin *mw, QString fn, int f, int sx, int sy, double r, const char *name)
	: Dialog(mw, name)
{
	setCaption(i18n("Export via ImageMagick"));
	kdDebug()<<"ImageMagick dialog"<<endl;

	QHBox *hb = new QHBox(vbox);
	new QLabel(i18n("Export to : "),hb);
	format = new KComboBox(hb);
	QObject::connect(format,SIGNAL(activated (int)),SLOT(updateFilename(int)));

#ifdef HAVE_MAGICK
	kdDebug()<<"have ImageMagick"<<endl;
        QStringList formatlist;

	try {
		list<CoderInfo> coderList;
		coderInfoList( &coderList,CoderInfo::AnyMatch,CoderInfo::TrueMatch,CoderInfo::AnyMatch);
		list<CoderInfo>::iterator entry = coderList.begin();
		while( entry != coderList.end() )  {
			formatlist<<QString(entry->name().c_str())+QString(" : (")+QString(entry->description().c_str())+')';
			formats<<QString(entry->name().c_str());
				//kdDebug()<<QString(entry->name().c_str())+" : ("+QString(entry->description().c_str())+")"<<endl;
			entry++;
		}
		format->insertStringList(formatlist);
		format->setCurrentItem(f);
	}
	catch (Exception &e) {
		kdDebug()<<"Image coderLIst : Caught Exception "<< e.what() << endl;
		return;
	}
#endif
	hb = new QHBox(vbox);
	new QLabel(i18n("File : "),hb);
	filele = new KLineEdit(fn,hb);
	KPushButton *newFile = new KPushButton(i18n("Browse..."),hb);
	QObject::connect(newFile,SIGNAL(clicked()),SLOT(selectFile()));

	hb = new QHBox(vbox);
        new QLabel(i18n("Size : "),hb);
        xle = new KLineEdit(QString::number(sx),hb);
	xle->setValidator(new QIntValidator(xle));
        new QLabel(QString(" x "),hb);
        yle = new KLineEdit(QString::number(sy),hb);
	yle->setValidator(new QIntValidator(yle));
        new QLabel(i18n(" Rotation : "),hb);
        rotle = new KLineEdit(QString::number(r),hb);
	rotle->setValidator(new QDoubleValidator(-360,360,2,rotle));

	QObject::connect(ok,SIGNAL(clicked()),SLOT(Apply()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));

	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

//! slot for "format" combobox
void ImageMagickDialog::updateFilename(int index) {
	QString filename =  filele->text();
        filename.replace( QRegExp(QString("[.]+.*")), "." + formats[index].lower() );
        filele->setText(filename);
}

void ImageMagickDialog::selectFile() {
	QString filename = QFileDialog::getSaveFileName( QString::null, "*." + formats[format->currentItem()].lower(), this );
	if ( filename )
		filele->setText(filename);
	// change extension
	updateFilename(format->currentItem());
}

void ImageMagickDialog::apply_clicked() {
	// check if file exists
	if ( QFile::exists(filele->text()) ) {
		int answer = KMessageBox::warningYesNoCancel( this, 
			i18n( "Overwrite\n\'%1\'?" ).arg( filele->text() ), i18n("Export via ImageMagick"));
		if (answer != KMessageBox::Yes)
			return;
	}

	KTempFile *tmpfile = new KTempFile(QString::null,".ps");
	tmpfile->setAutoDelete(true);
	QString filename = tmpfile->name();
	if (mw)  mw->activeWorksheet()->Print(filename);

#ifdef HAVE_MAGICK
	kdDebug()<<"exporting via ImageMagick to "<<formats[format->currentItem()]<<endl;
	Magick::Image image;
	kdDebug()<<"read postscript file"<<endl;
	image.read(filename.latin1());
	Geometry geometry(xle->text().toInt(),yle->text().toInt());
	kdDebug()<<"apply zoom"<<endl;
	image.zoom(geometry);
	kdDebug()<<"rotate"<<endl;
	image.rotate(rotle->text().toDouble());
	image.magick(formats[format->currentItem()].latin1());
	kdDebug()<<"writing "<<filele->text()<<endl;
	try {
		image.write(filele->text().latin1());
	}
	catch(Exception &e) {
		kdDebug() << "Caught exception: " << e.what() << endl;
		KMessageBox::warningContinueCancel(this,i18n("Sorry. ImageMagick couldn't save image!"));
	}
#else
	KMessageBox::warningContinueCancel(this,i18n("Sorry. Your Installation doesn't support ImageMagick!"));
#endif
	kdDebug()<<"export OK"<<endl;
	tmpfile->close();
}
