//LabPlot : GraphM.cc

#include <stdlib.h>
#include <iostream>
#include <qimage.h>
#include <kdebug.h>
#include "GraphM.h"

using namespace std;

GraphM::GraphM(QString n, QString l, LRange r[3], LSource src, PType t, Style *st,
		Symbol *sy, double *a,int dimx, int dimy, bool s)
	: Graph(n,l,src,t,st,sy,dimx*dimy,s)
{
	range = new LRange[3];

	if (r) {
		kdDebug()<<"Range : "<<r[0].rMin()<<' '<<r[0].rMax()<<endl;
		kdDebug()<<"Range : "<<r[1].rMin()<<' '<<r[1].rMax()<<endl;
		kdDebug()<<"Range : "<<r[2].rMin()<<' '<<r[2].rMax()<<endl;
	}
	//kdDebug()<<"NX = "<<dimx<<" / NY = "<<dimy<<endl;

	if(r) {
		range[0].setMin(r[0].rMin());
		range[0].setMax(r[0].rMax());
		range[1].setMin(r[1].rMin());
		range[1].setMax(r[1].rMax());
		range[2].setMin(r[2].rMin());
		range[2].setMax(r[2].rMax());
	}

	nx = dimx;	// xrange
	ny = dimy;	// yrange

	array = new double[nx*ny];
	for (int i=0;i<nx;i++)
		for (int j=0;j<ny;j++)
			array[j+i*ny] = a[j+i*ny];

	/*for (int i=0;i<nx;i++) {
		for (int j=0;j<ny;j++) {
			kdDebug()<<' '<<array[j+ny*i]<<endl;
		}
		kdDebug()<<endl;
	}*/
}

void GraphM::save(QTextStream *t, QProgressDialog *progress) {
	saveGraph(t);
	*t<<nx<<' '<<ny<<endl;
       	*t<<range[0].rMin()<<' '<<range[0].rMax()<<endl;
       	*t<<range[1].rMin()<<' '<<range[1].rMax()<<endl;
       	*t<<range[2].rMin()<<' '<<range[2].rMax()<<endl;
	*t<<type<<' ';
	style->save(t);
	symbol->save(t);

	//dump data
	progress->setTotalSteps(nx);
	for (int i=0;i< nx;i++) {
		if(i%100 == 0) progress->setProgress(i);
		for(int j=0;j<ny;j++) {
			*t<<array[j+i*ny]<<' ';
		}
		*t<<endl;
	}
	progress->cancel();
}

void GraphM::open(QTextStream *t, int version, QProgressDialog *progress) {
	openGraph(t,version);
	
	*t>>nx>>ny;

	double zmin, zmax;
	*t>>zmin>>zmax;
	range[0].setMin(zmin); range[0].setMax(zmax);
	*t>>zmin>>zmax;
	range[1].setMin(zmin); range[1].setMax(zmax);
	*t>>zmin>>zmax;
	range[2].setMin(zmin); range[2].setMax(zmax);

	type = (PType) style->open(t,version);
	symbol->open(t,version);

	// read data
	array = new double[nx*ny];
	t->readLine();
	
	progress->setTotalSteps(number);
	for (int i=0;i<nx;i++) {
		if(i%100 == 0) progress->setProgress(i);
		QString line = t->readLine();

		//kdDebug()<<"line "<<i<<" : "<<line<<endl;

                line = line.simplifyWhiteSpace();
        	QStringList oneline = QStringList::split(QChar(' '), line );

		int j=0;
		for ( QStringList::Iterator it = oneline.begin(); it != oneline.end(); ++it ) {
			double z = (*it).toDouble();
			if (j==0 && i==0) {
				zmin=zmax=z;
			}
			else {
				z<zmin?zmin=z:0;
				z>zmax?zmax=z:0;
			}
			array[j+ny*i]=z;
			j++;
			//kdDebug()<<"array["<<j+ny*i<<"] = "<<array[j+ny*i]<<endl;
		}
	}
	progress->cancel();
}

QStringList GraphM::Info(){
	kdDebug()<<"GraphM:Info()"<<endl;

	QStringList s;
	QString t;
	if(type==P2D)
		t=i18n("2D");
	else if (type==PSURFACE)
		t=i18n("Surface");
	else if (type==P3D)
		t=i18n("3D");
	else if (type==PQWT3D)
		t=i18n("QWT 3D");

	QString sh=i18n("NO");
	if (shown)
		sh=i18n("YES");

	s << name << t << sh;
	s << QString::number(nx) << QString::number(ny);
	s << QString::number(range[0].rMin())+ " .. " + QString::number(range[0].rMax());
	s << QString::number(range[1].rMin())+ " .. " + QString::number(range[1].rMax());
	s << QString::number(range[2].rMin())+ " .. " + QString::number(range[2].rMax());
	
	return s;
}

//! return matrix data as pixmap
QPixmap GraphM::Pixmap() {
	kdDebug()<<"GraphM:Pixmap()"<<endl;
	QPixmap pm(nx,ny);
	
	// 8 bit
	QImage *image = new QImage(nx,ny,8,256);
	for (int i=0;i<256;i++) {
		QColor c(i,i,i);
		image->setColor (i, c.rgb() );
	}
	
	for (int i=0;i<ny;i++) {
		for (int j=0;j<nx;j++) {
			unsigned int value =
				(int)((array[j+nx*i]-range[2].rMin())/(range[2].rMax()-range[2].rMin())*255.0);
			image->setPixel(j,i,value);
		}
	}
	pm.convertFromImage(*image);
	free(image);

	return pm;
}

void GraphM::setPixmap(QPixmap pm) {
	kdDebug()<<"GraphM:setPixmap()"<<endl;
	QImage image = pm.convertToImage();
	
	nx = pm.width();
	ny = pm.height();

	free(array);
	
	// set matrix data from pixmap
	array= new double[nx*ny];
	for (int i=0;i<ny;i++) {
		for (int j=0;j<nx;j++) {
			array[j+nx*i] = (double) qGray(image.pixel(j,i));
		}
	}
}
