//LabPlot : GraphListDialog.cc

#include "GraphListDialog.h"
#include "DataDialog.h"
#include "FunctionDialog.h"

GraphListDialog::GraphListDialog(MainWin *mw,const char *name)
	: ListDialog(mw, name)
{
	setCaption(i18n("Graph List Dialog"));

	plot = p->getPlot(p->API());

	//dont forget to add options in list dialog menu
	QTabWidget *tw = new QTabWidget(vbox);
	QVBox *tabmani = new QVBox(tw);
	
	QHBox *hb = new QHBox(tabmani);
	KPushButton *del = new KPushButton(i18n("Delete Graph"),hb);
	QObject::connect(del,SIGNAL(clicked()),SLOT(deleteGraph()));
	KPushButton *ch = new KPushButton(i18n("Change Graph"),hb);
	QObject::connect(ch,SIGNAL(clicked()),SLOT(changeGraph()));	
	KPushButton *clone = new KPushButton(i18n("Clone Graph"),hb);
	QObject::connect(clone,SIGNAL(clicked()),SLOT(Clone()));
	
	hb = new QHBox(tabmani);
	KPushButton *toggleshown = new KPushButton(i18n("Show/Hide"),hb);
	QObject::connect(toggleshown,SIGNAL(clicked()),SLOT(toggleShown()));
	KPushButton *addData = new KPushButton(i18n("Add Datafile"),hb);
	QObject::connect(addData,SIGNAL(clicked()),SLOT(newData()));
	KPushButton *addFunction = new KPushButton(i18n("Add Function"),hb);
	QObject::connect(addFunction,SIGNAL(clicked()),SLOT(newFunction()));

	QVBox *tabedit = new QVBox(tw);
	hb = new QHBox(tabedit);
	KPushButton *edit = new KPushButton(i18n("Edit Data"),hb);
	QObject::connect(edit,SIGNAL(clicked()),SLOT(editGraph()));
	KPushButton *spreadsheet = new KPushButton(i18n("Open in Spreadsheet"),hb);
	QObject::connect(spreadsheet,SIGNAL(clicked()),SLOT(openSpreadsheet()));
	hb = new QHBox(tabedit);
	KPushButton *dump = new KPushButton(i18n("Export Data"),hb);
	QObject::connect(dump,SIGNAL(clicked()),SLOT(dumpGraph()));
	KPushButton *info = new KPushButton(i18n("Data Statistics"),hb);
	QObject::connect(info,SIGNAL(clicked()),SLOT(statGraph()));

	QVBox *tabstyle = new QVBox(tw);
	hb = new QHBox(tabstyle);
	KPushButton *setdiffcolor = new KPushButton(i18n("different colors"),hb);
	QObject::connect(setdiffcolor,SIGNAL(clicked()),SLOT(setDifferentColor()));
	KPushButton *setdiffsymbol = new KPushButton(i18n("different symbols"),hb);
	QObject::connect(setdiffsymbol,SIGNAL(clicked()),SLOT(setDifferentSymbol()));
	hb = new QHBox(tabstyle);
	KPushButton *setdiffwidth = new KPushButton(i18n("different line widths"),hb);
	QObject::connect(setdiffwidth,SIGNAL(clicked()),SLOT(setDifferentWidth()));
	KPushButton *setdiffstyle = new KPushButton(i18n("different line styles"),hb);
	QObject::connect(setdiffstyle,SIGNAL(clicked()),SLOT(setDifferentStyle()));
	KPushButton *setbw = new KPushButton(i18n("black && white"),hb);
	QObject::connect(setbw,SIGNAL(clicked()),SLOT(setBlackWhite()));
	
	QVBox *tabmask = new QVBox(tw);
	hb = new QHBox(tabmask);
	KPushButton *togglemask = new KPushButton(i18n("Toggle Masking"),hb);
	QObject::connect(togglemask,SIGNAL(clicked()),SLOT(toggleMask()));
	KPushButton *unmask = new KPushButton(i18n("Unmask"),hb);
	QObject::connect(unmask,SIGNAL(clicked()),SLOT(unMask()));
	hb = new QHBox(tabmask);
	KPushButton *nthmask = new KPushButton(i18n("Mask every n-th row"),hb);
	QObject::connect(nthmask,SIGNAL(clicked()),SLOT(nthMask()));
	KPushButton *firstmask = new KPushButton(i18n("Mask all but n-th row"),hb);
	QObject::connect(firstmask,SIGNAL(clicked()),SLOT(firstMask()));
	
	tw->addTab(tabmani,i18n("Manipulation"));
	tw->addTab(tabedit,i18n("Edit"));
	tw->addTab(tabstyle,i18n("Set Style"));
	tw->addTab(tabmask,i18n("Masking"));
	
	QObject::connect(ok,SIGNAL(clicked()),SLOT(accept()));
	apply->hide();
	cancel->hide();
	
	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

void GraphListDialog::newFunction() {
	// no pie/ternary function ?
	if(type == P2D || type == PSURFACE || type == P3D || type == PPOLAR)
		(new FunctionDialog(mw,0,this,-1,plot->Type()))->show();
}

void GraphListDialog::newData() {
	(new DataDialog(mw,0,this,-1,plot->Type()))->show();
}
