//LabPlot : FunctionDialog.h

#ifndef FUNCTIONDIALOG_H
#define FUNCTIONDIALOG_H

#include <klineedit.h>
#include <qtoolbutton.h>
#include <qcheckbox.h>
#include <qcolor.h>
#include "Dialog.h"
#include "Worksheet.h"
#include "GraphListDialog.h"
#include "Graph2D.h"

class FunctionDialog: public Dialog
{
	Q_OBJECT
public:
	FunctionDialog(MainWin *mw, const char *name, ListDialog *l, int item, PType newtype);
public slots:
	int addFunction();	
	void updateLabel() { labelle->setText(funle->text()); }

	void setFunction(QString fun) { funle->setText(fun); }			//!< set function to create 
	void recreate(bool b=true) { reread->setChecked(b); }		//!< create function new ?
	void setLabel(QString l=0) {			//!< set label of function
		if(l==0)
			updateLabel();
		else
			labelle->setText(l); 
	}		
	void setRange(double a, double b) { xmin->setText(QString::number(a)); xmax->setText(QString::number(b)); }
														//!< set X range of function
	void setYRange(double a, double b) { ymin->setText(QString::number(a)); ymax->setText(QString::number(b)); }
														//!< set Y range of function
	void setPoints(int nr) { nx->setText(QString::number(nr)); }		//!< set number of X points for function
	void setYPoints(int nr) { ny->setText(QString::number(nr)); }		//!< set number of Y points for function
	
	int Apply() { return apply_clicked(); }
private slots :
	int apply_clicked();
	void ok_clicked() { if (!apply_clicked()) accept(); }
private:
	void findPlot();
	KLineEdit *funle, *labelle, *xmin, *xmax, *ymin, *ymax, *nx, *ny;
	QCheckBox *reread;
	ListDialog *l;
	int item;
	PType type;
	Graph *graph;			// Graph
};
#endif //FUNCTIONDIALOG_H
