//LabPlot : FunctionDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <iostream>

#ifdef USE_SOLARIS
#include <ieeefp.h>
#endif

#include <qlabel.h>
#include <qhbox.h>
#include <qcolordialog.h>
#include <qprogressdialog.h>
#include <qtabwidget.h>
#include <klocale.h>
#include <kdebug.h>
#include <kmessagebox.h>
#include "FunctionDialog.h"
#include "Plot2DSurface.h"
#include "PlotQWT3D.h"
#include "defs.h"

#ifdef HAVE_GSL
#include <gsl/gsl_math.h>
#endif

using namespace std;

/*! newtype -> new 3D Plot type*/
FunctionDialog::FunctionDialog(MainWin *mw, const char *name, ListDialog *l, int item, PType newtype)
	: Dialog(mw, name), l(l), item(item)
{
	kdDebug()<<"FunctionDialog()"<<endl;
	Plot *plot=0;
	if(p!=0)
	 	plot = p->getPlot(p->API());
	// why's that ?
/*	if (plot != 0)
		type = plot->Type();
	else
*/
		type = newtype;

	kdDebug()<<"FunctionDialog : plot type = "<<type<<endl;

	QString caption;
	if (type == P2D)
		caption=i18n("2D Function Dialog");
	else if (type == P3D)
		caption=i18n("3D Function Dialog");
	else if (type == PQWT3D)
		caption=i18n("3D QWT Function Dialog");
	else if (type == PSURFACE)
		caption=i18n("2D Surface Function Dialog");
	else if (type == PPOLAR)
		caption=i18n("2D Polar Function Dialog");
	caption += i18n(" : ")+QString(name);
	setCaption(caption);

	Style *style=0;
	Symbol *symbol=0;
	LRange rx, ry;
	GRAPHType st = GRAPH2D;
	int nrx = 0, nry = 0;

	if(type == PPOLAR) {
		if(symbol) symbol->setType(SCROSS);
	}

	kdDebug()<<"get values"<<endl;
	// default style and symbol for polar plots
	if (item == -1) {	// new graph
		graph = 0;
	}
	else {
		GraphList *gl = plot->getGraphList();
		graph = gl->getGraph(item);
		st = gl->getStruct(item);

		style = graph->getStyle();
		symbol = graph->getSymbol();
		kdDebug()<<"Struct : "<<s<<endl;

		if (st == GRAPH2D) {
			Graph2D *g = gl->getGraph2D(item);
			rx = g->Range(0);
			nrx = graph->Number();
		}
		else if (st == GRAPH3D) {
			Graph3D *g = gl->getGraph3D(item);
			rx = g->Range(0);
			ry = g->Range(1);
			nrx = g->NX();
			nry = g->NY();
		}
		else if (st == GRAPHM) {
			GraphM *g = gl->getGraphM(item);
			rx = g->Range(0);
			ry = g->Range(1);
			nrx = g->NX();
			nry = g->NY();
		}
	}

	kdDebug()<<"build widgets"<<endl;
	QTabWidget *tw = new QTabWidget(vbox);
	QVBox *tab1 = new QVBox(tw);

	QString fun=mw->last_2dfunction;
	if (type == P3D || type == PSURFACE || type == PQWT3D)
		fun = mw->last_3dfunction;
	if (graph != 0) fun = graph->Name();
	new QLabel(i18n("Function :"),tab1);
	funle = new KLineEdit(fun,tab1);

	QHBox *hb = new QHBox(tab1);
	reread = new QCheckBox(i18n("Recreate Function"),hb);
	reread->hide();
	if (graph !=0) {	//change
		if(graph->Source() == SFUNCTION) {
			reread->show();
			reread->setChecked(true);
		}
	} 
	else				//new function
		reread->setChecked(true);

	QString label = fun;
	if (graph != 0) label = graph->Label();
	new QLabel(i18n("Label :"),tab1);
	hb = new QHBox(tab1);
	labelle = new KLineEdit(label,hb);
	KPushButton *setLabel = new KPushButton(i18n("Update Label"),hb);
	QObject::connect(setLabel,SIGNAL(clicked()),SLOT(updateLabel()));

	new QLabel(i18n("Range :"),tab1);
	hb = new QHBox(tab1);
	new QLabel(QString("x = "),hb);

	double x1 = mw->last_xmin, x2 = mw->last_xmax;
	if (graph != 0) {
		x1 = rx.rMin();
		x2 = rx.rMax();
	}
	xmin = new KLineEdit(QString::number(x1),hb);
	new QLabel(QString(" .. "),hb);
	xmax = new KLineEdit(QString::number(x2),hb);
	if (type == P3D || type == PSURFACE || type == PQWT3D) {
		new QLabel(QString(" y = "),hb);

		double y1 = mw->last_ymin, y2 = mw->last_ymax;
		if (graph != 0) {
			x1 = rx.rMin();
			x2 = rx.rMax();
			y1 = ry.rMin();
			y2 = ry.rMax();
		}
		ymin = new KLineEdit(QString::number(y1),hb);
		new QLabel(QString(" .. "),hb);
		ymax = new KLineEdit(QString::number(y2),hb);
	}
	new QLabel(i18n("Number of Points :"),tab1);
	hb = new QHBox(tab1);
	new QLabel(QString("NX = "),hb);
	if(type == P2D || type == PPOLAR) {
		if (graph == 0) nrx = mw->last_nrpointsx;
		nx = new KLineEdit(QString::number(nrx),hb);
		nx->setValidator(new QIntValidator(nx));
	}
	else if (type == P3D || type == PSURFACE || type == PQWT3D){
		if (graph == 0) {
			nrx = mw->last_nrpointsx;
			nry = mw->last_nrpointsy;
		}
		nx = new KLineEdit(QString::number(nrx),hb);
		nx->setValidator(new QIntValidator(nx));
		new QLabel(QString("NY = "),hb);
		ny = new KLineEdit(QString::number(nry),hb);
		ny->setValidator(new QIntValidator(ny));
	}

	tw->addTab(tab1,i18n("Parameter"));

	kdDebug()<<"build style tab"<<endl;
	QVBox *styletab, *annotatetab;
	if(type == PQWT3D) {
		// TODO
	}
	if (type == PSURFACE) {
		styletab = surfaceStyle(tw,item==-1?true:false);
		tw->addTab(styletab,i18n("Style"));
	}
	else {
		styletab = simpleStyle(tw, style, symbol);
		annotatetab = annotateValuesTab(tw,graph);
		tw->addTab(styletab,i18n("Style"));
		tw->addTab(annotatetab,i18n("Annotate Values"));
	}
	
	kdDebug()<<"build destinations"<<endl;
	// result selection
	hb = new QHBox(vbox);
	new QLabel(i18n("add result to "),hb);
	sheetcb = new KComboBox(hb);
	QStringList wlist;
	QWidgetList list = mw->getWorkspace()->windowList();
	for(unsigned int i=0;i<list.count();i++)
		wlist << list.at(i)->caption();
	wlist<<i18n("new Worksheet")<<i18n("new Spreadsheet");
	sheetcb->insertStringList(wlist);
	sheetcb->setCurrentItem(0);
	
	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));

	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize((int)(1.5*minimumSize().width()),minimumSize().height());
	
	kdDebug()<<"FunctionDialog() DONE"<<endl;
}

// search for a usable plot; add worksheet if necessary
void FunctionDialog::findPlot() {
	kdDebug()<<"FunctionDialog::findPlot()"<<endl;
	int item = sheetcb->currentItem(), count = sheetcb->count();
	kdDebug()<<"	sheetcb->currentItem() = "<<item<<" of "<<count<<endl;

	if(item>=count-2)		// new sheet selected
		return;
	
	QWidgetList list = mw->getWorkspace()->windowList();
	p = (Worksheet *) list.at(item);
	if(p==0 || p->getWidgetType() != WWORKSHEET) {
		p = mw->activeWorksheet();
		return;
	}

	Plot *plot=0;
	if(p)
		plot = p->getPlot(p->API());

	if(plot && plot->Type() == PQWT3D || type == PQWT3D) {	// new worksheet if plot is qwt3d or type = qwt3d
		p = mw->newWorksheet();
		p->newPlot(type);
		plot = p->getPlot(p->API());
		sheetcb->setCurrentItem(count-2);		// set item to new worksheet
	}
	else if(item < count-2 && plot && plot->Type() != type)		// new plot if choosen of other type.
		p->newPlot(type);					// not if already new sheet selected
}

int FunctionDialog::apply_clicked() {
	kdDebug()<<"FunctionDialog::apply_clicked()"<<endl;

	findPlot();
	
	// add function
	QString label = labelle->text();
	int status=0;
	if (reread->isChecked())
		status = addFunction();
	else {
		if(type == PSURFACE) {
			if (p != 0) {
				Plot2DSurface *plot = (Plot2DSurface *)p->getPlot(p->API());

				if (plot != 0) {
					plot->enableDensity(dcb->isChecked());
					plot->enableContour(ccb->isChecked());
					plot->setNumber(numberle->text().toInt());
					plot->setPalette(pcb->currentItem());
					plot->setContourColor(contourcolor->color());
					plot->setColoredContour(coloredcb->isChecked());
					plot->setMesh(meshcb->isChecked());
					plot->setRelative(relativecb->isChecked());
					plot->setBrush(dbrushcb->currentItem());
					plot->setThreshold(thresholdle->text().toDouble());
				}
			}
		}
		else {
			Style *style = new Style(cb2->currentItem(),color->color(),filled->isChecked(),
				fcolor->color(),widthle->text().toInt(),
				pencb->currentItem(),brushcb->currentItem());
			style->setBoxWidth(boxwidthle->text().toInt());
			style->setAutoBoxWidth(autobox->isChecked());
			Symbol *symbol = new Symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->text().toInt(),
					(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());
			AnnotateValues av(typecb->currentItem(),positioncb->currentItem(),distancele->text().toInt());
			graph->setStyle(style);
			graph->setSymbol(symbol);
			graph->setAnnotateValues(av);
		}
		graph->setLabel(label);
	}

	if(l) l->updateList();
	if(p) p->updatePixmap();

	return status;
}

int FunctionDialog::addFunction() {
	kdDebug()<<"FunctionDialog::addFunction()"<<endl;
	QString fun = funle->text().lower();
	
	// save "last" values
	mw->last_nrpointsx = nx->text().toInt();
	mw->last_xmin = xmin->text().toDouble();
	mw->last_xmax = xmax->text().toDouble();
	if (type == P3D || type == PSURFACE || type == PQWT3D) {
		mw->last_3dfunction = fun;
		mw->last_nrpointsy = ny->text().toInt();
		mw->last_ymin = ymin->text().toDouble();
		mw->last_ymax = ymax->text().toDouble();
	}
	else
		mw->last_2dfunction = fun;

	QString label = labelle->text();
	int NX = (nx->text()).toInt();
	int NY = 0;
	if (type == P3D || type == PSURFACE || type == PQWT3D)
		NY = (ny->text()).toInt();

	QProgressDialog progress( i18n("Creating function ..."), i18n("Cancel"), NX,this, "progress", true );
	progress.setMinimumDuration(2000);
	if (type == P2D || type == PPOLAR) {
		Point *ptr = new Point[NX];

		double ymin=0, ymax=1;
		double xmi = parse((char *) (xmin->text()).latin1());
		double xma = parse((char *) (xmax->text()).latin1());
		for(int i = 0;i < NX;i++) {
			if(i%100 == 0) progress.setProgress( i );
    			qApp->processEvents();

			double x = (xma-xmi)*i/(double)(NX-1)+xmi;
			QString tmp(fun);
			if (tmp.length()==1) tmp += " ";		// "x"

			tmp = mw->parseExpression(tmp, x, 23);	// "x"
			
			double y = parse((char *) tmp.latin1());

			if(parse_errors()>0) {
				progress.cancel();
				KMessageBox::error(mw, i18n("Parse Error!\n Please check the given function."));
				return 1;
			}

			if (!finite(x))	x=0;
			if (!finite(y))	y=0;

			if (i == 0) ymin=ymax=y;
			y<ymin?ymin=y:0;
			y>ymax?ymax=y:0;

			ptr[i].setPoint(x,y);
			if ( progress.wasCancelled() )
        			return 1;
		}
		if(p!=0 && graph != 0)
			p->getPlot(p->API())->getGraphList()->delGraph(item);

		if(ymax-ymin == 0) {
			ymin -= 1;
			ymax += 1;
		}

		if(type == PPOLAR) {
			xmi = 0;
			xma = 2*M_PI;
		}
		
		LRange range[2];
		range[0] = LRange(xmi,xma);
		range[1] = LRange(ymin,ymax);
		Style *style = new Style(cb2->currentItem(),color->color(),filled->isChecked(),
			fcolor->color(),widthle->text().toInt(),
			pencb->currentItem(),brushcb->currentItem());
		style->setBoxWidth(boxwidthle->text().toInt());
		style->setAutoBoxWidth(autobox->isChecked());
		Symbol *symbol = new Symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->text().toInt(),
			(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());

		kdDebug()<<"	range[0]="<<range[0].rMin()<<","<<range[0].rMax()<<endl;
		kdDebug()<<"	range[1]="<<range[1].rMin()<<","<<range[1].rMax()<<endl;

		Graph2D *g = new Graph2D(fun,label,range,SFUNCTION,type,style,symbol,ptr,NX);
		
		AnnotateValues av(typecb->currentItem(),positioncb->currentItem(),distancele->text().toInt());
		g->setAnnotateValues(av);
		mw->addGraph2D(g,sheetcb->currentItem());
	}
	else if (type == PSURFACE || type == PQWT3D) {
		kdDebug()<<"	\"surface\" or \" qwt 3d \" selected"<<endl;
		kdDebug()<<"	NX = "<<NX<<"/ NY = "<<NY<<endl;

		double *a = new double[NY*NX];

		double xmi=0, xma=1, ymi=0, yma=1, zmin=0, zmax=1;
		xmi = parse((char *) (xmin->text()).latin1());
		xma = parse((char *) (xmax->text()).latin1());
		ymi = parse((char *) (ymin->text()).latin1());
		yma = parse((char *) (ymax->text()).latin1());
			
		for (int i=0;i<NY;i++) {
			if(i%10==0)progress.setProgress( i );
    			qApp->processEvents();
			QString tmp(fun);
			if (tmp.length()==1) tmp += " ";
			
			tmp = mw->parseExpression(tmp,(yma-ymi)*i/(double)(NY-1)+ymi,24);
			
			for (int j=0;j<NX;j++) {
				QString tmp2 = mw->parseExpression(tmp,(xma-xmi)*j/(double)(NX-1)+xmi,23);
				
				double z = parse((char *) tmp2.latin1());
			
				if(parse_errors()>0) {
					progress.cancel();
					KMessageBox::error(mw, i18n("Parse Error!\n Please check the given function."));
					return 1;
				}

				if (!finite(z)) z=0;

				//kdDebug()<<"z = "<<z<<" (i/j = "<<i<<'/'<<j<<")\n";

				if (i == 0 && j == 0) {
					zmin=z;
					zmax=z;
				}

				z<zmin?zmin=z:0;
				z>zmax?zmax=z:0;
				
				a[j+NX*i] = z;
			}
			if ( progress.wasCancelled() )
        			return 1;
		}

		if(p!=0 && type == PSURFACE) {
			Plot2DSurface *plot = (Plot2DSurface *)p->getPlot(p->API());

			// edit graph
			if(graph != 0)
				plot->getGraphList()->delGraph(item);

			if (plot != 0) {
				plot->enableDensity(dcb->isChecked());
				plot->enableContour(ccb->isChecked());
				plot->setNumber(numberle->text().toInt());
				plot->setPalette(pcb->currentItem());
				plot->setContourColor(contourcolor->color());
				plot->setColoredContour(coloredcb->isChecked());
				plot->setMesh(meshcb->isChecked());
				plot->setRelative(relativecb->isChecked());
				plot->setBrush(dbrushcb->currentItem());
				plot->setThreshold(thresholdle->text().toDouble());
			}
		}
		else if (type == PQWT3D) {
			kdDebug() << "\"qwt 3d \" selected"<<endl;
			// TODO
			//PlotQWT3D *plot = (PlotQWT3D *)p->getPlot(p->API());
		}

		if(zmax-zmin == 0) {
			zmin -= 1;
			zmax += 1;
		}

		LRange range[3];
		// old : used 0..NX,0..NY
		// new : use range
		range[0] = LRange(xmi,xma);
		range[1] = LRange(ymi,yma);
		range[2] = LRange(zmin,zmax);

		kdDebug()<<"zmin : "<<zmin<<"/ zmax : "<<zmax<<endl;
		kdDebug()<<"range : "<<range[0].rMin()<<' '<<range[0].rMax()<<endl;
		kdDebug()<<"range : "<<range[1].rMin()<<' '<<range[1].rMax()<<endl;
		kdDebug()<<"range : "<<range[2].rMin()<<' '<<range[2].rMax()<<endl;
		/*for(int i=0;i<NX;i++) {
			for(int j=0;j<NY;j++) {
				kdDebug()<<" ("<<j+NY*i<<')'<<a[j+NY*i]<<endl;
			}
			kdDebug()<<endl;
		}*/

		Style *style = new Style(0);
		Symbol *symbol = new Symbol(SNONE);
		GraphM *g = new GraphM(fun,label,range,SFUNCTION,type,style,symbol,a,NX,NY);
		mw->addGraphM(g,sheetcb->currentItem(),type);
	}
	else if (type == P3D) {
		kdDebug() << "\"3d\" selected"<<endl;

		Point3D *ptr = new Point3D[NX*NY];

		double xmi=(xmin->text()).toDouble(), xma=(xmax->text()).toDouble();
		double ymi=(ymin->text()).toDouble(), yma=(ymax->text()).toDouble();
		double zmin=0, zmax=1;
		for(int i = 0;i < NY;i++) {
			if(i%100==0)progress.setProgress( i );
    			qApp->processEvents();

			QString tmp(fun);
			if (tmp.length()==1) tmp += " ";
			
			double y = (yma-ymi)*i/(double)(NY-1)+ymi;
			tmp = mw->parseExpression(tmp,y,24);
			
			for (int j = 0;j < NX;j++) {
				double x = (xma-xmi)*j/(double)(NX-1)+xmi;
				QString tmp2 = mw->parseExpression(tmp,x,23);
				
				double z = parse((char *) tmp2.latin1());
			
				if(parse_errors()>0) {
					progress.cancel();
					KMessageBox::error(mw, i18n("Parse Error!\n Please check the given function."));
					return 1;
				}

				if (!finite(z)) z=0;

				//kdDebug()<<"z = "<<z<<endl;

				if (i == 0 && j==0 ) zmin=zmax=z;
				z<zmin?zmin=z:0;
				z>zmax?zmax=z:0;

				ptr[i*NX+j].setPoint(x,y,z);
			}
			if ( progress.wasCancelled() )
        			return 1;
		}

		if(graph != 0)
			p->getPlot(p->API())->getGraphList()->delGraph(item);

		if(zmax-zmin == 0) {
			zmin -= 1;
			zmax += 1;
		}

		LRange range[3];
		range[0] = LRange(xmi,xma);
		range[1] = LRange(ymi,yma);
		range[2] = LRange(zmin,zmax);

		kdDebug()<<"Z RANGE = "<<zmin<<' '<<zmax<<endl;

		Style *style = new Style(cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color(),widthle->text().toInt(),
			pencb->currentItem(),brushcb->currentItem());
		style->setBoxWidth(boxwidthle->text().toInt());
		style->setAutoBoxWidth(autobox->isChecked());
		Symbol *symbol = new Symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->text().toInt(),
				(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());

		Graph3D *g = new Graph3D(fun,label,range,SFUNCTION,P3D,style,symbol,ptr,NX,NY);
		AnnotateValues av(typecb->currentItem(),positioncb->currentItem(),distancele->text().toInt());
		g->setAnnotateValues(av);
		mw->addGraph3D(g,sheetcb->currentItem());
	}

	kdDebug()<<"FunctionDialog::apply_clicked() : DONE"<<endl;
	
	return 0;
}
