//LabPlot : FFTListDialog.h

#ifndef FFTLISTDIALOG_H
#define FFTLISTDIALOG_H

#include "ListDialog.h"

class FFTListDialog : public ListDialog
{
	Q_OBJECT
public:
	FFTListDialog(MainWin *mw, const char *name);
public slots:
	void setLibrary(int l) { 	library->setCurrentItem(l); }				//!< set library to use
	void setDirection(bool d=false) { transform->setCurrentItem(d); }	//!< set direction of transform (forward/backward)
	void setXValues(int v) {	xvalues->setCurrentItem(v); }				//!< set type of x values
	void setYValues(int v) {	yvalues->setCurrentItem(v); }				//!< set type of y values
	void setNrThreads(int t) {	threadsle->setText(QString::number(t)); }	//!< set number of threads
private slots:
	int apply_clicked();
private:
	QComboBox *library, *transform, *xvalues, *yvalues;
	KLineEdit *threadsle;
};

#endif // FFTLISTDIALOG_H
