//LabPlot : DumpDialog.h

#ifndef DUMPDIALOG_H
#define DUMPDIALOG_H

#include <qfont.h>
#include <qcheckbox.h>
#include "Worksheet.h"
#include "Dialog.h"
#include "FilterKexiDB.h"

class DumpDialog: public Dialog
{
	Q_OBJECT
public:
	DumpDialog(MainWin *mw, const char *name, int item);
public slots:
	void selectFile();
	
	void setFilename(QString fn) { filele->setText(fn); }		//!< set filename
	void exportHeader(bool b=true) { headercb->setChecked(b); }	//!< export header
	void setStartRow(int row) { startrow->setText(QString::number(row)); }	//!< set start row
	void setEndRow(int row) { endrow->setText(QString::number(row)); }	//!< set end row
	void setFileType(int t) { exportcb->setCurrentItem(t); }	//!< set file type to export
	void setSeparator(QString s) { slabel->setText(s); }		//!< set separating character
	void setImageFormat(int i) { ic->setCurrentItem(i); }		//!< set image format
	void setImageFormat(QString f) { ic->setCurrentText(f); }	//!< set image format
	void setCDFCompression(int c) { cdfcomcb->setCurrentItem(c); }	//!< set cdf file compression
	void setCDFEncoding(int c) { cdfenccb->setCurrentItem(c); }	//!< set cdf file compression
	void setAudioFormat(int f) { audioformatcb->setCurrentItem(f); }	//!< set audio format
	void setSampleRate(int s) { samplele->setText(QString::number(s)); }	//!< set audio sample rate
	void setBinaryType(int t) { binarytypecb->setCurrentItem(t); }	//!< set binary type

	void ok_clicked() { if(!apply_clicked()) accept(); }
	int apply_clicked();
private slots:
	void updateOptions(int item);
	void updateAudioFormat(int) { updateOptions(3); }
	void updateImageFormat(int) { updateOptions(4); }
	void wizardKexiDB(const QString &name);
	void finishKexiDB();
private:
	void dumpASCII(QTextStream *t, QString sep);
	void dumpCDF(QString filename);
	void dumpNETCDF(QString filename);
	void dumpAUDIOFILE(QString filename);
	void dumpIMAGE(QString filename);
	void dumpBINARY(QDataStream *d);
	void dumpKexiDB();
	Plot *plot;
	int item;
	KLineEdit *startrow, *endrow, *samplele;
	QLabel *slabel, *flabel, *cdfcomlabel, *cdfenclabel, *audioformatlabel, *samplelabel;
	KComboBox *sc, *ic, *exportcb, *cdfcomcb, *cdfenccb, *audioformatcb;
	QCheckBox *imagecb, *compresscb, *headercb;
	KComboBox *binarytypecb;
	FilterKexiDB *kexi;					//KexiDB
	KComboBox *driver, *databases, *tables;
	QLabel *connectionlabel, *tablelabel;
	KLineEdit *host, *user, *password;
};

#endif //DUMPDIALOG_H
