//LabPlot : Dialog.h

#ifndef DIALOG_H
#define DIALOG_H

#include <kdialog.h>
#include <qvbox.h>
#include <kpushbutton.h>
#include <qgroupbox.h>
#include <qcheckbox.h>
#include <qtabwidget.h>
#include <qvalidator.h>
#include <klineedit.h>
#include <klistbox.h>
#include <kcolorbutton.h>
#include <kcombobox.h>
#include "Worksheet.h"

#include "inputfilter.h"

class Dialog: public KDialog
{
	Q_OBJECT
public:
	Dialog(class MainWin *mw, const char *name);
	QVBox* surfaceStyle(QTabWidget *tw, bool fresh);
	QVBox* simpleStyle(QTabWidget *tw, Style *style, Symbol *symbol);
	void saveSimpleStyle();
	void saveSurfaceStyle();
public slots:
	void setDestination(int d) {sheetcb->setCurrentItem(d); }		//!< set current destination for new functions
	void setFilename(QString f) { filele->setText(f); }			//!< set filename for import widget
	void setFilter(int f) { filtercb->setCurrentItem(f); }			//!< set filter for importing
	void setSimplify(bool b=true) { simplifycb->setChecked(b); }		//!< set simplify whitespaces
	void setEmpty(bool b=true) { emptycb->setChecked(b); }			//!< allow empty entries in data file
	void setImportHeader(bool b=true) { headercb->setChecked(b); }		//!< import header from data file
	void setSeparator(int s) { sccb->setCurrentItem(s); }			//!< set separating character
	void setSeparator(QChar s) { sccb->setCurrentText(s); }			//!< set separating character
	void setComment(int s) { commcb->setCurrentItem(s); }			//!< set comment character
	void setComment(QChar s) { commcb->setCurrentText(s); }			//!< set comment character
	void setDataRange(int s, int e) { startle->setText(QString::number(s)); endle->setText(QString::number(e)); }
										//!< set range for importing data
	void setStart(int s) {startle->setText(QString::number(s));}
	void setEnd(int e) {endle->setText(QString::number(e));}

	// binary data
	void setVars(int v) { varle->setText(QString::number(v)); }		//!< number of vars for binary data
	void setBinaryType(int t) { binarytypecb->setCurrentItem(t); }		//!< set type for binary data
	
	void setStyle(Style *s);						//!< set Style
	void setSymbol(Symbol *s);						//!< set Symbol
protected:
	void resizeEvent(QResizeEvent *e);
	QVBox* annotateValuesTab(QTabWidget *tw, Graph *graph);
       	void importWidget(QVBox *vb,QString filename,InputFilter filter);
	double getBinaryValue(QDataStream *d, int type);
	QGroupBox *vbox, *gbox;
	class MainWin *mw;
	class Worksheet *p;
	class Spreadsheet *s;
	KPushButton *ok, *apply, *cancel;
	KLineEdit *filele;						// used from various dialogs
	KComboBox *cb2, *pencb, *brushcb, *sbrushcb;			// simple
	KComboBox *symbolcb, *symbolfillcb;					// simple
	KColorButton *color, *fcolor, *scolor, *sfcolor;			// simple
	QCheckBox *filled;									// simple
	KLineEdit *boxwidthle, *ssize, *widthle;							// simple
	QCheckBox *autobox, *ccb, *dcb, *coloredcb, *meshcb, *relativecb;	// surface
	KLineEdit *numberle, *thresholdle;						// surface
	KComboBox *pcb, *dbrushcb;							// surface
	KColorButton *contourcolor;							// surface
	KComboBox *typecb, *positioncb;						// annotatetab
	KLineEdit *distancele;								// annotatetab
	QCheckBox *simplifycb, *emptycb, *headercb;			// importWidget
	QLabel *seplabel, *commlabel, *startlabel, *endlabel;		// importWidget
	KLineEdit *startle, *endle;							// importWidget
	KComboBox *filtercb, *sccb, *commcb;					// importWidget
	QLabel *varlabel, *binarytypelabel;					// importWidget : binary
	KLineEdit *varle;
	KComboBox *binarytypecb;
	KComboBox *sheetcb;					// for destination selection (list dialogs+function/data dialog)
protected slots:
	void selectFile();
	void fileInfo();
	void updateFilter(int item);
	QStringList splitLine(QString line,QString sep, bool empty);
private:
	void fillBrushBox(KComboBox *cb,SType t, QColor c,FType f, QColor s);
	void fillSymbolBox(QColor c, FType f, QColor s, int b);
	void fillSymbolFillBox(SType t, QColor c, QColor s, int b);
private slots:
	void styleChanged();
	void symbolChanged();
};

#endif //DIALOG_H
