//LabPlot : ConvolutionListDialog.h

#ifndef CONVOLUTIONLISTDIALOG_H
#define CONVOLUTIONLISTDIALOG_H

#include "ListDialog.h"

class ConvolutionListDialog : public ListDialog
{
	Q_OBJECT
public:
	ConvolutionListDialog(MainWin *mw, const char *name);
public slots:
	void setType(bool t=false) {type->setCurrentItem(t); }		//!< convolute or deconvolute
	void setSet1(int s) { set1le->setText(QString::number(s)); }	//!< set first set to use
	void setSet2(int s) { set2le->setText(QString::number(s)); }	//!< set second set to use
	void setXValues(int v) {	xvalue->setCurrentItem(v); }		//!< set x value
private:
	KLineEdit *set1le, *set2le;
	KComboBox *type, *xvalue;
private slots:
	int apply_clicked();
};

#endif // CONVOLUTIONLISTDIALOG_H
