//LabPlot : Arrow.h

#ifndef ARROW_H
#define ARROW_H

#include <qcolor.h>
#include <qpainter.h>
#include <qstringlist.h>
#include "Point.h"

class Arrow
{
public:
	Arrow(bool l=0,bool e=false,double le=0.1,double a=30,bool f=true,
		QColor fc=QColor("blue"));
	QStringList Info();
	void save(QTextStream *t);
	void open(QTextStream *t,int version);
	bool Location() { return location; }
	void setLocation(bool l) { location=l; }
	bool Enabled() { return enabled; }
	void setEnabled(bool b=true) { enabled=b; }
	double Length() { return length; }
	void setLength(double l) { length=l; }
	double Angle() { return angle; }
	void setAngle(double a) { angle=a; }
	bool Filled() { return filled; }
	void setFilled(bool f=true) { filled=f; }
	QColor fillColor() { return fillcolor; }
	void setFillColor(QColor c) { fillcolor=c;}
	void setFillColor(QString c) { fillcolor=QColor(c);}
	void draw(QPainter *p, Point start, Point end, int X, int Y);
	
protected:
	bool location;		// 0-start, 1-end
	bool enabled;
	double length;	// 0..1
	double angle;
	bool filled;
	QColor fillcolor;
};

#endif //ARROW_H
