//LabPlot : ArrangePlotDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <math.h>
#include <qlabel.h>
#include <qhbox.h>
#include <qfontdialog.h>
#include <qslider.h>
#include <klocale.h>
#include "ArrangePlotDialog.h"

ArrangePlotDialog::ArrangePlotDialog(MainWin *mw, const char *name)
	: PlotDialog(mw, name)
{
	setCaption(i18n("Arrange Plots"));

	QHBox* hb = new QHBox(vbox);
        new QLabel(i18n("Arrangement : "),hb);
        xle = new KLineEdit(QString("2"),hb);
	xle->setValidator(new QIntValidator(1,4,xle));
	new QLabel(i18n(" x "),hb);
        yle = new KLineEdit(QString("2"),hb);
	yle->setValidator(new QIntValidator(1,4,yle));

	hb = new QHBox(vbox);
        new QLabel(i18n("Gap : "),hb);
        // TODO : Slider 0..0.4:0.05
	gaple = new KLineEdit(QString("0.05"),hb);
	
	gaple->setValidator(new QDoubleValidator(0,1,4,yle));

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));

	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

void ArrangePlotDialog::apply_clicked() {
	int nrx = xle->text().toInt();
	int nry = yle->text().toInt();
	// TODO : read value from slider
	double gap = gaple->text().toDouble();
	double sizex = (1.0-(nrx+1)*gap)/nrx;
	double sizey = (1.0-(nry+1)*gap)/nry;
	kdDebug()<<" SIZE : "<<sizex<<' '<<sizey<<endl;

	for (unsigned int i=0;i<p->NrPlots();i++) {
		double posx = ((i % nrx)+1) * gap+(i%nrx)*sizex;
		double posy = (i/nrx+1) * gap+(i/nrx)*sizey;

		p->getPlot(i)->setPosition(posx,posy);
		p->getPlot(i)->setSize(sizex,sizey);
		kdDebug()<<" POS : "<<posx<<' '<<posy<<endl;
	}
	
	p->updatePixmap();

	updateList();
}
