#!/bin/bash
# build LabPlot .rpm package on SuSE 9.3
# Stefan Gerlach, Jul 03 2005

LVERSION=1.5.0
SPEC=LabPlot.SuSE-9.3.spec

export CFLAGS="-O2"
export CXXFLAGS="-O2"
ARCH=i386
################################
DIR=LabPlot-"$LVERSION"
SRC=LabPlot-"$LVERSION".tar.gz

if [ ! -f "$SRC" ] ; then
	echo "$SRC not found!"
	exit
fi

if [ ! -f "$SPEC" ] ; then
	echo "$SPEC not found!"
	exit
fi

echo "%_topdir /tmp/build" > ~/.rpmmacros

mkdir -p /tmp/build/{SOURCES,SPECS,RPMS,SRPMS,BUILD} 

cp $SRC /tmp/build/SOURCES
cp $SPEC /tmp/build/SPECS

cd /tmp/build/SPECS/

rpmbuild -ba --buildroot /tmp/LabPlot $SPEC

