//LabPlot : GraphVTK.cc

#include <iostream>
#include <qstringlist.h>
#include <qprogressdialog.h>
#include <kdebug.h>
#include "GraphVTK.h"

using namespace std;

GraphVTK::GraphVTK(QString n, QString l,LRange r[3], LSource src, PType t, Style st, Symbol sy, int nr)
	: Graph(n,l,src,t,st,sy,nr)
{
	//TODO : Range ?
	range = new LRange[3];
	if (r) {
		for (int i=0;i<3;i++) {
			range[i].setMin(r[i].rMin());
			range[i].setMax(r[i].rMax());
		}
	}

	object=0;
	boxed=true;
	color = QColor(Qt::blue);
}

QStringList GraphVTK::Info()
{
	// TODO
	QStringList s;
	QString t;
	if(type==0)
		t=i18n("2D");
	else if (type==1)
		t=i18n("Surface");
	else if (type==2)
		t=i18n("3D");


	QString sh=i18n("NO");
	if (shown)
		sh=i18n("YES");

	s << name << t << sh;
	s << QString::number(number);
	s << QString(" 1 ");		// only 1 column
	s << QString::number(range[0].rMin()) + " .. " +QString::number(range[0].rMax());
	s << QString::number(range[1].rMin())+ " .. " +QString::number(range[1].rMax());
	s << QString::number(range[2].rMin())+ " .. " +QString::number(range[2].rMax());
	
	return s;
}

void GraphVTK::save(QTextStream *t) {
	//TODO
	/*QColor c = style.Color(), fc = style.FillColor(), sc = symbol.Color(), sfc = symbol.FillColor();

	saveGraph(t);
	*t<<number<<endl;
       	*t<<range[0].rMin()<<' '<<range[0].rMax()<<' '<<range[1].rMin()<<' '<<range[1].rMax()<<endl;
	*t<<type<<' '<<style.Type()<<' '<<c.name()<<endl;
	*t<<style.isFilled()<<' '<<fc.name()<<endl;
	*t<<symbol.Type()<<' '<<sc.name()<<endl;
	*t<<symbol.Size()<<' '<<symbol.isFilled()<<' '<<sfc.name()<<endl;
	*/
	//dump data
	//for (int i=0;i< number;i++) {
	//	*t<<ptr[i].X()<<' '<<ptr[i].Y()<<endl;
	//}
}

void GraphVTK::open(QTextStream *t,int version) {
	//TODO
	/*QString color;
	double xmin, xmax, ymin, ymax;
	int styletype, symboltype, symbolsize;
	int filled, symbolfilled;

	openGraph(t,version);
	
	if (version > 2)
		*t>>number;
	else if (version > 1 )
		*t>>name>>label>>number;
	else	// version == 0
		*t>>name>>number;

	kdDebug()<<"GraphVTK : "<<endl;
	kdDebug()<<"\tname : "<<name<<endl;
	kdDebug()<<"\tlabel : "<<label<<endl;
	kdDebug()<<"\tnumber  "<<number<<endl;

	*t>>xmin>>xmax>>ymin>>ymax;
	range[0].setMin(xmin);
	range[0].setMax(xmax);
	range[1].setMin(ymin);
	range[1].setMax(ymax);
	int tmptype;
	*t>>tmptype>>styletype>>color;
	type = (GType) tmptype;
	style.setType(styletype);
	style.setColor(color);
	*t>>filled>>color;
	style.setFilled(filled);
	style.setFillColor(color);
	*t>>symboltype>>color;
	symbol.setType(symboltype);
	symbol.setColor(color);
	*t>>symbolsize>>symbolfilled>>color;
	symbol.setSize(symbolsize);
	symbol.setFilled(symbolfilled);
	symbol.setFillColor(color);
	*/
	// read data
	/*double x, y;
	ptr = new Point[number];
	for (int i=0;i< number;i++) {
		*t>>x>>y;
		ptr[i].setPoint(x,y);

		//kdebug()<<x<<' '<<y<<endl;
	}*/
}
