// LabPlot : PlotVTK.cc

#include <stdlib.h>
#include <iostream>
#include <klocale.h>
#include <kdebug.h>

#ifdef HAVE_VTK
#include <vtkConeSource.h>
#include <vtkCubeSource.h>
#include <vtkSphereSource.h>
#include <vtkCylinderSource.h>
#include <vtkPointSource.h>
#include <vtkPolyDataMapper.h>
#include <vtkActor.h>
#include <vtkProperty.h>
#include <vtkBoxWidget.h>
#endif

#include "PlotVTK.h"

using namespace std;

PlotVTK::PlotVTK(Worksheet *p)
	: Plot(p)
{
	title = new Label(i18n("VTK-Plot"),QFont("Adobe Times",22),QColor(Qt::black));
	title->setPosition(0.4,0.04);
#ifdef HAVE_VTK
	ren = 0;
#endif
}

QStringList PlotVTK::Info() {
	QStringList s;
	s<<"VTK";
	s<<QString::number(position.X())+QString(" , ")+QString::number(position.Y());
	s<<QString::number(size.X())+QString(" X ")+QString::number(size.Y());
	if (transparent)
		s<<QString("yes");
	else
		s<<QString("no");
	s<<bgcolor.name();
	s<<gbgcolor.name();

	return s;
}

void PlotVTK::draw(QPainter *p, int w, int h) {
	//int w = worksheet->width(), h = worksheet->height();

	kdDebug()<<"PlotVTK::draw() w/h : "<<w<<' '<<h<<endl;
	int xmin = (int)(w*(size.X()*p1.X()+position.X()));
	int xmax = (int)(w*(size.X()*p2.X()+position.X()));
	int ymin = (int)(h*(size.Y()*p1.Y()+position.Y()));
	int ymax = (int)(h*(size.Y()*p2.Y()+position.Y()));

	kdDebug()<<"XMIN/MXAX/YMIN/YMAX = "<<xmin<<','<<xmax<<','<<ymin<<','<<ymax<<endl;
	kdDebug()<<"p1 = "<<p1.X()<<'/'<<p1.Y()<<" p2 = "<<p2.X()<<'/'<<p2.Y()<<endl;

	// background color
	p->setBrush(bgcolor);
	p->setPen(Qt::NoPen);
	p->drawRect((int)(w*position.X()),(int)(h*position.Y()),(int)(w*size.X()),(int)(h*size.Y()));

	// graph background color
	p->setBrush(gbgcolor);
	//TEST : p->setBrush(Qt::green);
	p->setPen(Qt::NoPen);

	kdDebug()<<"PLOTVTK : title->draw() pos:"<<position.X()<<' '<<position.Y()<<endl;
	kdDebug()<<" 			size:"<<size.X()<<' '<<size.Y()<<endl;
	title->draw(p,position,size,w,h);

	drawCurves(p,w,h);

	if(legend.enabled())
		legend.draw(p,type,graphlist,position,size,w,h);
}

void PlotVTK::drawCurves(QPainter *p, int w, int h) {
	kdDebug()<<"PlotVTK::drawCurves()"<<endl;
	int xmin = (int)(w*(size.X()*p1.X()+position.X()));
	int xmax = (int)(w*(size.X()*p2.X()+position.X()));
	int ymin = (int)(h*(size.Y()*p1.Y()+position.Y()));
	int ymax = (int)(h*(size.Y()*p2.Y()+position.Y()));

	kdDebug()<<"xmin/xmax ymin/ymax : "<<xmin<<'/'<<xmax<<' '<<ymin<<'/'<<ymax<<endl;
	kdDebug()<<"width/height : "<<w<<'/'<<h<<endl;

#ifdef HAVE_VTK
	// TODO : read *.vtk data	-> vtkDataReader

	// TODO : vtkQtImageViewer	-> see image example

	if (ren == 0) {
		ren = vtkRenderer::New();

		vtkQtRenderWindow *renWindow = vtkQtRenderWindow::New();
		renWindow->AddRenderer(ren);
		renWindow->SetWindowName("VTK-LabPlot");
		// TODO : window size  : renWindow->setSize(300,300);

		vtkQtRenderWindowInteractor *iren = vtkQtRenderWindowInteractor::New();
   		iren->SetRenderWindow(renWindow);

		for (unsigned int i=0; i < graphlist->getNumber() ; i++) {
			if(graphlist->getGraph(i)->isShown() == FALSE)
				continue;
			GraphVTK *g = graphlist->getGraphVTK(i);

			vtkPolyDataSource *object;

			switch (g->getObject()) {
			case 0:
				object = vtkConeSource::New();
				break;
			case 1:
				object = vtkCubeSource::New();
				break;
			case 2:
				object = vtkSphereSource::New();
				break;
			case 3:
				object = vtkCylinderSource::New();
				break;
			case 4:
				object = vtkPointSource::New();	// -> Points in 3d (3d data ?)
				break;
			}

			// TODO : object attributes
			// cone	: int resolution,double height, double radius
			//object->SetResolution(8);

			vtkPolyDataMapper *objectMapper = vtkPolyDataMapper::New();
			objectMapper->SetInput(object->GetOutput());

			vtkActor *objectActor = vtkActor::New();
			objectActor->SetMapper(objectMapper);

			QColor color = g->getColor();
			objectActor->GetProperty()->SetColor(color.red()/255.0,color.green()/255.0,color.blue()/255.0);

			//vtkActor2D		: 2d data ?

			if (g->getBoxed()) {
				vtkBoxWidget *boxWidget = vtkBoxWidget::New();
  				boxWidget->SetInteractor(iren);
 				//boxWidget->SetPlaceFactor(1);

				boxWidget->On();
			}

			ren->AddActor(objectActor);
		}
		iren->show();
	}
#endif
}
